#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_DMA_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer5 overflow Interrupt(TF5) => TF5_Flag
****************************************************************/
uint8_t TF5_Flag, TF6_Flag;

void main()
{
    unsigned char count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer5 interrupt (T5IE) = Enable;
     *  2. Enable DMA interrupt(EDMA) = Enable;
     *  3. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER5_IT_Cmd(MW_ENABLE);
    __DRV_DMA_IT_Enable();
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer5 Initialized
     *  Interrupt time => (1 / (SYSCLK/12)) * 1000 * 100 = 1 S
     ****************************************************************/
    __DRV_TIMER5_Clock_Source_Select(TIMER5_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER5_Set16BitCounter(55536);
    __DRV_TIMER5_Set16Bit_AutoReloadValue(55536);
    __DRV_TIMER5_Run_Cmd(MW_ENABLE);

    while (1)
    {
        if (TF5_Flag)
        {
            count += 1;
            if (count == 100)
            {
                __DRV_GPIO_InversePinP5(P55);
                count = 0;
            }
            TF5_Flag = 0;
        }
    }
}

/****************************************************************
Timer5, Timer6 interrupt
The Timer5 has TF5 flag to trigger the Timer5 interrupt.
The Timer6 has TF6 flag to trigger the Timer6 interrupt.
****************************************************************/
void TIMER5_TF5_TF6_ISR(void) interrupt DMA_ISR_VECTOR
{
    if (DRV_TIMER5_GetTF5() == 1)
    {
        TF5_Flag = 1;
        DRV_TIMER5_ClearTF5();
    }

    if (DRV_TIMER6_GetTF6() == 1)
    {
        TF6_Flag = 1;
        DRV_TIMER6_ClearTF6();
    }
}
