#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
    Variables
    Temp_TH1 => Store the TH1 value
    Temp_TL1 => Store the TL1 value
    ****************************************************************/
    uint8_t Temp_TH1 = 0, Temp_TL1 = 0;

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer1 Initialized
     *  LED Toggle time => (1/(SYSCLK/12)) * 60000) = 0.06 S
     ****************************************************************/
    __DRV_TIMER1_Mode_Select(TIMER1_MODE1_16BIT_TIMER);
    __DRV_TIMER1_Clock_Source_Select(TIMER1_CLOCK_SOURCE_SYSCLK_DIV_12);

    while (1)
    {
        /****************************************************************
         *  Timer1 Global control running
         *  Run to 0xEA60(60000) -> stop running -> Inverse P55(LED4) -> Reload 0x0000
         ****************************************************************/
        __DRV_TIMER_Globel_Enable_Cmd(TR1E);
        while (Temp_TH1 < 0xEA || Temp_TL1 < 0x60)
        {
            Temp_TH1 = DRV_TIMER1_GetTH1();
            Temp_TL1 = DRV_TIMER1_GetTL1();
        }
        __DRV_TIMER_Globel_Stop_Cmd(T1SC);
        Temp_TH1 = Temp_TL1 = 0;
        __DRV_GPIO_InversePinP5(P55);
        __DRV_TIMER_Globel_Reload_Cmd(T1RLC);
    }
}
