#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer0 Initialized
     *  LED Toggle time => (1/ILRCO * 6554) = 0.2048 S
     ****************************************************************/
    __DRV_TIMER0_Mode_Select(TIMER0_MODE1_16BIT_TIMER);
    __DRV_TIMER0_Clock_Source_Select(TIMER0_CLOCK_SOURCE_ILRCO);

    while (1)
    {
        /****************************************************************
         *  Timer0 Global control
         *  Run to 0x199A(6554) -> stop running -> Inverse P55(LED4) -> Reload 0x0000
         ****************************************************************/
        __DRV_TIMER_Globel_Enable_Cmd(TR0E);
        while (DRV_TIMER0_GetTH0() != 0x19 || DRV_TIMER0_GetTL0() != 0x9A);
        __DRV_TIMER_Globel_Stop_Cmd(T0SC);
        __DRV_GPIO_InversePinP5(P55);
        __DRV_TIMER_Globel_Reload_Cmd(T0RLC);
    }
}
