/*********************************************************************
*    Project: MG82F6D64-DEMO
*			MG82F6D64 LQFP64_V10 EV Board (TH210A)
*			CpuCLK=12MHz, SysCLK=12MHz
*    Description:
*			UART2Mode4 (SPI Master)
*			SPICLK <-->TXD	P33
*			MOSI	<-->RXD  P32
*			MISO	<-->S0MI P66
*    Note:
*			
*    Creat time:
*    Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D64.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D64.H"
#include ".\include\API_Uart_BRGRL_MG82F6D64.H"

/*************************************************
*Set SysClk (MAX.50MHz)
*Selection: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	33170000,36000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)
#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

#define SPI_NSS		P34

sfr UARTSPICLK		= 0xBB;

// Clock polarity(CPOL)
#define SPICLK_LOW	0	// SPICLK LOW
#define SPICLK_HIGH	1	// SPICLK HIGH
#define SPI_CPOL  SPICLK_LOW	

// Data order
#define LSB	0	// LSB
#define MSB	1	// MSB
#define SPI_DORD	MSB

// Clock source
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_12	1	// SYSCLK/12
#define SPI_CLOCK	SPI_CLK_SYSCLK_4

/*************************************************
*Function:     	void DelayXus(u16 xUs)
*Description:   	delay,unit:us
*Input:     		u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     	void DelayXms(u16 xMs)
*Description:    delay,unit:ms
*Input:     		u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   	void InitPort()
*Description:	Initialize IO Port
*Input:   
*Output:   		
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);
	PORT_SetP3PushPull(BIT4);				// Set P34 as Push Pull
	PORT_SetP3PushPull(BIT2|BIT3);			// Set P32P33 as Push-Pull
	PORT_SetP6OpenDrainPu(BIT6);			// set P66 as open-drain with pull-high
}

/***********************************************************************************
*Function:   	u8 Uart2SPITransceiver(u8 ToSend)
*Description:   	UART1 SPI Master transmit and receive data
*Input:   		u8 ToSend
*Output:     
*************************************************************************************/
u8 Uart2SPITransceiver(u8 ToSend)
{
	u8 x;
	SFR_SetPage(3);
	S2BUF=ToSend;
	while(TI2==0);
	TI2=0;
	x=S2BUF;
	SFR_SetPage(0);
	return x;
}

/***********************************************************************************
*Function:   	void InitUart2_SPI_Master(void)
*Description:   	Initialize Uart2, SPI Master
*Input:   
*Output:     
*************************************************************************************/
void InitUart2_SPI_Master(void)
{
	P33=1;
	UART2_SetModeSPIMaster();			// UART2 Mode: SPI-Master
	PORT_SetS0MIS1MIS2MIS3MI_P57P67P66P65();					// MISO Pin:P66
	UART2_SetRxTxP32P33();				//  RXMOSI->P32,TX(SPI_CLK)->P33
#if (SPI_CLOCK == SPI_CLK_SYSCLK_4)
	UART2_SetSPIClock_SYSCLKDiv4();		//  Clock source: SYSCLK/4
#else
	UART2_SetSPIClock_SYSCLKDiv12();	// Clock source: SYSCLK/12
#endif
#if (SPI_DORD==MSB)
	UART2_SetDataMSB();
#else
	UART2_SetDataLSB();
#endif

#if (SPI_CPOL==SPICLK_LOW)
	UARTSPICLK = 0x25;					// SPICLK = Low

#endif

	
}

/***********************************************************************************
*Function:       void InitSystem(void)
*Description:    Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitUart2_SPI_Master();
}

void main()
{
	InitSystem();
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;	
	while(1)
	{
		DelayXms(100);
		LED_G_0 = !LED_G_0;	
		SPI_NSS=0;
		Uart2SPITransceiver(0x05);	
		SPI_NSS=1;
	}

}


