/**
 ******************************************************************************
 *
 * @file        MG82F6D64_GPLCRC_DRV.H
 *
 * @brief       This is the C code format driver head file.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V1.00
 * @date        2023/08/14
 * @copyright   Copyright (c) 2019 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IF"  without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the world wide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */


#ifndef _MG82F6D64_GPLCRC_DRV_H
#define _MG82F6D64_GPLCRC_DRV_H


/**
 *******************************************************************************
 * @brief       Select CRC0DA is CRC0DI
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    __DRV_GPGCRC_SelectCRC0DI();
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPGCRC_SelectCRC0DI()        AUXR1 |= (CRCDS1 | CRCDS0)


/**
 *******************************************************************************
 * @brief       Select CRC0DA is CRC0SL
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    __DRV_GPGCRC_SelectCRC0SL();
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPGCRC_SelectCRC0SL()        AUXR1 &= ~(CRCDS1 | CRCDS0)


/**
 *******************************************************************************
 * @brief       Select CRC0DA is CRC0SH
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    __DRV_GPGCRC_SelectCRC0SH();
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPGCRC_SelectCRC0SH()\
        MWT(\
           AUXR1 &= ~(CRCDS1 | CRCDS0);\
           AUXR1 |= CRCDS0;\
        )


/**
 *******************************************************************************
 * @brief       Set GPLCRC CRC0SI data
 * @details
 * @param[in]   __DATA__ : Set GPLCRC data to CRC0SI (0x00 ~ 0xFF)
 * @return      None
 * @note
 * @par         Example
 * @code
 *    __DRV_GPLCRC_SetCRC0SI(0xFF);
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPLCRC_SetCRC0SI(__DATA__)\
        MWT(\
        AUXR1 |= (CRCDS1 | CRCDS0);\
        CRC0DA = (__DATA__);\
    )


/**
 *******************************************************************************
 * @brief       Set GPLCRC CRC0SL data
 * @details
 * @param[in]   __DATA__ : Set GPLCRC data to CRC0SL (0x00 ~ 0xFF)
 * @return      None
 * @note
 * @par         Example
 * @code
 *    __DRV_GPLCRC_SetCRC0SL(0xFF);
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPLCRC_SetCRC0SL(__DATA__)\
        MWT(\
        AUXR1 &= ~(CRCDS1 | CRCDS0);\
        CRC0DA = (__DATA__);\
    )


/**
 *******************************************************************************
 * @brief       Set GPLCRC CRC0SH data
 * @details
 * @param[in]   __DATA__ : Set GPLCRC data to CRC0SH (0x00 ~ 0xFF)
 * @return      None
 * @note
 * @par         Example
 * @code
 *    __DRV_GPLCRC_SetCRC0SH(0xFF);
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPLCRC_SetCRC0SH(__DATA__)\
        MWT(\
        AUXR1 &= ~(CRCDS1 | CRCDS0);\
        AUXR1 |= CRCDS0;\
        CRC0DA = (__DATA__);\
    )


/**
 *******************************************************************************
 * @brief       Set GPLCRC CRC0DA data
 * @details
 * @param[in]   __DATA__ : Set GPLCRC data to CRC0DA (0x00 ~ 0xFF)
 * @return      None
 * @note
 * @par         Example
 * @code
 *    __DRV_GPLCRC_SetCRC0DA(0xFF);
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPLCRC_SetCRC0DA(__DATA__)       CRC0DA = (__DATA__)


/**
 *******************************************************************************
 * @brief       Get GPLCRC CRC0SL data
 * @details
 * @param[in]   __DATA__ : Get GPLCRC CRC0SL data (0x00 ~ 0xFF)
 * @return      None
 * @note
 * @par         Example
 * @code
 *    uint8_t tmp8;
 *    __DRV_GPLCRC_GetCRC0SL(tmp8);
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPLCRC_GetCRC0SL(__DATA__)\
        MWT(\
        AUXR1 &= ~(CRCDS1 | CRCDS0);\
        (__DATA__) = CRC0DA;\
    )


/**
 *******************************************************************************
 * @brief       Get GPLCRC CRC0SH data
 * @details
 * @param[in]   __DATA__ : Get GPLCRC CRC0SH data (0x00 ~ 0xFF)
 * @return      None
 * @note
 * @par         Example
 * @code
 *    uint8_t tmp8;
 *    __DRV_GPLCRC_GetCRC0SH(tmp8);
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPLCRC_GetCRC0SH(__DATA__)\
        MWT(\
        AUXR1 &= ~(CRCDS1 | CRCDS0);\
        AUXR1 |= CRCDS0;\
        (__DATA__) = CRC0DA;\
    )


/**
 *******************************************************************************
 * @brief       Get GPLCRC CRC0DA data
 * @details
 * @param[in]   __DATA__ : Get GPLCRC CRC0DA data (0x00 ~ 0xFF)
 * @return      None
 * @note
 * @par         Example
 * @code
 *    uint8_t tmp8;
 *    __DRV_GPLCRC_GetCRC0DA(tmp8);
 * @endcode
 *******************************************************************************
 */
#define __DRV_GPLCRC_GetCRC0DA(__DATA__)\
        MWT(\
        AUXR1 &= ~(CRCDS1 | CRCDS0);\
        AUXR1 |= CRCDS0;\
        (__DATA__) = CRC0DA;\
    )


void DRV_CRC_Seed(uint8_t CRC0SH_t,uint8_t CRC0SL_t);

#endif  //_MG82F6D64_GPLCRC_DRV_H
