#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P35 used for T1CKO
     *  2. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P3ModeSelect(P35_PushPull);
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer1 Initialized
     *  PWM Duty high = 90.2% (230/255)
     *  PWM Duty low = 9.8% (25/255)
     ****************************************************************/
    __DRV_TIMER1_Mode_Select(TIMER1_MODE0_8BIT_PWM);
    __DRV_TIMER1_Clock_Source_Select(TIMER1_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER1_SetHighByte(25);
    __DRV_TIMER1_T1CKO_Cmd(MW_ENABLE);
    __DRV_TIMER1_Run_Cmd(MW_ENABLE);

    while (1)
    {
        __DRV_GPIO_WriteP5(P55, P35);
    }
}
