/**
 ******************************************************************************
 *
 * @file        MG82F6D64_GPLCRC_DRV.c
 *
 * @brief       This is the C code format driver head file.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V1.01
 * @date        2024/02/05
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2019 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IS"  without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These __STATE__ments agree with the world wide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

#include "MG82F6D64_CONFIG.h"

/**
*******************************************************************************
* @brief       Set GPL CRC Seed.
* @details     
* @return      
* @note        None
* @par         Example
* @code
               DRV_CRC_Seed(0,0)
 * @endcode
*******************************************************************************
*/
void DRV_CRC_Seed(uint8_t CRC0SH_t,uint8_t CRC0SL_t)
{
    __DRV_GPLCRC_SetCRC0SH(CRC0SH_t);//CRC seed High byte
    __DRV_GPLCRC_SetCRC0SL(CRC0SL_t);//CRC seed Low byte
    __DRV_GPGCRC_SelectCRC0DI();
}
