
#include "REG_FA206.H"
#include "typedef.h"
#include "config.h"
#include "motor_parameter.h"

extern BYTE Status;     // Motor status
U8 OV_cnt = 0;

//-----------------------------------------------------------------------------
// External Interrupt 0 initial 
//-----------------------------------------------------------------------------
void OCDet_EX0Init (void)
{ 
    EX0 = 1;
    XICFG = INT0IS1 | X0FLT;       // switch EXT0 to P1.6 with 3 clks filter 
    
//     IP0H |= PX0H;
//     PX0L = 1;
}

//-----------------------------------------------------------------------------
// External Interrupt 0 (for over current ISR)
//-----------------------------------------------------------------------------
void EX0_ISR (void) interrupt 0    
{
    // set error state
    OV_cnt ++;
    if (OV_cnt < OV_max) {
        return;
    }
    
    disable_PCA ();
    EIE1 &= ~EKB;            // disable EKBI interrupt
    ET1 = 0;
    Status = OVERCURR;
    
    return;

}

        


