
#include "REG_FA206.H"
#include "typedef.h"
#include "config.h"
#include "motor_parameter.h"
#include <math.h>

extern U16 TargetRPM;
extern U8 State;

U8 LINState;
U8 LINData;
U8 LINTime;                 // for LIN trigger time


//-----------------------------------------------------------------------------
// LIN_Init - called from main
//-----------------------------------------------------------------------------
void LIN_Init (void)
{
    SFRPI = 0x01;
    
	S1BRC = S1BRT = 178;		// 9600 bps @ 12MHz
    S1CFG = SM31 | S1DOR | S1TR | S1TX12;
    S1CON = 0x50;
    S1CFG1 = 0x00;              // LIN configure
                
    SFRPI = 0x00;
    AUXR1 |= P3S1;              // set P33 & P34 to RXD1 & TXD1
    
    EIE1 |= ES1;
 
    EIP1H &= ~PS1H;
    EIP1L &= ~PS1L;
    
    LINState = LIN_in_RECEIVE;
    
}

//-----------------------------------------------------------------------------
// UART1_ISR() receive command 
//-----------------------------------------------------------------------------
void UART1_ISR (void) interrupt 12
{ 
    EA = 0;
    SFRPI = 1;
    
    if (RI1) {
        LINData = S1BUF;
        RI1 = 0;
        SFRPI = 0;
        EA = 1;
        
        if (LINState != LIN_in_RECEIVE) return;
        LINState = LIN_RECEIVE_DATA;
    } else if (TI1) {
        TI1 = 0;
        SFRPI = 0;
        EA = 1;

        if (LINState != LIN_Transfer_WAIT) return;
        LINState = LIN_TRANSFED_DATA;
        LINTime = 0;
    }
    
    return;
}

//-----------------------------------------------------------------------------
// LIN receive/trandfer routine 
//-----------------------------------------------------------------------------
void LIN_COMMUNICATION ()
{
    static U8 commandIndex = 0x03;
    static U8 command[4];
    WTYPE tempRPM;
    

    switch (LINState) {
    case LIN_in_RECEIVE:
        if (State == Normal_RUN) {
            if (LINTime > 120) {
                disable_PCA ();
                EIE1 &= ~EKB;            
                State = COMMUNICATIONError;
            }
        }
        break;
    case LIN_RECEIVE_DATA:
        // receive 4 byte command
        if (LINTime > 25) commandIndex = 0x03;   
        LINTime = 0;
        commandIndex ++;
        commandIndex &= 0x03;
        command [commandIndex] = LINData;

        if (commandIndex != 0x03) {
            LINState = LIN_in_RECEIVE;
            return;
        }

        // checksum check?
        commandIndex = command [0] + command [1] + command [2];
        if (commandIndex != command [3]) {
            commandIndex = 0x03;        // have wrong checksum
            LINState = LIN_in_RECEIVE;
            return;
        }
        LINState = LIN_ANALYZE_CMD;
        return;
        
    case LIN_ANALYZE_CMD:
        // analyze command
        switch (command [0]) {
        case LIN_SPEED_CMD:
            tempRPM.B[0] = command [1];
            tempRPM.B[1] = command [2];
            if (tempRPM.W != 0x00) {
                TargetRPM = tempRPM.W;
                if (State != Normal_RUN) {
                    LINTime = 0;
                    LINState = LIN_in_TRANSFER;
                    return;
                }
                LINState = LIN_in_RECEIVE;
                return;
            }
        case LIN_STOP_CMD:
            disable_PCA ();                
            EIE1 &= ~EKB;                   // disable EKBI interrupt
            while (1) {
                ISPCR = ISPEN | SRST ;      // software reset
            }
            
        case LIN_RESET_CMD:
            while (1) {
                ISPCR = ISPEN | SRST ;      // software reset
            }
            
        default:
            LINState = LIN_in_RECEIVE;
            break;
        }
        
    case LIN_in_TRANSFER:
        if (LINTime < 2) return;
        switch (State) {
        case HallError:
            command [0] = 0x5A;
            command [1] = 0x01;
            command [2] = 0x04;
            command [3] = 0x5F;
            break;
        case STUCK:
            command [0] = 0x5A;
            command [1] = 0x01;
            command [2] = 0x03;
            command [3] = 0x5E;
            break;
        case STARTFAIL:
            command [0] = 0x5A;
            command [1] = 0x01;
            command [2] = 0x02;
            command [3] = 0x5D;
            break;
        case COMMUNICATIONError:
            command [0] = 0x5A;
            command [1] = 0x01;
            command [2] = 0x05;
            command [3] = 0x60;
            break;
        default:
            LINState = LIN_in_RECEIVE;
            return;
        }
        SFRPI = 0x01;
        S1CFG1 = TXRX;
        S1BUF = command [0];
        SFRPI = 0x00;
        LINState = LIN_Transfer_WAIT;
        commandIndex = 0x00;    
        break;
    
    case LIN_Transfer_WAIT:
        break;
            
    case LIN_TRANSFED_DATA:
        if (LINTime < 2) return;
        
        commandIndex ++;
        commandIndex &= 0x03;
    
        if (commandIndex == 0x00) {
            commandIndex = 0x03;
            LINState = LIN_in_RECEIVE;
            SFRPI = 0x01;
            S1CFG1 = 0x00;              // LIN configure
            SFRPI = 0;
            return;
        }
        
        
        SFRPI = 0x01;
        S1CFG1 = TXRX;
        S1BUF = command [commandIndex];
        SFRPI = 0x00;
        LINState = LIN_Transfer_WAIT;
        break;
        
    default:
        break; 
        
    }
}
