
/*
    Q KBI ϹqʬO pattern AҥH|ê
*/

//#include "REG_FA206.H"
#include "REG_MG82F6D17.H"
#include "typedef.h"
#include "config.h"
#include "motor_parameter.h"
#include <intrins.h>

extern LTYPE CaledPLLT;     // for calculate timer2 RCAP2H:L
extern U8 State;

// 	Hall sensor pattern
code BYTE KBIPattern[6]= {	
//5b32    0x50, 0x40, 0x60, 0x20, 0x30, 0x10      // FORWARD
    0x42, 0x40, 0x60, 0x20, 0x22, 0x02
};

U8 MtrIndex;                    // index for H-bridge output
U8 KBIIndex;                    // Hall sensor pattern index 
bit CommutateSearch;            // when it meet index '0' of Hall, It sets '1' 
LTYPE commutateTx6;             // the period time of Hall (0->5)
bit SynchronizationFlag;        // commutate signal for synchronization

//-----------------------------------------------------------------------------
// setup keypad pattern
//-----------------------------------------------------------------------------
void SetupKeypadPattern (void)
{
//     U8 PresentP1;
    
    EIE1 &= ~EKB;            

    // ھ Hall AAMwU@Ĳo KBI 󬰦
    KBIIndex = 0x00;
    KBPATN = KBIPattern[KBIIndex];
//5b32    KBMASK = 0x70;          // KBPATN6~4
    KBMASK = 0x62;              // KBPATN6 5 1  
    KBCON = 0x02;           
//5b32    AUXR6 |= P1KBIH;        // P1.0~P1.3
    KBCON = 0x02;           
    _nop_ ();
    KBCON = 0x02;           
    
    while ((KBCON & KBIF) == 0x00) {
        KBIIndex ++;
        KBPATN = KBIPattern[KBIIndex];
        KBCON = 0x02;           
        _nop_ ();
        if (KBIIndex == 6) {
            State = HallError;          // Hall error ****************
            return;
        }
    }
    MtrIndex = KBIIndex;

    KBIIndex ++;
    if (KBIIndex > 5) KBIIndex = 0;
    
    // ]wU KBI Ĳo
    KBPATN = KBIPattern[KBIIndex];
//5b32    KBMASK = 0x70;          // KBPATN6~4
    KBMASK = 0x62;              // KBPATN6 5 1 
    KBCON = 0x02;           
    
    EIE1 |= EKB;            // Enable EKBI
    EIP1H |= PKBH;          // priority
    EIP1L |= PKBL;          // priority
}

//-----------------------------------------------------------------------------
// KB-ISR (commutate routine)
//-----------------------------------------------------------------------------
void KBIISR (void) interrupt 11
{

    // ]wU Hall sensor pattern ĲoA 
    MtrIndex = KBIIndex;
    KBIIndex ++;
    if (KBIIndex == 6) { KBIIndex = 0; }

    KBPATN = KBIPattern[KBIIndex];  // reset interrupt pattern 
    KBCON = 0x02;                   // clear interrupt flag
    
    if (MtrIndex == 0) {
        CommutateSearch = 1;
        
        // OsZWۮɶ
        commutateTx6.LW[1].B[0] = TH0;
        commutateTx6.LW[1].B[1] = TL0;
        
        CaledPLLT.LW[0].B[1] = commutateTx6.LW[0].B[1];
        CaledPLLT.LW[1].B[0] = commutateTx6.LW[1].B[0];
        CaledPLLT.LW[1].B[1] = commutateTx6.LW[1].B[1];
        
        commutateTx6.Ll = 0;
        
        TH0 = 0x00;
        TL0 = 0x00;
    } 

    // commutate single & sunchronization
    SynchronizationFlag = 1;//MtrIndex & 0x01;
    return;

}