/**
 * @file    opamp_base.c
 * @author  MegawinTech Application Team
 * @version V1.0.1
 * @date    22-Aug-2024
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _OPAMP_BASE_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "opamp_base.h"

/**
  * @addtogroup MG32F04P032_LibSamples
  * @{
  */

/**
  * @addtogroup OPAMP
  * @{
  */

/**
  * @addtogroup OPAMP_Base
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void OPAMP1_Configure(void)
{
    GPIO_InitTypeDef GPIO_InitStruct_A,GPIO_InitStruct_B;
    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);
    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOB, ENABLE);

    GPIO_StructInit(&GPIO_InitStruct_A);
    GPIO_InitStruct_A.GPIO_Pin  = GPIO_Pin_6 | GPIO_Pin_7 ;
    GPIO_InitStruct_A.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct_A);

    GPIO_StructInit(&GPIO_InitStruct_B);
    GPIO_InitStruct_B.GPIO_Pin  = GPIO_Pin_0 ;
    GPIO_InitStruct_B.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOB, &GPIO_InitStruct_B);

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_OPA1, ENABLE);

    OPAMP_ModeConfig(OPAMP1, OPAMP_Mode_LowPower);

    OPAMP_Cmd(OPAMP1, ENABLE);
}
/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void OPAMP2_Configure(void)
{
    GPIO_InitTypeDef GPIO_InitStruct_A;
    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

    GPIO_StructInit(&GPIO_InitStruct_A);
    GPIO_InitStruct_A.GPIO_Pin  = GPIO_Pin_3 | GPIO_Pin_4 | GPIO_Pin_5 ;
    GPIO_InitStruct_A.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct_A);

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_OPA2, ENABLE);

    OPAMP_ModeConfig(OPAMP2, OPAMP_Mode_LowPower);

    OPAMP_Cmd(OPAMP2, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void OPAMP_Base_Sample(void)
{
    printf("\r\nTest %s", __FUNCTION__);

    OPAMP1_Configure();
//    OPAMP2_Configure();

    while(1)
    {
        PLATFORM_LED_Toggle(LED1);
        PLATFORM_DelayMS(100);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

