/*
*/	
#define	_TWI_C

#include	"Incfile.h"

void TWI0_ISR () interrupt  INT_VECTOR_TWI0
{
	switch ( SISTA )
	{
		case 0x08:	// a start has been transmitted.
			CLR_TWI_STA();
			SIDAT = SlaveAddress; //SLA + W
			break;
		case 0x20:	// SLA+W transmited, NOT ACK received
			TWI0Status = TWI_RW_FAIL;
			break;
		case 0x18:	// SLA+W transmited, ACK received 
			SIDAT = SlaveRegAddr;
			break;
		case 0x28:	// DATA transmited, ACK received
			SEND_TWI_STA();  	//restart
			break;
		case 0x30:	// DATA transmited, NOT ACK received
			TWI0Status = TWI_RW_FAIL;
			break;
		case 0x10:	// restart transmited
			CLR_TWI_STA();
			SIDAT = SlaveAddress | 0x01;	//SLA + R
			break;
			
		case 0x40:	// SLA+R transmited, ACK received 
			SlaveDataCnt=0;
			if ( SlaveDataLen > 1 )
			{
				SEND_TWI_ACK();
			}
			else
			{
				SEND_TWI_NOACK();
			}
			break;
		case 0x50:	// Data received
			SlaveData = SIDAT;
			SlaveDataCnt++;
			if(SlaveDataCnt<(SlaveDataLen-1))
			{
				SEND_TWI_ACK();
			}
			else
			{
				SEND_TWI_NOACK();
			}
			break;
			
		case 0x58:	// All data received
			SlaveData = SIDAT;
			TWI0Status = TWI_RW_SUCCESS;
			SEND_TWI_STO();			// ֹͣλ
			break;
		case 0x38:	// Arbitration lost in SLA+W	OR Data bytes
			TWI0Status = TWI_RW_FAIL;
			break;
		case 0x48:	// SLA+R transmited, NOT ACK received
			TWI0Status = TWI_RW_FAIL;
			break;
		default:	//ͨѶд´
			TWI0Status = TWI_RW_FAIL;
			break;
	}
	if(TWI0Status==TWI_RW_FAIL)
	{
		SEND_TWI_STO(); 		// ֹͣλ
	}
	CLR_TWI_SI();		//  SI
	
}

/***********************************************************************************
:   void ReStartTWI0(void)
:   TWI0 
:   
ز:     
*************************************************************************************/
void ReStartTWI0(void)
{
	SICON = CR2 | CR0;		// SYSCLK = 24M, SYSCLK / 256 = 93.75k
	nop();
	nop();
	nop();
	SICON |= ENSI;			// TWIģ
}

void TWI0Proc(void)
{
	switch(TWI0Status)
	{
		case TWI_RW_IDLE:
			if(TWI0Runtime==0)
			{
				LED_RUN=0;
				CLR_TWI_I();
				ReStartTWI0();
				SlaveAddress=0xA0;
				SlaveDataLen=1;
				SlaveRegAddr++;
				TWI0Ovtime=TWI_OV_TIME_MAX;
				TWI0FailCnt=0;
				TestOutStr("\nTest ");
				TestOutHex(SlaveRegAddr);
				SEND_TWI_STA();
				CLR_TWI_SI();
				SET_TWI_I();
				TWI0Status=TWI_RW_WORKING;
			}
			break;
		case TWI_RW_WORKING:
			if(TWI0Ovtime==0)
			{
				LED_RUN=1;
				SEND_TWI_STO(); 		// ֹͣλ
				CLR_TWI_SI();
				TWI0Runtime=TWI_RUN_TIME_MAX;
				TWI0Status=TWI_RW_IDLE;
			}
			break;
		case TWI_RW_SUCCESS:
			TestOutHex(SlaveData);
			CLR_TWI_I();
			TWI0Runtime=TWI_RUN_TIME_MAX;
			TWI0Status=TWI_RW_IDLE;
			LED_RUN=1;
			break;
		case TWI_RW_FAIL:
			TWI0FailCnt++;
			if(TWI0FailCnt<TWI_FAIL_CNT_MAX)
			{
				ReStartTWI0();
				SEND_TWI_STA();
				CLR_TWI_SI();
				SET_TWI_I();
				TWI0Status=TWI_RW_WORKING;
			}
			else
			{
				TWI0Runtime=TWI_RUN_TIME_MAX;
				TWI0Status=TWI_RW_IDLE;
				LED_RUN=1;
			}
			break;
		default:
			TWI0Status=TWI_RW_FAIL;
			break;
	}
}


