/*
*/	
#define	_MCU_C

#include	"Incfile.h"

// ʱ0ж,1ms
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TL0=TIMER_1MS_TL;
	TH0=TIMER_1MS_TH;
	
	if(delayNmS!=0) delayNmS--;
	if(TWI0Ovtime !=0) TWI0Ovtime--;
	if(TWI0Runtime!=0) TWI0Runtime--;

}


/***********************************************************************************
:   void InitInterrupt(void)
:   жϳʼ
:   
ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	ET0=1;						// ʹܶʱ0ж
	ES0=1;						// ʹܴж
	
}	

/***********************************************************************************
:   void InitTWI0(void)
:   TWI0 ʼ
:   
ز:     
*************************************************************************************/
void InitTWI0 ( void )
{
	SICON = CR2 | CR0;		// SYSCLK = 24M, SYSCLK / 256 = 93.75k
	nop();
	nop();
	nop();
	SICON |= ENSI;			// TWIģ

	
}


/***********************************************************************************
:   void InitTimer(void)
:   ʱʼ
:   
ز:     
*************************************************************************************/
void InitTimer(void)
{
    //T0:1: 16λʱ T1: 2: 8λԶضʱ
    TMOD = 0x21;
    //T1ʱ 1000us
    TH0=TIMER_1MS_TH;
    TL0=TIMER_1MS_TL;
    TR0=1;          //ʹܶʱ1
	  

}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	
	// ѡP22/P24TWI0
	AUXR3=(AUXR3&(~0x06))|TWI0_SEL_P22P24;
	//P2 ΪĿ©
	P2M0=0xFF;
	P2M1=0xFF;

	
}

/***********************************************************************************
:   void InitUart0(void)
:   Uart0ʼ
:   
ز:     
*************************************************************************************/
void InitUart0(void)
{

	//SMOD = 1
	PCON0=PCON0|0x80;
    //ģʽΪ1: 10λɱ䲨,ʹܽ
    S0CON=0x50;
    //ʱԴΪʱ1
	T2MOD1=T2MOD1&(~TL2IS);		 // ѡTCLK/RCLK
	TCLK_TL2IE=0;
	RCLK_TF2L=0;

	//ڲΪ115200@24MHz 1T
	AUXR2=AUXR2|T1X12;		 // T1Ϊ1T ģʽ
	TH1=0xF3;			 
	//ʹܶʱ1
	TR1=1;


}

/***********************************************************************************
:   void InitClock(void)
:   ϵͳʱӳʼ
:   
ز:     
*************************************************************************************/
void InitClock()
{
	TrapFlag[3]='g';
	//OSCIn=12Mhz,MCK=24MHz, CpuCLK=24MHz, SysCLK=24MHz,
	CKCON0 = ENCKM|CKMIS0;						// 12Hz, ENCKM, CpuCLK=SYSCLK ,SYSCLK=MCK/1
	WriteP(CKCON2_P,XTGS0|IHRCOE|MCKS0);		//  MCK=CKMI*4 
	TrapFlag[3]=0xFF;
	
	CKCON1=11;					// IAP ʱ@OSCIn=12MHz

}


/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	TrapFlag[1]='i';
	InitPort();
	
	TrapFlag[2]='n';
	InitClock();
	TrapFlag[2]=0xFF;
	InitTimer();
	InitUart0();
	InitTWI0();
	InitInterrupt();

	UartOutBufIn=0;
	UartOutBufOut=0;
	bUartOutTxFlag=0;

	EA=1;
}

#if 0
//PҳĴ
u8 ReadP(u8 PsfrAddr)
{
		bit bEA=EA;
		EA = 0; 					//ж
		IFADRH = 0; 				//IFADRHΪ0
		IFADRL= PsfrAddr;			//Pҳַ;
		IFMT = ISP_READ_P;
		ISPCR = 0x80;				//õȴʱ, ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		_nop_();
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA;					//ָж
		return IFD;
}
#endif

/***********************************************************************************
:   	void WriteP(u8 PsfrAddr,u8 PsfrData)
:   	дPҳĴ
:   	u8 PsfrAddr: PҳĴַ
				u8 PsfrData: д
ز:     
*************************************************************************************/
void WriteP(u8 PsfrAddr,u8 PsfrData)
{
		bit bEA=EA;
		EA = 0; 					//ж
		IFADRH = 0; 				//IFADRHΪ0
		IFADRL= PsfrAddr;			//Pҳַ;
		IFD= PsfrData;				//;
		IFMT = ISP_WRITE_P;
		ISPCR = 0x80;				//õȴʱ, ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		_nop_();
		ISPCR = 0;					//ISP/IAPĴֹ
		IFMT=0;
		EA = bEA;					//ָж
}
/***********************************************************************************
:   	void CheckTrapFlag(void)
:   	Ƿȷ̽IAPֹ
				TrapFlag != "Wing",ʾǷǷ,Ƭλ
:   	
ز:     
*************************************************************************************/
void CheckTrapFlag(void)
{ 
	if ((TrapFlag[0]!='W')||(TrapFlag[1]!='i')||(TrapFlag[2]!='n')||(TrapFlag[3]!='g'))
	{
		//λ
		ISPCR = ISPCR&0xBF; 		//SWBS=0, ѡAPռ
		ISPCR = ISPCR|0x20; 		//SWRST=1, λ
	}
}


