
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include "REG_MA82G5Dxx.H"
#include "delay.H"


uCHAR flag_Tx0_Busy;



void INT_UART0(void) interrupt 4
{

	if(RI0){
		RI0 = 0;
		
	}else if(TI0)
	{
		TI0 = 0;
		if(flag_Tx0_Busy == 1)
			flag_Tx0_Busy = 0;
	}
}


void Initial_UART0(void)
{
	//SMOD = 1
	PCON0=PCON0|0x80;
    //ģʽΪ1: 10λɱ䲨,ʹܽ
    S0CON=0x50;
    //ʱԴΪʱ1
	SFRPI=1;
	T2MOD1=T2MOD1&(~TL2IS);		 // ѡTCLK/RCLK
	SFRPI=0;
	TCLK_TL2IE=0;
	RCLK_TF2L=0;

	S0CFG=0x08;
    //T0:1: 16λʱ T1: 2: 8λԶضʱ
    TMOD = 0x21;
	AUXR2=AUXR2|T1X12;		 // T1Ϊ1T ģʽ
	//ڲΪ9600@11.0592MHz 1T
	TH1=0xB8;			 
	//ʹܶʱ1
	TR1=1;
}

void UART0_Send_Byte(uCHAR dta)
{
	S0BUF = dta;
	flag_Tx0_Busy = 1;
	while(flag_Tx0_Busy);
}

void main(void)
{    
	
	CKCON0 |= AFS;						//MCU Run 11.0592MHz,
	delay_ms(3);
	Initial_UART0();
	ES0 = 1;
	EA = 1;
	
	UART0_Send_Byte(0xAA);
	while(1);
}
