
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include "REG_MA82G5Dxx.H"


#define    ISP_ENABLE          0x80              // Set ISP Enable
#define    ISP_DISABLE         0x00              // Set ISP Disable

uCHAR IAP_Var0;
uCHAR IAP_Var1;
uCHAR IAP_Var2;
uCHAR IAP_Var3;

void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	ISPCR = ISP_ENABLE;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFMT = 0x05;
    SCMD = 0x46;
    SCMD = 0xB9;
	Data = IFD;
    ISPCR = ISP_DISABLE;
	
	return Data;
}


void IAP_Erase(uCHAR AddrH, uCHAR AddrL)
{
	IFADRH = AddrH;
	IFADRL = AddrL;
	IFMT = 0x03;								//erase
	ISPCR = ISP_ENABLE;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
}

void IAP_Program(uCHAR AddrH, uCHAR AddrL, uCHAR Dta)
{
	IFADRH = AddrH;
	IFADRL = AddrL;
	IFD = Dta;
	IFMT = 0x02;								//program
	ISPCR = ISP_ENABLE;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
}

uCHAR IAP_Read(uCHAR AddrH, uCHAR AddrL)
{
	uCHAR Dta;

	IFADRH = AddrH;
	IFADRL = AddrL;
	IFMT = 0x01;								//read
	ISPCR = ISP_ENABLE;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;

	Dta = IFD;
	return Dta;
}

void main()
{
	uCHAR tmp;
	CKCON1 = 0x0B;							//OSCin = 12MHz
	
	tmp = PageP_Read(IAPLB_P);
	
	PageP_Write(IAPLB_P, 0x10);				//set IAPLB address at 0x1000

	IAP_Erase(0x10, 0x00);
	IAP_Program(0x10, 0x00, 0x55);
	IAP_Program(0x10, 0x01, 0xAA);
	IAP_Program(0x10, 0x02, 0x5A);
	IAP_Program(0x10, 0x03, 0xA5);

	IAP_Var0 = IAP_Read(0x10, 0x00);
	IAP_Var1 = IAP_Read(0x10, 0x01);
	IAP_Var2 = IAP_Read(0x10, 0x02);
	IAP_Var3 = IAP_Read(0x10, 0x03);

	while(1);
}
