/**
 * @file    mg32f157_opa.c
 * @author  MegawinTech Application Team
 * @version V0.0.4
 * @date    16-June-2023
 * @brief   This file provides all the OPA firmware functions.
 */

/* Includes ------------------------------------------------------------------*/
#include "mg32f157_opa.h"

/** @addtogroup MG32F157_StdPeriph_Driver
  * @{
  */

/** @defgroup OPA 
  * @brief OPA driver modules
  * @{
  */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/

/** @defgroup OPA_Private_Defines
  * @{
  */

#define OPA_Set                    ((uint32_t)0x00000001)
#define OPA_Reset                  ((uint32_t)0x00000000)

#define IS_OPA_ALL_OPA(OPAx) (((OPAx) == OPA1) || ((OPAx) == OPA2) || ((OPAx) == OPA3))

/**
  * @}
  */

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/** @defgroup OPA_Private_Functions
  * @{
  */

/**
 * @brief  Deinitializes the specified OPAx peripheral register to default reset value.
 * @param  OPAx: where x can be 1 to 3 to select the OPA peripheral.
 * @return None
 */
void OPA_DeInit(OPA_TypeDef* OPAx)
{ 
  /* Check the parameters */
  assert_param(IS_OPA_ALL_OPA(OPAx));
  
  OPAx->CSR = OPA_Reset;
}

/**
 * @brief  Enables or disables the specified OPA.
 * @param  OPAx: where x can be 1 to 3 to select the OPA peripheral.
 * @param  NewState: new state of the specified OPA peripheral.
 *         This parameter can be: ENABLE or DISABLE.
 * @return None
 */
void OPA_Cmd(OPA_TypeDef* OPAx, FunctionalState NewState)
{
  /* Check the parameters */
  assert_param(IS_OPA_ALL_OPA(OPAx));
  assert_param(IS_FUNCTIONAL_STATE(NewState));

  if (NewState != DISABLE)
  {
    OPAx->CSR |= OPA_Set;
  }
  else
  {
    OPAx->CSR = OPA_Reset;
  }
  
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
