/**************************************************************************//**
 * @file     startup_mg32f157.S
 * @brief    CMSIS Core Device Startup File for
 *           MG32F157 Device Series
 * @version  V0.0.4
 * @date     16-June-2023
 ******************************************************************************/
/*
 * Copyright (c) 2009-2019 Arm Limited. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                .syntax  unified
                .arch    armv7-m

                .section .vectors
                .align   2
                .globl   __Vectors
                .globl   __Vectors_End
                .globl   __Vectors_Size
__Vectors:
                .long    __StackTop                         /*     Top of Stack */
                .long    Reset_Handler                      /*     Reset Handler */
                .long    NMI_Handler                        /* -14 NMI Handler */
                .long    HardFault_Handler                  /* -13 Hard Fault Handler */
                .long    MemManage_Handler                  /* -12 MPU Fault Handler */
                .long    BusFault_Handler                   /* -11 Bus Fault Handler */
                .long    UsageFault_Handler                 /* -10 Usage Fault Handler */
                .long    0                                  /*     Reserved */
                .long    0                                  /*     Reserved */
                .long    0                                  /*     Reserved */
                .long    0                                  /*     Reserved */
                .long    SVC_Handler                        /*  -5 SVCall Handler */
                .long    DebugMon_Handler                   /*  -4 Debug Monitor Handler */
                .long    0                                  /*     Reserved */
                .long    PendSV_Handler                     /*  -2 PendSV Handler */
                .long    SysTick_Handler                    /*  -1 SysTick Handler */

                /* Interrupts */
                .long     WWDG_IRQHandler                   /*   0 Window Watchdog Handler */
                .long     PVD_IRQHandler                    /*   1 PVD through EXTI Line detect Handler */
                .long     TAMPER_IRQHandler                 /*   2 Tamper Handler */
                .long     RTC_IRQHandler                    /*   3 RTC Handler */
                .long     FLASH_IRQHandler                  /*   4 Flash Handler */
                .long     RCC_IRQHandler                    /*   5 RCC Handler */
                .long     EXTI0_IRQHandler                  /*   6 EXTI Line 0 Handler */
                .long     EXTI1_IRQHandler                  /*   7 EXTI Line 1 Handler */
                .long     EXTI2_IRQHandler                  /*   8 EXTI Line 2 Handler */
                .long     EXTI3_IRQHandler                  /*   9 EXTI Line 3 Handler */
                .long     EXTI4_IRQHandler                  /*  10 EXTI Line 4 Handler */
                .long     DMA1_Channel1_IRQHandler          /*  11 DMA1 Channel 1 Handler */
                .long     DMA1_Channel2_IRQHandler          /*  12 DMA1 Channel 2 Handler */
                .long     DMA1_Channel3_IRQHandler          /*  13 DMA1 Channel 3 Handler */
                .long     DMA1_Channel4_IRQHandler          /*  14 DMA1 Channel 4 Handler */
                .long     DMA1_Channel5_IRQHandler          /*  15 DMA1 Channel 5 Handler */
                .long     DMA1_Channel6_IRQHandler          /*  16 DMA1 Channel 6 Handler */
                .long     DMA1_Channel7_IRQHandler          /*  17 DMA1 Channel 7 Handler */
                .long     ADC1_2_IRQHandler                 /*  18 ADC1 & ADC2 Handler */
                .long     USB_DMA_CAN1_IRQHandler           /*  19 USB DMA or CAN1 Handler */
                .long     USB_IRQHandler                    /*  20 USB Handler */
                .long     0                                 /*  21 Reserved */
                .long     0                                 /*  22 Reserved */
                .long     EXTI9_5_IRQHandler                /*  23 EXTI Line 9..5 Handler */
                .long     TIM1_BRK_IRQHandler               /*  24 TIM1 Break Handler */
                .long     TIM1_UP_IRQHandler                /*  25 TIM1 Update Handler */
                .long     TIM1_TRG_COM_IRQHandler           /*  26 TIM1 Trigger and Commutation Handler */
                .long     TIM1_CC_IRQHandler                /*  27 TIM1 Capture Compare Handler */
                .long     TIM2_IRQHandler                   /*  28 TIM2 Handler */
                .long     TIM3_IRQHandler                   /*  29 TIM3 Handler */
                .long     TIM4_IRQHandler                   /*  30 TIM4 Handler */
                .long     I2C1_EV_IRQHandler                /*  31 I2C1 Event Handler */
                .long     I2C1_ER_IRQHandler                /*  32 I2C1 Error Handler */
                .long     I2C2_EV_IRQHandler                /*  33 I2C2 Event Handler */
                .long     I2C2_ER_IRQHandler                /*  34 I2C2 Error Handler */
                .long     SPI1_IRQHandler                   /*  35 SPI1 Handler */
                .long     SPI2_IRQHandler                   /*  36 SPI2 Handler */
                .long     USART1_IRQHandler                 /*  37 USART1 Handler */
                .long     USART2_IRQHandler                 /*  38 USART2 Handler */
                .long     USART3_IRQHandler                 /*  39 USART3 Handler */
                .long     EXTI15_10_IRQHandler              /*  40 EXTI Line 15..10 Handler */
                .long     RTCAlarm_IRQHandler               /*  41 RTC Alarm through EXTI Line Handler */
                .long     0                                 /*  42 Reserved */
                .long     TIM8_BRK_IRQHandler               /*  43 TIM8 Break Handler */
                .long     TIM8_UP_IRQHandler                /*  44 TIM8 Update Handler */
                .long     TIM8_TRG_COM_IRQHandler           /*  45 TIM8 Trigger and Commutation Handler */
                .long     TIM8_CC_IRQHandler                /*  46 TIM8 Capture Compare Handler */
                .long     ADC3_IRQHandler                   /*  47 ADC3 Handler */
                .long     0                                 /*  48 Reserved */
                .long     SDIO_IRQHandler                   /*  49 SDIO Handler */
                .long     TIM5_IRQHandler                   /*  50 TIM5 Handler */
                .long     SPI3_IRQHandler                   /*  51 SPI3 Handler */
                .long     UART4_IRQHandler                  /*  52 UART4 Handler */
                .long     UART5_IRQHandler                  /*  53 UART5 Handler */
                .long     TIM6_IRQHandler                   /*  54 TIM6 Handler */
                .long     TIM7_IRQHandler                   /*  55 TIM7 Handler */
                .long     DMA2_Channel1_IRQHandler          /*  56 DMA2 Channel1 Handler */
                .long     DMA2_Channel2_IRQHandler          /*  57 DMA2 Channel2 Handler */
                .long     DMA2_Channel3_IRQHandler          /*  58 DMA2 Channel3 Handler */
                .long     DMA2_Channel4_5_IRQHandler        /*  59 DMA2 Channel4 & Channel5 Handler */
                .long     QUADSPI_IRQHandler                /*  60 QUADSPI Handler */
                .long     RNG_IRQHandler                    /*  61 RNG Handler */
                .long     AES_IRQHandler                    /*  62 AES Handler */
                .long     USART_EXTI_IRQHandler             /*  63 USART wakeup EXTI Handler */
__Vectors_End:
                .equ     __Vectors_Size, __Vectors_End - __Vectors
                .size    __Vectors, . - __Vectors


                .thumb
                .section .text
                .align   2

                .thumb_func
                .type    Reset_Handler, %function
                .globl   Reset_Handler
Reset_Handler:
                bl       SystemInit

                ldr      r4, =__copy_table_start__
                ldr      r5, =__copy_table_end__

.L_loop0:
                cmp      r4, r5
                bge      .L_loop0_done
                ldr      r1, [r4]
                ldr      r2, [r4, #4]
                ldr      r3, [r4, #8]

.L_loop0_0:
                subs     r3, #4
                ittt     ge
                ldrge    r0, [r1, r3]
                strge    r0, [r2, r3]
                bge      .L_loop0_0

                adds     r4, #12
                b        .L_loop0
.L_loop0_done:

                ldr      r3, =__zero_table_start__
                ldr      r4, =__zero_table_end__

.L_loop2:
                cmp      r3, r4
                bge      .L_loop2_done
                ldr      r1, [r3]
                ldr      r2, [r3, #4]
                movs     r0, 0

.L_loop2_0:
                subs     r2, #4
                itt      ge
                strge    r0, [r1, r2]
                bge      .L_loop2_0

                adds     r3, #8
                b        .L_loop2
.L_loop2_done:

                bl       _start

                .size    Reset_Handler, . - Reset_Handler


                .thumb_func
                .type    Default_Handler, %function
                .weak    Default_Handler
Default_Handler:
                b        .
                .size    Default_Handler, . - Default_Handler

/* Macro to define default exception/interrupt handlers.
 * Default handler are weak symbols with an endless loop.
 * They can be overwritten by real handlers.
 */
                .macro   Set_Default_Handler  Handler_Name
                .weak    \Handler_Name
                .set     \Handler_Name, Default_Handler
                .endm


/* Default exception/interrupt handler */

                Set_Default_Handler  NMI_Handler
                Set_Default_Handler  HardFault_Handler
                Set_Default_Handler  MemManage_Handler
                Set_Default_Handler  BusFault_Handler
                Set_Default_Handler  UsageFault_Handler
                Set_Default_Handler  SVC_Handler
                Set_Default_Handler  DebugMon_Handler
                Set_Default_Handler  PendSV_Handler
                Set_Default_Handler  SysTick_Handler

                Set_Default_Handler  WWDG_IRQHandler           
                Set_Default_Handler  PVD_IRQHandler            
                Set_Default_Handler  TAMPER_IRQHandler         
                Set_Default_Handler  RTC_IRQHandler            
                Set_Default_Handler  FLASH_IRQHandler          
                Set_Default_Handler  RCC_IRQHandler            
                Set_Default_Handler  EXTI0_IRQHandler          
                Set_Default_Handler  EXTI1_IRQHandler          
                Set_Default_Handler  EXTI2_IRQHandler          
                Set_Default_Handler  EXTI3_IRQHandler          
                Set_Default_Handler  EXTI4_IRQHandler          
                Set_Default_Handler  DMA1_Channel1_IRQHandler  
                Set_Default_Handler  DMA1_Channel2_IRQHandler  
                Set_Default_Handler  DMA1_Channel3_IRQHandler  
                Set_Default_Handler  DMA1_Channel4_IRQHandler  
                Set_Default_Handler  DMA1_Channel5_IRQHandler  
                Set_Default_Handler  DMA1_Channel6_IRQHandler  
                Set_Default_Handler  DMA1_Channel7_IRQHandler  
                Set_Default_Handler  ADC1_2_IRQHandler         
                Set_Default_Handler  USB_DMA_CAN1_IRQHandler   
                Set_Default_Handler  USB_IRQHandler            
                
                Set_Default_Handler  EXTI9_5_IRQHandler        
                Set_Default_Handler  TIM1_BRK_IRQHandler       
                Set_Default_Handler  TIM1_UP_IRQHandler        
                Set_Default_Handler  TIM1_TRG_COM_IRQHandler   
                Set_Default_Handler  TIM1_CC_IRQHandler        
                Set_Default_Handler  TIM2_IRQHandler           
                Set_Default_Handler  TIM3_IRQHandler           
                Set_Default_Handler  TIM4_IRQHandler           
                Set_Default_Handler  I2C1_EV_IRQHandler        
                Set_Default_Handler  I2C1_ER_IRQHandler        
                Set_Default_Handler  I2C2_EV_IRQHandler        
                Set_Default_Handler  I2C2_ER_IRQHandler        
                Set_Default_Handler  SPI1_IRQHandler           
                Set_Default_Handler  SPI2_IRQHandler           
                Set_Default_Handler  USART1_IRQHandler         
                Set_Default_Handler  USART2_IRQHandler         
                Set_Default_Handler  USART3_IRQHandler         
                Set_Default_Handler  EXTI15_10_IRQHandler      
                Set_Default_Handler  RTCAlarm_IRQHandler       
                  
                Set_Default_Handler  TIM8_BRK_IRQHandler       
                Set_Default_Handler  TIM8_UP_IRQHandler        
                Set_Default_Handler  TIM8_TRG_COM_IRQHandler   
                Set_Default_Handler  TIM8_CC_IRQHandler        
                Set_Default_Handler  ADC3_IRQHandler         
                  
                Set_Default_Handler  SDIO_IRQHandler           
                Set_Default_Handler  TIM5_IRQHandler           
                Set_Default_Handler  SPI3_IRQHandler           
                Set_Default_Handler  UART4_IRQHandler          
                Set_Default_Handler  UART5_IRQHandler          
                Set_Default_Handler  TIM6_IRQHandler           
                Set_Default_Handler  TIM7_IRQHandler           
                Set_Default_Handler  DMA2_Channel1_IRQHandler  
                Set_Default_Handler  DMA2_Channel2_IRQHandler  
                Set_Default_Handler  DMA2_Channel3_IRQHandler  
                Set_Default_Handler  DMA2_Channel4_5_IRQHandler
                Set_Default_Handler  QUADSPI_IRQHandler        
                Set_Default_Handler  RNG_IRQHandler            
                Set_Default_Handler  AES_IRQHandler            
                Set_Default_Handler  USART_EXTI_IRQHandler     


                .end
