#include "bsp_usart3.h"


/**
  * @name    uart3_init
  * @brief   Init UART3
  * @param   apbclk: UART3 APB Clock frequency
  * @param   baud: Baudrate to configure
  * @retval  None
  */
void usart3_init(uint32_t apbclk, uint32_t baud)
{
  /* Enable UART3 and GPIOB Clock */
  RCC->APB1ENR |= RCC_APB1ENR_USART3EN;
  RCC->APB2ENR |= (RCC_APB2ENR_IOPBEN | RCC_APB2ENR_AFIOEN);
  
  /* Reset USART3 */
  RCC->APB1RSTR |= RCC_APB1RSTR_USART3RST;
  RCC->APB1RSTR &= ~RCC_APB1RSTR_USART3RST;
  
  /* PB10(USART3_TX) configure to push pull, PB11(USART3_RX) configure to Input with Pull-up resistance */
  GPIOB->CRH = (GPIOB->CRH & 0xFFFF00FF) | 0x00008B00;
  GPIOB->BSRR = GPIO_BSRR_BS11;
  
  /* Configure USART3 */
  USART3->CR2 = 0x0000;
  USART3->CR1 = USART_CR1_TE | USART_CR1_RE;
  USART3->CR3 = 0x0000;
  USART3->BRR = (apbclk + (baud >> 1)) / baud;    
  
  /* Enable USART3 */
  USART3->CR1 |= USART_CR1_UE;
}

/**
  * @name    uart3_send
  * @brief   Send data through UART3
  * @param   buffer: Buffer to send
  * @param   length: Buffer length
  * @retval  None
  */
void usart3_send(const uint8_t* buffer, uint32_t length)
{
  while(length)
  {
    while(!(USART3->SR & USART_SR_TC));
    USART3->DR = *buffer;
    buffer++;  length--;
  }
  while(!(USART3->SR & USART_SR_TC));
}







