#include "bsp_usart2.h"


/**
  * @name    uart2_init
  * @brief   Init UART2
  * @param   apbclk: UART2 APB Clock frequency
  * @param   baud: Baudrate to configure
  * @retval  None
  */
void usart2_init(uint32_t apbclk, uint32_t baud)
{
  /* Enable UART2 and GPIOA Clock */
  RCC->APB2ENR |= RCC_APB2ENR_IOPAEN;
  RCC->APB1ENR |= RCC_APB1ENR_USART2EN;
  
  /* Reset USART2 */
  RCC->APB1RSTR |= RCC_APB1RSTR_USART2RST;
  RCC->APB1RSTR &= ~RCC_APB1RSTR_USART2RST;
  
  /* PA2(USART2_TX) configure to push pull, PA3(USART2_RX) configure to Input with Pull-up resistance */
  GPIOA->CRL = (GPIOA->CRL & 0xFFFF00FF) | 0x00008B00;
  GPIOA->BSRR = GPIO_BSRR_BS3;
  
  /* Configure USART2 */
  USART2->CR2 = 0x0000;
  USART2->CR1 = USART_CR1_TE | USART_CR1_RE;
  USART2->BRR = (apbclk + (baud >> 1)) / baud;    
  
  /* Enable USART2 */
  USART2->CR1 |= USART_CR1_UE;
}


/**
  * @name    uart2_send
  * @brief   Send data through UART2
  * @param   buffer: Buffer to send
  * @param   length: Buffer length
  * @retval  None
  */
void usart2_send(const uint8_t* buffer, uint32_t length)
{
  while(length)
  {
    while(!(USART2->SR & USART_SR_TC));
    USART2->DR = *buffer;
    buffer++;  length--;
  }
  while(!(USART2->SR & USART_SR_TC));
}







