/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define AFIO_Remap_OPA1           (uint32_t)0x80000000
#define AFIO_Remap_OPA2           (uint32_t)0x40000000
#define AFIO_Remap_OPA3           (uint32_t)0x20000000

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
 * @brief  Main program.
 * @param  None
 * @note   - OPA1 PA1- PA4_OUT PA0+
           - OPA2 PC3- PC5_OUT PC2+
           - OPA3 PC1- PC4_OUT PC0+
 * @return None
 */
int main(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;

   /* Enable GPIOC and AFIO clocks */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC | RCC_APB2Periph_AFIO, ENABLE);  
  
  /* OPA2 Alternate Function maping */
  AFIO->MAPR |= AFIO_Remap_OPA2;  
  
  /* Configure the OPA2 GPIO ports */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2 | GPIO_Pin_3 | GPIO_Pin_5;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_Init(GPIOC, &GPIO_InitStructure);
  
  /* Enable OPA2 */
  OPA_Cmd(OPA2, ENABLE);

  /* Infinite loop */
  while (1)
  {
  }
}

#ifdef  USE_FULL_ASSERT
/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param  file: pointer to the source file name
 * @param  line: assert_param error line source number
 * @return None
 */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
