/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"
#include <stdio.h>

#include "FreeRTOS.h"
#include "task.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static void prvLED1Task(void *pvParameters);
static void prvLED2Task(void *pvParameters);

/* Private functions ---------------------------------------------------------*/

void bspInit()
{
  GPIO_InitTypeDef GPIO_InitStructure;
  /* Enable GPIOB clock */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);

  /* Configure PB10 and PB11 in output pushpull mode */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10 | GPIO_Pin_11;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOB, &GPIO_InitStructure);
}


int main(void)
{
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_4);

  /* Configure HCLK clock as SysTick clock source. */
  SysTick_CLKSourceConfig(SysTick_CLKSource_HCLK);

  bspInit();

  xTaskCreate(prvLED1Task, "LED1", configMINIMAL_STACK_SIZE, NULL, 1, NULL);
  xTaskCreate(prvLED2Task, "LED2", configMINIMAL_STACK_SIZE, NULL, 1, NULL);

  /* Start the scheduler. */
  vTaskStartScheduler();

  /* Infinite loop */
  while (1)
  {
  }
}

static void prvLED1Task(void *pvParameters)
{
  while (1)
  {
    GPIO_ToggleBits(GPIOB, GPIO_Pin_11);
    vTaskDelay(500);
  }
}

static void prvLED2Task(void *pvParameters)
{
  while (1)
  {
    GPIO_ToggleBits(GPIOB, GPIO_Pin_10);
    vTaskDelay(250);
  }
}



#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
