/**
 * @file    mg32f157_TRNG.h
 * @author  MegawinTech Application Team
 * @version V0.0.4
 * @date    16-June-2023
 * @brief   This file contains all the functions prototypes for the TRNG firmware
 *          library.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MG32F157_TRNG_H
#define __MG32F157_TRNG_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"

/** @addtogroup MG32F157_StdPeriph_Driver
  * @{
  */

/** @addtogroup TRNG
  * @{
  */


/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/

/** @defgroup TRNG_Exported_Constants
  * @{
  */

/** @defgroup TRNG_interrupts
  * @{
  */

#define TRNG_IT_SEIS                                 ((uint16_t)0x4008)
#define TRNG_IT_CEIS                                 ((uint16_t)0x2008)
#define TRNG_IT_DRDY                                 ((uint16_t)0x0108)

#define IS_TRNG_CLEAR_IT(IT) (((IT) == TRNG_IT_SEIS) || ((IT) == TRNG_IT_CEIS) ||\
                              ((IT) == (TRNG_IT_CEIS | TRNG_IT_SEIS)))

#define IS_TRNG_GET_IT(IT) (((IT) == TRNG_IT_SEIS) || ((IT) == TRNG_IT_CEIS) || \
                            ((IT) == TRNG_IT_DRDY))
/**
  * @}
  */

/** @defgroup TRNG_flags
  * @{
  */

#define TRNG_FLAG_SECS                               ((uint8_t)0x04)
#define TRNG_FLAG_CECS                               ((uint8_t)0x02)
#define TRNG_FLAG_DRDY                               ((uint8_t)0x01)

#define IS_TRNG_GET_FLAG(FLAG) (((FLAG) == TRNG_FLAG_SECS) || ((FLAG) == TRNG_FLAG_CECS) || \
                                ((FLAG) == TRNG_FLAG_DRDY))

#define IS_TRNG_CLEAR_FLAG(FLAG) (((FLAG) == TRNG_FLAG_SECS) || ((FLAG) == TRNG_FLAG_CECS) || \
                                  ((FLAG) == (TRNG_FLAG_SECS | TRNG_FLAG_CECS)))
/**
  * @}
  */

/**
  * @}
  */

/* Exported macro ------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

void TRNG_DeInit(void);
void TRNG_Cmd(FunctionalState NewState);
void TRNG_Clock_CheckCmd(FunctionalState NewState);
void TRNG_ClearFlag(uint8_t TRNG_FLAG);
void TRNG_ClearITPendingBit(uint16_t TRNG_IT);
uint32_t TRNG_GetData(void);
FlagStatus TRNG_GetFlagStatus(uint8_t TRNG_FLAG);
ITStatus TRNG_GetITStatus(uint16_t TRNG_IT);
void TRNG_ITCmd(FunctionalState NewState);

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /* __MG32F157_TRNG_H */
