#include "REG_MG82G5Exx.h"
#include "IEC60730-STL.h"
#include <stdio.h>
#define SET 1
#define CLR 0
#define uCHAR unsigned char
#define ROM_START_ADDRESS 0x0000

unsigned char result_crc = 0;
unsigned char result_IO_input = 0;
unsigned char result_IO_out = 0;
unsigned char result_AD = 0;
unsigned char result_clock = 0;
unsigned char result_Int = 0;
unsigned int TX_cnt = 0;
unsigned int AD_value=0;

extern unsigned int clock_freq;
extern unsigned int RES_clock_freq;
extern bit clk_watch_interrupt_flag;


extern unsigned char Int_freq;
extern unsigned int RES_Int_freq;
extern bit Int_watch_interrupt_flag;

//extern unsigned int freq;
unsigned char PageP_Read( unsigned char Addr )
 { 
	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;//Page P SFR Read
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	return IFD;
 }

void PageP_Write( unsigned char Addr , unsigned char Data )
 { 
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;//Page P SFR Write
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
 }


/*ClOCK VECTOR*/
void INT_System(void) interrupt 11
{
	if(PCON1 & RTCF)
	{
		clk_watch_interrupt_flag = ~clk_watch_interrupt_flag;
		if(!clk_watch_interrupt_flag)
		{
			RES_clock_freq = clock_freq;
			result_clock = ClockTest();	
		}
		PCON1 |= RTCF; // Clear RTC flag (write "1")
	}
}

void INT_TIMER0(void)  interrupt 1 //1ms 
{
	TX_cnt++;
	
    //Clock test
	if(clk_watch_interrupt_flag)	
	{
		clock_freq ++;		// count from the second cycle
	}
	
	//Interrupt test		
	Int_watch_interrupt_flag = ~Int_watch_interrupt_flag;
	if(!Int_watch_interrupt_flag)
	{
		RES_Int_freq = Int_freq;
		result_Int = IntTest();
	}

 
}
void INT_TIMER1(void)  interrupt 3 //100us 
{			
	//Interrupt test		 
	if(Int_watch_interrupt_flag)	
	{
		Int_freq ++;		// count from the second cycle
	}
}
void Initial_Timer0( void ) //1KHz, 1ms 
{ 	
	TR0 = CLR;                                   // Disable Timer0

    TMOD = 0x02;               // Set Timer0 at Mode1 ( 8 bit reload mode )
	AUXR3 |= T0XL;				//Select SYSCLK/48
	TH0 = TL0 = 0x06;

	ET0 = 1;                   // Enable Timer0 interrupt
	TF0 = 0;	
    TR0 = SET;                 // Enable Timer0
}
void Initial_Timer1( void ) //10KHz, 100us 
{ 
	TR1 = CLR;                 // Disable Timer1

	TH1 = TL1 = 0x9C;

	TMOD |= 0x20;              // Set Timer1 at Mode2 ( 8 bit reload mode )
	ET1 = 1;                   // Enable Timer1 interrupt
	TF1 = 0;	
	TR1 = SET;                 // Enable Timer1
}
void RTC_Watch_init(void)
{
	PCON1 |= RTCF;                           // Clear RTC flag (write "1")
	PageP_Write(CKCON4, RCSS0);				//ILRCO precision: +- 30%
	PageP_Write(RTCTM, 0x7F);                // Select ILRCO for RTC counter clock source, Step = 0.5S

	PageP_Write(RTCCR, (RTCE | 0x3F));     // Set RTC Enable and RTC reload count
	
	SFIE |= RTCFIE;                          // Enable RTC interrupt 
	EIE1 |= ESF;                             // Enable SystemFlag interrupt 
	EA = 1;                                  // Enable global interrupt 
}

void Initial_UART( void )
{
	//S0 Baud Rate Generator for BR=28800bps
	S0CFG |= SMOD3;
	S0CR1 = (S0TR | S0TX12 | S0TCK | S0RCK);
	S0CON = 0x50;
	S0BRT = S0BRC = 243;

	TI0=1;
}

void main( void )
{
	unsigned char addr_H;
	unsigned char page;
	unsigned int crc_code;

	Initial_UART();

	result_IO_input = P0_Input_Test(0x55);
	result_IO_out = P0_Output_Test(0xAA);
	printf("[result_P0_input =%d]\n",(unsigned int)result_IO_input);
	printf("[result_P0_out =%d]\n",(unsigned int)result_IO_out);
	
	result_IO_input = P1_Input_Test(0x55);
	result_IO_out = P1_Output_Test(0xAA);
	printf("[result_P1_input =%d]\n",(unsigned int)result_IO_input);
	printf("[result_P1_out =%d]\n",(unsigned int)result_IO_out);
	
	result_IO_input = P2_Input_Test(0x55);
	result_IO_out = P2_Output_Test(0xAA);
	printf("[result_P2_input =%d]\n",(unsigned int)result_IO_input);
	printf("[result_P2_out =%d]\n",(unsigned int)result_IO_out);
	
	result_IO_input = P3_Input_Test(0x55);
	result_IO_out = P3_Output_Test(0xAA);
	printf("[result_P3_input =%d]\n",(unsigned int)result_IO_input);
	printf("[result_P3_out =%d]\n",(unsigned int)result_IO_out);
	
	result_IO_input = P4_Input_Test(0x55);
	result_IO_out = P4_Output_Test(0xAA);
	printf("[result_P4_input =%d]\n",(unsigned int)result_IO_input);
	printf("[result_P4_out =%d]\n",(unsigned int)result_IO_out);
	
	result_IO_input = P6_Input_Test(0x55);
	result_IO_out = P6_Output_Test(0xAA);
	printf("[result_P6_input =%d]\n",(unsigned int)result_IO_input);
	printf("[result_P6_out =%d]\n",(unsigned int)result_IO_out);
	
	
#if 1
	addr_H = (ROM_START_ADDRESS / 256) & 0xFE; //use "code" keyword means Flash address
	page = 3; //Code Size, it must be not zero.
	crc_code = MakeCRCCode(addr_H, page);
	result_crc = CRCTest(addr_H, crc_code);
	printf("[result_crc =%d]\n",(unsigned int)result_crc);
	if(result_crc != TEST_NORMAL)
	{
		printf("[CRC ROM Test Error!!]");
		while(1);
	}
#endif
		
	AD_Init();
	Initial_Timer0();
	Clk_Test_Init();
	RTC_Watch_init();
	Initial_Timer1();
	Int_Test_Init();

	while(1)
	{
			
		if(TX_cnt>1500)
		{
			result_AD=AD_Test(AIN_0,0,1023); //AIN_num, value_low, value_upper
			printf("[AD_value=%d]\n",(unsigned int)AD_value);
			printf("[result_AD =%d]\n",(unsigned int)result_AD);
			if(result_AD == TEST_FUNC_ERROR)
			{
				printf("[ADC Test Error!!]");
				while(1);
			}
			
			printf("[RES_clock_freq=%d]\n",RES_clock_freq);
			printf("[result_clock =%d]\n",(unsigned int)result_clock);
			
			printf("[RES_Int_freq=%d]\n",RES_Int_freq);
			printf("[result_Int =%d]\n",(unsigned int)result_Int);

			printf("-------------------------\n");
			TX_cnt=0;
		}	

	}
}
