/*********************************************************************************************/
/*               (C) Megawin MCU STL design                                                  */
/*********************************************************************************************/



/*definition for AD test*/
#define AIN_0	0x00 //P10
#define AIN_1	0x01 //P11
#define AIN_2	0x02 //P12
#define AIN_3	0x03 //P13
#define AIN_4	0x04 //P14
#define AIN_5	0x05 //P15
#define AIN_6	0x06 //P16
#define AIN_7	0x07 //P17
#define AIN_IVR	0x27 //IVR

/* test result */
#define TEST_NORMAL           0
#define TEST_FUNC_ERROR       1
#define TEST_PARAMETER_ERROR  2

#define ISP_ENABLE          0x80              // Set ISP Enable
#define ISP_DISABLE         0x00              // Set ISP Disable

extern unsigned AD_value;
extern unsigned char PageP_Read( unsigned char Addr );
extern void PageP_Write( unsigned char Addr , unsigned char Data );

/*********************************************************************************************/
/*               API Function declaration                                                    */                
/*********************************************************************************************/
 
/*CPU TEST*/
void Register_test(void);
void PC_test(void);


/*IO TEST*/
unsigned char P0_Input_Test(unsigned char value);
unsigned char P0_Output_Test(unsigned char value);
unsigned char P1_Input_Test(unsigned char value);
unsigned char P1_Output_Test(unsigned char value);
unsigned char P2_Input_Test(unsigned char value);
unsigned char P2_Output_Test(unsigned char value);
unsigned char P3_Input_Test(unsigned char value);
unsigned char P3_Output_Test(unsigned char value);
unsigned char P4_Input_Test(unsigned char value);
unsigned char P4_Output_Test(unsigned char value);
unsigned char P6_Input_Test(unsigned char value);
unsigned char P6_Output_Test(unsigned char value);


/*AD TEST*/
void AD_Init(void);
unsigned char AD_Test(unsigned char AIN_num, unsigned int value_low, unsigned int value_upper);
	

//INTERRUPT TEST
void Int_Test_Init(void);
unsigned char IntTest(void);


/*CLOCK TEST*/
void Clk_Test_Init(void);
void RTC_Watch_init(void);
unsigned char ClockTest(void);

/*ROM TEST*/

#define		CRC_FW		0
#define		CRC_HW		1
#define		CRC_Type	CRC_HW

unsigned int MakeCRCCode(unsigned char Addr_H, unsigned char page);
unsigned char CRCTest(unsigned char Addr_H, unsigned int crc_original);


