/*
  Copyright (c) 2011 Arduino.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "variant.h"


#include "MG32x02z.h"
#include "system_MG32x02z.h"
#include "MG32x02z_DRV.h"
#include "MG32x02z_ChipInit.h"
#include "MG32x02z_URT_MID.h"
#include "MG32x02z_ADC_MID.h"

#include "timer.h"
#include "HardwareSerial.h"
#include "hw_config.h"

#include "pwm.h"


#ifdef __cplusplus
extern "C" {
#endif


//INPUT_PULLUP
//GPIO_Pin_0

#define  GPA_CFG(x, afs, m)        .AFS=PA##x##_AFS_##afs,   .PinNum=x,  .GioPin=GPIO_Pin_##x, .ulPort=GPIOA,  .IO_Mode=m
#define  GPB_CFG(x, afs, m)        .AFS=PB##x##_AFS_##afs,   .PinNum=x,  .GioPin=GPIO_Pin_##x, .ulPort=GPIOB,  .IO_Mode=m
#define  GPC_CFG(x, afs, m)        .AFS=PC##x##_AFS_##afs,   .PinNum=x,  .GioPin=GPIO_Pin_##x, .ulPort=GPIOC,  .IO_Mode=m
#define  GPD_CFG(x, afs, m)        .AFS=PD##x##_AFS_##afs,   .PinNum=x,  .GioPin=GPIO_Pin_##x, .ulPort=GPIOD,  .IO_Mode=m
#define  GPE_CFG(x, afs, m)        .AFS=PE##x##_AFS_##afs,   .PinNum=x,  .GioPin=GPIO_Pin_##x, .ulPort=GPIOE,  .IO_Mode=m


#define  GPNULL_CFG()              .AFS=0,   .PinNum=((uint16_t)-1),  .GioPin=((uint16_t)-1), .ulPort=NULL,  .IO_Mode=0

#define ANALOG_PULLUP    0xF1
#define ANALOG_NOPULLUP  0xF2

#define DEFAULT_PIN_STATE   INPUT_PULLUP  //ANALOG_NOPULLUP //ANALOG_PULLUP //INPUT //INPUT_PULLUP
const PinDescription  g_APinDescription[MAX_DIGITAL_IOS]=
{
  // 0 .. 19 - Digital pins
  // ----------------------
  { .arduino_id=ARDUINO_PIN_D0,
          GPA_CFG(7, GPA7, DEFAULT_PIN_STATE),   
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel= ADC_CHANNEL_7,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	       
  { .arduino_id=ARDUINO_PIN_D1, 
          GPA_CFG(8, GPA8, DEFAULT_PIN_STATE),  
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_CMP|PIN_ATTR_SPI | PIN_ATTR_I2C|PIN_ATTR_DMA,  
  	                       .ADCChannel= ADC_CHANNEL_8,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D2, 
          GPA_CFG(9, GPA9, DEFAULT_PIN_STATE),   
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_CMP|PIN_ATTR_SPI | PIN_ATTR_I2C|PIN_ATTR_DMA, 
  	                       .ADCChannel= ADC_CHANNEL_9,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },	       

  { .arduino_id=ARDUINO_PIN_D3,
          GPA_CFG(10, GPA10, DEFAULT_PIN_STATE),   
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_CMP|PIN_ATTR_SPI | PIN_ATTR_I2C, 
  	                       .ADCChannel= ADC_CHANNEL_10,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                      
  	     	                       
  { .arduino_id=ARDUINO_PIN_D4, 
          GPA_CFG(11, GPA11, DEFAULT_PIN_STATE),   
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_CMP|PIN_ATTR_SPI | PIN_ATTR_I2C, 
  	                       .ADCChannel= ADC_CHANNEL_11,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D5, 
          GPA_CFG(12, GPA12, DEFAULT_PIN_STATE),   
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_USB|PIN_ATTR_SPI | PIN_ATTR_PWM, 
  	                       .ADCChannel= ADC_CHANNEL_12,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D6,   
          GPA_CFG(13, GPA13, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_USB|PIN_ATTR_SPI | PIN_ATTR_PWM, 
  	                       .ADCChannel= ADC_CHANNEL_13,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D7, 
          GPA_CFG(14, GPA14, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel= ADC_CHANNEL_14,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D8,  
          GPA_CFG(15, GPA15, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel= ADC_CHANNEL_15,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },                    
  	      
  	        	                       
  { .arduino_id=ARDUINO_PIN_D9,  
          GPB_CFG(0, GPB0, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_CMP|PIN_ATTR_SPI| PIN_ATTR_I2C, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D10,   
          GPB_CFG(1, GPB1, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_CMP|PIN_ATTR_SPI| PIN_ATTR_I2C, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D11,   
          GPB_CFG(2, GPB2, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI| PIN_ATTR_I2C|PIN_ATTR_ADC|PIN_ATTR_DAC, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D12,   
          GPB_CFG(3, GPB3, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI| PIN_ATTR_I2C|PIN_ATTR_ADC, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	        
  { .arduino_id=ARDUINO_PIN_D13, 
          GPB_CFG(4, GPB4, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D14, 
          GPB_CFG(5, GPB5, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D15,
          GPB_CFG(6, GPB6, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D16,  
          GPB_CFG(7, GPB7, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	       	                       
  { .arduino_id=ARDUINO_PIN_D17, 
          GPB_CFG(8, URT0_TX, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI|PIN_ATTR_CMP, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D18, 
          GPB_CFG(9, URT0_RX, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI|PIN_ATTR_CMP, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D19,  
          GPB_CFG(10, GPB10, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI| PIN_ATTR_I2C | PIN_ATTR_PWM, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },       


  // 20 .. 39 - Digital pins
  // ----------------------
  { .arduino_id=ARDUINO_PIN_D20,  
          GPB_CFG(11, GPB11, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C|PIN_ATTR_DMA | PIN_ATTR_PWM,
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D21,
          GPB_CFG(12, GPB12, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL| PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_USB|PIN_ATTR_DMA , 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D22, 
          GPB_CFG(13, GPB13, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D23,  
          GPB_CFG(14, GPB14, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_DMA , 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D24,   
          GPB_CFG(15, GPB15, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_USB, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT1_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D25,   
          GPC_CFG(0, GPC0, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C| PIN_ATTR_PWM, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D26,
          GPC_CFG(1, GPC1, DEFAULT_PIN_STATE),   
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C|PIN_ATTR_ADC, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D27, 
          GPC_CFG(2, GPC2, DEFAULT_PIN_STATE),   
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_ADC, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D28,  
          GPC_CFG(3, GPC3, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D29,
          GPC_CFG(4, GPC4, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D30, 
          GPC_CFG(5, GPC5, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },

  	                       
  { .arduino_id=ARDUINO_PIN_D31, 
          GPC_CFG(6, RSTN, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART,  
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D32,  
          GPC_CFG(7, GPC7, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_ADC, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },


  	                       
  { .arduino_id=ARDUINO_PIN_D33, 
          GPC_CFG(8, GPC8, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C|PIN_ATTR_ADC, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D34, 
          GPC_CFG(9, GPC9, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C|PIN_ATTR_CMP, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D35,  
          GPC_CFG(10, GPC10, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C|PIN_ATTR_CMP, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D36,  
          GPC_CFG(11, GPC11, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_I2C, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D37,   
          GPC_CFG(12, GPC12, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART| PIN_ATTR_PWM, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D38,  
          GPC_CFG(13, GPC13, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D39,  
          GPC_CFG(14, GPC14, DEFAULT_PIN_STATE), 
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false },


  // 40 .. 59 - Digital pins
  // ----------------------         
  { .arduino_id=ARDUINO_PIN_VSS1,
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D41, 
          GPD_CFG(0, GPD0, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI| PIN_ATTR_PWM, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D42, 
          GPD_CFG(1, GPD1, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI,  
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D43,
          GPD_CFG(2, GPD2, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI|PIN_ATTR_USB| PIN_ATTR_PWM, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D44,  
          GPD_CFG(3, GPD3, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI|PIN_ATTR_USB, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_USBDM,  
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_USBDP,  
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_V33, 
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D48, 
          GPD_CFG(7, GPD7, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D49,  
          GPD_CFG(8, GPD8, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D50, 
          GPD_CFG(9, GPD9, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI| PIN_ATTR_PWM, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D51,
          GPD_CFG(10, GPD10, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D52, 
          GPD_CFG(11, GPD11, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI|PIN_ATTR_DMA, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT3_IRQn,    .uconfigured=false },


  { .arduino_id=ARDUINO_PIN_VSS,  
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_VRD, 
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_VDD, 
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_VREF,
          GPNULL_CFG(),
  	             .mode=PIN_ATTR_NONE, 
  	                       .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=NMI_IRQn,    .uconfigured=false },


  { .arduino_id=ARDUINO_PIN_D57, 
          GPA_CFG(0, GPA0, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel= ADC_CHANNEL_0,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D58,
          GPA_CFG(1, GPA1, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel= ADC_CHANNEL_1,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },

  { .arduino_id=ARDUINO_PIN_D59,
          GPA_CFG(2, GPA2, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel= ADC_CHANNEL_2,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },


  // 60 .. 63 - Digital pins
  // ----------------------    
  { .arduino_id=ARDUINO_PIN_D60,
          GPA_CFG(3, GPA3, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel= ADC_CHANNEL_3,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D61, 
          GPA_CFG(4, GPA4, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel= ADC_CHANNEL_4,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D62,
          GPA_CFG(5, GPA5, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART, 
  	                       .ADCChannel= ADC_CHANNEL_5,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
  	                       
  { .arduino_id=ARDUINO_PIN_D63, 
          GPA_CFG(6, GPA6, DEFAULT_PIN_STATE),
  	             .mode=PIN_ATTR_DIGITAL|PIN_ATTR_ADC|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART|PIN_ATTR_SPI, 
  	                       .ADCChannel= ADC_CHANNEL_6,   .IO_irqnb=EXINT0_IRQn,    .uconfigured=false },
} ;



#ifdef __cplusplus
}
#endif



void serialEvent() __attribute__((weak));
void serialEvent()
{
    ;
}

void serialEventRun(void)
{
    if(Serial.available() )
    {
        serialEvent();
    }

}



// ----------------------------------------------------------------------------

#ifdef __cplusplus
extern "C" {
#endif

void __libc_init_array(void);


//设置其它所有端口的默认状态
void Init_ClearIoPin( void )
{
    GPIO_InitTypeDef GPIOX;

    GPIOX.Mode = GPIO_MODE_DIGITAL_I; //GPIO_MODE_ANALOG_IO;  //GPIO_MODE_DIGITAL_I;
    GPIOX.Pull = GPIO_PULLUP;
    GPIOX.Pin            = GPIO_Pin_All;
    GPIOX.Speed          = GPIO_SPEED_LOW;
    GPIOX.OUTDrive       = GPIO_OUTDRIVE_LEVEL0;
    GPIOX.FilterDivider  = GPIO_FILTERDIVIDER_BYPASS;
    GPIOX.Inverse        = GPIO_INVERSE_DISABLE;
    GPIOX.Alternate      = 0;

    MID_GPIO_Init(  IOMA , &GPIOX);
    MID_GPIO_Init(  IOMB , &GPIOX);
    MID_GPIO_Init(  IOMC , &GPIOX);
    MID_GPIO_Init(  IOMD , &GPIOX);
    MID_GPIO_Init(  IOME , &GPIOX);

    __DRV_GPIO_WRITE(GPIOA , 0xFFFF);
    __DRV_GPIO_WRITE(GPIOB , 0xFFFF);
    __DRV_GPIO_WRITE(GPIOC , 0xFFFF);
    __DRV_GPIO_WRITE(GPIOD , 0xFFFF);
    __DRV_GPIO_WRITE(GPIOE , 0xFFFF);

    {
        Pin_Struct*  pPinx;	
        PinDescription  Rst_PinDescription = 
        { .arduino_id=0, 
              GPC_CFG(6, RSTN, INPUT_PULLUP), 
                     .mode=PIN_ATTR_DIGITAL|PIN_ATTR_TIMER |PIN_ATTR_EXTINT|PIN_ATTR_UART,  
                               .ADCChannel=NB_ADC_CHANNEL_MANAGED,   .IO_irqnb=EXINT2_IRQn,    .uconfigured=false };
                               

        GPIOX.Mode = GPIO_MODE_DIGITAL_I;  //GPIO_MODE_ANALOG_IO; //GPIO_MODE_DIGITAL_I;
        GPIOX.Pull = GPIO_PULLUP;
    
        GPIOX.Pin            = Rst_PinDescription.GioPin;
        GPIOX.Speed          = GPIO_SPEED_LOW;
        GPIOX.OUTDrive       = GPIO_OUTDRIVE_LEVEL0;
        GPIOX.FilterDivider  = GPIO_FILTERDIVIDER_BYPASS;
        GPIOX.Inverse        = GPIO_INVERSE_DISABLE;
        GPIOX.Alternate      = Rst_PinDescription.AFS;
        pPinx = __GetPinxx_byGPIOx( Rst_PinDescription.ulPort, Rst_PinDescription.PinNum );
        
        MID_GPIO_Pin_Init(  pPinx,  &GPIOX);    
        __DRV_GPIO_CLEAR_BIT( Rst_PinDescription.ulPort,  Rst_PinDescription.PinNum );    
  	}
}

void init( void )
{
    Pin_Struct*  pPinx;		
    GPIO_InitTypeDef GPIOX;
    int i;

    hw_config_init();


    Init_ClearIoPin();
    
    // 基本初始化，如果是模拟或者时钟，则各模块各自进行初始化
    for(i=0; i<MAX_DIGITAL_IOS; i++)
    {
        if( ( g_APinDescription[i].mode==PIN_ATTR_NONE )
         || ( g_APinDescription[i].ulPort==NULL))
        {
            continue;

        }

        switch ( g_APinDescription[i].IO_Mode )
        {
            case INPUT:
                GPIOX.Mode = GPIO_MODE_DIGITAL_I;
                GPIOX.Pull = GPIO_NOPULLUP;
                break;

            case INPUT_PULLUP:
                GPIOX.Mode = GPIO_MODE_OPENDRAIN_O;
                GPIOX.Pull = GPIO_PULLUP;
                break;

            case INPUT_PULLDOWN:
                GPIOX.Mode = GPIO_MODE_DIGITAL_I;
                GPIOX.Pull = GPIO_NOPULLUP;
                break;

            case OUTPUT:
                GPIOX.Mode = GPIO_MODE_PUSHPULL_O;
                GPIOX.Pull = GPIO_PULLUP;
                break;

            case ANALOG_NOPULLUP:
                GPIOX.Mode = GPIO_MODE_ANALOG_IO;
                GPIOX.Pull = GPIO_NOPULLUP;
                break;

            case ANALOG_PULLUP:
            default:
                GPIOX.Mode = GPIO_MODE_ANALOG_IO;
                GPIOX.Pull = GPIO_PULLUP;
                break;
        }
        GPIOX.Pin            = g_APinDescription[i].GioPin;
        GPIOX.Speed          = GPIO_SPEED_LOW;
        GPIOX.OUTDrive       = GPIO_OUTDRIVE_LEVEL0;
        GPIOX.FilterDivider  = GPIO_FILTERDIVIDER_BYPASS;
        GPIOX.Inverse        = GPIO_INVERSE_DISABLE;
        GPIOX.Alternate      = g_APinDescription[i].AFS;
        pPinx = __GetPinxx_byGPIOx( g_APinDescription[i].ulPort, g_APinDescription[i].PinNum );
        
        MID_GPIO_Pin_Init(  pPinx,  &GPIOX);
        __DRV_GPIO_CLEAR_BIT( g_APinDescription[i].ulPort,  g_APinDescription[i].PinNum );
        //g_APinDescription[i].uconfigured = true;
    }

}

void initVariant()
{
    megawin_Uart_init();
        
    
    analogReadInit();
    analogOutputInit();
    
#if defined(HWSERIAL0)
    Serial.begin( &mURT0,
                  ARDUINO_PIN_UART0_RX,
                  ARDUINO_PIN_UART0_TX,
                  URT0_IRQn,  DEFAULT_INIT_BAUDRATE  );
#endif

    timer_cfg_init();
    
    Megawin_EXIC_Init();

}



#ifdef __cplusplus
}
#endif




#ifdef __cplusplus
extern "C" {
#endif


extern uint32_t SystemCoreClock;
uint32_t HAL_RCC_GetHCLKFreq()
{
    return SystemCoreClock;
}


unsigned int PINCOUNT_fn() 
{
    return (sizeof(g_APinDescription) / sizeof(PinDescription));
}


void analogWriteFrequency( uint32_t ulPin,  uint32_t freq)
{
    if( freq == 0 )
    {
        pwm_stop(ulPin);
    }
    
    if( freq > 1000000 )
    {
        freq = 1000000;
    }
    
    pwm_setFrequency(  ulPin,  freq );
    return;
}



/* Private function prototypes -----------------------------------------------*/
int fputc(int ch, FILE *f __attribute__((unused)));
/*
 *******************************************************************************
 * @brief	 Replace printf fputc function.
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
 /*
int fputc(int ch, FILE *f __attribute__((unused)))
{
    DEBUG_URTn->TDAT.B[0] = (uint8_t)ch;
    while((DEBUG_URTn->STA.W & URT_STA_TXF_mask_w)==0);
    
    return(ch);
}

*/


#ifdef __cplusplus
}
#endif


