/**
 ******************************************************************************
 *
 * @file        MG32x02z_TM.h
 *
 * @brief       MG32x02z TM Register Definitions Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.22 (Register File Date : 2022_0815)
 * @date        2022/08/25 15:14 (H File Generated Date)
 * @author      HeadCodeGen V1.42
 * @copyright   Copyright (c) 2022 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_TM_H
#define _MG32x02z_TM_H
#define _MG32x02z_TM_H_VER                          122     /*!< File Version */

#include "MG32x02z.h"

#if !(_MG32x02z_H_VER == _MG32x02z_TM_H_VER)
    #error "_MG32x02z_TM_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      TM_Struct
 *              TM  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  DIRF          :1;     //[0] Main Timer up/down counting flag.
                                        //0 = Up counting
                                        //1 = Down counting
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  BKF           :1;     //[2] Timer break input flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  EXF           :1;     //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TOF           :1;     //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TOF2          :1;     //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TUF           :1;     //[6] Main Timer underflow flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TUF2          :1;     //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF0A          :1;     //[8] Timer IC0 rising edge flag/OC0 event main flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF1A          :1;     //[9] Timer IC1 rising edge flag/OC1 event main flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF2A          :1;     //[10] Timer IC2 rising edge flag/OC2 event main flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF3A          :1;     //[11] Timer IC3 rising edge flag/OC3 event main flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF0B          :1;     //[12] Timer IC0 falling edge flag/OC0 event sub flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF1B          :1;     //[13] Timer IC1 falling edge flag/OC1 event sub flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF2B          :1;     //[14] Timer IC2 falling edge flag/OC2 event sub flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CF3B          :1;     //[15] Timer IC3 falling edge flag/OC3 event sub flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  DIRCF         :1;     //[16] Main Timer up/down counting direction change flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[17] 
            __IO uint8_t  IDXF          :1;     //[18] Main Timer QEI external index signal input active detect and internal timer reset fla
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  QPEF          :1;     //[19] Main Timer QEI phase state transition error detect flag.
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RTUF          :1;     //[20] Repetition timer underflow flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :3;     //[23..21] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  TM Timer status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] Timer interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  BKIE          :1;     //[2] Timer break input interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EXIE          :1;     //[3] Timer external trigger interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TIE           :1;     //[4] Timer overflow/underflow interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TIE2          :1;     //[5] 2nd Timer overflow/underflow interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  CC0_IE        :1;     //[8] Timer IC0/OC0 interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CC1_IE        :1;     //[9] Timer IC1/OC1 interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CC2_IE        :1;     //[10] Timer IC2/OC2 interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CC3_IE        :1;     //[11] Timer IC3/OC3 interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  DIRC_IE       :1;     //[16] Main Timer up/down counting direction change interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[17] 
            __IO uint8_t  IDX_IE        :1;     //[18] Main Timer QEI external index signal input active detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  QPE_IE        :1;     //[19] Main Timer QEI phase state transition error detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RTU_IE        :1;     //[20] Repetition timer underflow interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[23..21] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  TM Timer interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :2;     //[1..0] 
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  CKE_SEL       :2;     //[5..4] Timer internal clock CK_EXT source select.
                                        //0x0 = ETR (CK_ETR)
                                        //0x1 = ITR (CK_ITR)
                                        //0x2 = IN0 (TM_IN0)
                                        //0x3 = IN1 (TM_IN1)
            __IO uint8_t  CKS_SEL       :1;     //[6] Counter/Timer CK_TC clock source select.
                                        //0 = CK_INT
                                        //1 = CK_EXT
            __IO uint8_t  CKS2_SEL      :1;     //[7] Counter/Timer CK_TC2 clock source select.
                                        //0 = CK_INT
                                        //1 = CK_EXT
            __IO uint8_t  CKI_SEL       :2;     //[9..8] Timer input clock CK_TM source select.
                                        //0x0 = PROC : CK_TM_PR process clock from CSC
                                        //0x1 = Reserved
                                        //0x2 = CK_LS
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  CKI_DIV       :2;     //[13..12] Timer internal clock CK_TM_INT input divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  DTG_DIV       :2;     //[17..16] Timer internal dead time clock CK_DTG divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[19..18] 
            __IO uint8_t  RC_CKS        :1;     //[20] Repetition Timer/Counter clock source select.
                                        //0 = MAIN : clock input from Main timer overflow/underflow
                                        //1 = CKO : clock input from CK_CKOM
            __I  uint8_t                :3;     //[23..21] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  TM Timer clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TRGI_MDS      :3;     //[2..0] Timer trigger input mode select
                                        //0x0 = No operation
                                        //0x1 = Trigger-R (TRGI rising)
                                        //0x2 = Reset-R (TRGI rising)
                                        //0x3 = Gate-H (TRGI high)
                                        //0x4 = Reset (TRGI dual edge)
                                        //0x5 = Trigger-F (TRGI falling)
                                        //0x6 = Reset-F (TRGI falling)
                                        //0x7 = Gate-L (TRGI low)
            __IO uint8_t  TRGI2_MDS     :3;     //[5..3] 2nd Timer trigger input mode select
                                        //0x0 = No operation
                                        //0x1 = Trigger-R (TRGI rising)
                                        //0x2 = Reset-R (TRGI rising)
                                        //0x3 = Gate-H (TRGI high)
                                        //0x4 = Reset (TRGI dual edge)
                                        //0x5 = Trigger-F (TRGI falling)
                                        //0x6 = Reset-F (TRGI falling)
                                        //0x7 = Gate-L (TRGI low)
            __IO uint8_t  TRG_MUX       :2;     //[7..6] Timer trigger source TRGI select.
                                        //0x0 = ETR (CK_ETR)
                                        //0x1 = ITR (CK_ITR)
                                        //0x2 = IN0 (TM_IN0)
                                        //0x3 = IN1 (TM_IN1)
            __IO uint8_t  ITR_MUX       :3;     //[10..8] Timer internal trigger source select
                                        //0x0 = ITR0 (TM_ITR0)
                                        //0x1 = ITR1 (TM_ITR1)
                                        //0x2 = ITR2 (TM_ITR2)
                                        //0x3 = ITR3 (TM_ITR3)
                                        //0x4 = ITR4 (TM_ITR4)
                                        //0x5 = ITR5 (TM_ITR5)
                                        //0x6 = ITR6 (TM_ITR6)
                                        //0x7 = ITR7 (TM_ITR7)
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  TRGO_MDS      :4;     //[15..12] Timer trigger output mode select
                                        //0x0 = RST : TM_RST (Main Timer Reset)
                                        //0x1 = EN : TM_EN (Main Timer Enable)
                                        //0x2 = UEV : TM_UEV (Main Timer Update event)
                                        //0x3 = TOF : TM_TOF (Main Timer overflow)
                                        //0x4 = TUF : TM_TUF (Main Timer underflow)
                                        //0x5 = EN2 : TM_EN2 (Timer-2 Enable)
                                        //0x6 = TOF2 :TM_TOF2 (Timer-2 overflow)
                                        //0x7 = DIR : TM_DIR (Main Timer direction event)
                                        //0x8 = UEV2 : TM_UEV2 (Timer-2 Update event)
                                        //0x9 = SW : TM_TRGO_SW (software control bit)
                                        //0xA = OS0 : TM_OS0 (channel-0 output state signal)
                                        //0xB = OS1 : TM_OS1 (channel-1 output state signal)
                                        //0xC = OS2 : TM_OS2 (channel-2 output state signal)
                                        //0xD = OS3 : TM_OS3 (channel-3 output state signal)
                                        //0xE = TRGI : TM_TRGI (internal TRGI signal)
                                        //0xF = POE : TM_POE (Output enable register preload signal)
            __IO uint8_t  QEI_MDS       :3;     //[18..16] Main Timer quadrature encoder interface
                                        //0x0 = No operation (up/down control by TM_DIR)
                                        //0x1 = IN0POS : TM_IN0 positive (high level up count, low level down count)
                                        //0x2 = IN0NEG : TM_IN0 negative (low level up count, high level down count)
                                        //0x3 = IN0TRG : TM_IN0 trigger (edge depending on TM_IN1 level)
                                        //0x4 = IN1TRG : TM_IN1 trigger (edge depending on TM_IN0 level)
                                        //0x5 = BOTH : Both TM_IN0 and TM_IN1 edge
            __IO uint8_t  IDX_EN        :1;     //[19] Main Timer QEI external index signal input enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IDX_MDS       :2;     //[21..20] Main Timer QEI external index signal input reset timer transition state select.
                                        //0x0 = 1T2 : State change between 1 and 2
                                        //0x1 = 2T3 : State change between 2 and 3
                                        //0x2 = 3T4 : State change between 3 and 4
                                        //0x3 = 4T1 : State change between 4 and 1
            __IO uint8_t  UEV_SEL       :2;     //[23..22] Timer UEV output select bits for TM_TRGO
                                        //0x0 = All : output all UEV pulses
                                        //0x1 = TOF : output timer overflow pulses
                                        //0x2 = UDF : output timer underflow pulses
                                        //0x3 = Reserved
            __IO uint8_t  TRGO_SW       :1;     //[24] Timer TRGO software control data bit.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  TRGO_INV      :1;     //[25] Timer TRGO output inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :2;     //[27..26] 
            __IO uint8_t  RST_SW        :1;     //[28] Timer reset software enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RST2_SW       :1;     //[29] 2nd Timer reset software enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  GT_SW         :1;     //[30] Timer clock gating software enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  GT2_SW        :1;     //[31] 2nd Timer clock gating software enable bit.
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }TRG;                               /*!< TRG        ~ Offset[0x0C]  TM Timer trigger control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] Main Timer/Counter enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EN2           :1;     //[1] 2nd Timer/Counter enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  MDS           :2;     //[5..4] Timer operation mode select
                                        //0x0 = Cascade : 16-bit counter with 16-bit prescaler  Mode
                                        //0x1 = Separate : Separated two 16-bit counters Mode
                                        //0x2 = Full-Counter : 32-bit counter Mode
                                        //0x3 = Reserved
            __IO uint8_t  DIR           :1;     //[6] Main Timer counting direction bit
                                        //0 = Up (Up Counting)
                                        //1 = Down (Down Counting)
            __IO uint8_t  DIR2          :1;     //[7] 2nd Timer counting direction bit.
                                        //0 = Up (Up Counting)
                                        //1 = Down (Down Counting)
            __IO uint8_t  ASTOP_EN      :1;     //[8] Timer auto stop mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ACLEAR_EN     :1;     //[9] Timer overflow or underflow flag auto-clear enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EX_EN         :1;     //[10] Timer external trigger event enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EX_INV        :1;     //[11] Timer external trigger input inverted enable.
                                        //0 = Normal
                                        //1 = Inverted
            __IO uint8_t  UEV_DIS       :1;     //[12] Update event generation disable for main Timer
                                        //0 = Enable
                                        //1 = Disable
            __IO uint8_t  DIR_INV       :1;     //[13] Main Timer counting direction inverted enable.
                                        //0 = Normal
                                        //1 = Inverted
            __IO uint8_t  USW_EN        :1;     //[14] Timer software update event generation enable.  (automatically clear by hardware)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  UEX_EN        :1;     //[15] Timer external trigger update event enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RC_EN         :1;     //[16] Repetition Counter enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RC_STP        :1;     //[17] Main Counter stop enable when repetition counter underflow.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[23..18] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  TM Timer control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OVR0_MDS      :1;     //[0] Timer channel 0 capture data buffer overrun mode select
                                        //0 = Overwritten (Overwritten by new data)
                                        //1 = Keep (Preserved old data)
            __IO uint8_t  OVR1_MDS      :1;     //[1] Timer channel 1 capture data buffer overrun mode select
                                        //0 = Overwritten (Overwritten by new data)
                                        //1 = Keep (Preserved old data)
            __IO uint8_t  OVR2_MDS      :1;     //[2] Timer channel 2 capture data buffer overrun mode select
                                        //0 = Overwritten (Overwritten by new data)
                                        //1 = Keep (Preserved old data)
            __IO uint8_t  OVR3_MDS      :1;     //[3] Timer channel 3 capture data buffer overrun mode select
                                        //0 = Overwritten (Overwritten by new data)
                                        //1 = Keep (Preserved old data)
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  CC0A_SEN      :1;     //[8] Timer channel 0 software IC/OC event-A generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __IO uint8_t  CC1A_SEN      :1;     //[9] Timer channel 1 software IC/OC event-A generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __IO uint8_t  CC2A_SEN      :1;     //[10] Timer channel 2 software IC/OC event-A generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __IO uint8_t  CC3A_SEN      :1;     //[11] Timer channel 3 software IC/OC event-A generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __IO uint8_t  CC0B_SEN      :1;     //[12] Timer channel 0 software IC/OC event-B generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __IO uint8_t  CC1B_SEN      :1;     //[13] Timer channel 1 software IC/OC event-B generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __IO uint8_t  CC2B_SEN      :1;     //[14] Timer channel 2 software IC/OC event-B generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __IO uint8_t  CC3B_SEN      :1;     //[15] Timer channel 3 software IC/OC event-B generation enable
                                        //0 = No-Effect
                                        //1 = Enable
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  TM Timer control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CKO_EN        :1;     //[0] Timer overflow as CKO output enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CKO_SEL       :1;     //[1] Timer overflow as CKO output source select.
                                        //0 = 2nd : 2nd Timer overflow
                                        //1 = Main : Main Timer overflow
            __IO uint8_t  CKO_STA       :1;     //[2] Timer CKO output signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  CKO_LCK       :1;     //[3] TM_CKO_STA  register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CKO;                               /*!< CKO        ~ Offset[0x18]  TM Timer CKO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RCNT          :8;     //[7..0] Repetition counter register.
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  RARR          :8;     //[23..16] Repetition counter auto-reload value register
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }RCNT;                              /*!< RCNT       ~ Offset[0x1C]  TM repetition counter register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CNT           :16;    //[15..0] Main timer/counter register.
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CNT;                               /*!< CNT        ~ Offset[0x20]  TM Timer main counter register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t ARR           :16;    //[15..0] Main timer/counter auto-reload value register.
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }ARR;                               /*!< ARR        ~ Offset[0x24]  TM Timer main counter auto-reload value register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t PSCNT         :16;    //[15..0] Timer prescaler or 2nd  timer/counter register
            __I  uint16_t CNTA          :16;    //[31..16] Main timer/counter alias register
        }MBIT;
    }PSCNT;                             /*!< PSCNT      ~ Offset[0x28]  TM Timer prescaler register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t PSARR         :16;    //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }PSARR;                             /*!< PSARR      ~ Offset[0x2C]  TM Timer prescaler auto-reload register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CC0_MDS       :3;     //[2..0] Timer channel 0 capture and compare mode select.
                                        //0x0 = NOP (No operation)
                                        //0x1 = 16bit_IC (Input capture)
                                        //0x2 = 16bit_OC (Output compare)
                                        //0x3 = 8bitx2_OC (Two 8-bit compare)
                                        //0x4 = 16bit_PWM (16bit PWM)
                                        //0x5 = 8bitx2_PWM (Two 8bit PWMs)
                                        //0x6 = 16bit_PWM_DTG (16bit PWM with DTG)
                                        //0x7 = 8bitx2_PWM_DTG (Two 8bit PWMs with DTG)
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  CC1_MDS       :3;     //[6..4] Timer channel 1 capture and compare mode select. 
                                        //0x0 = NOP (No operation)
                                        //0x1 = 16bit_IC (Input capture)
                                        //0x2 = 16bit_OC (Output compare)
                                        //0x3 = 8bitx2_OC (Two 8-bit compare)
                                        //0x4 = 16bit_PWM (16bit PWM)
                                        //0x5 = 8bitx2_PWM (Two 8bit PWMs)
                                        //0x6 = 16bit_PWM_DTG (16bit PWM with DTG)
                                        //0x7 = 8bitx2_PWM_DTG (Two 8bit PWMs with DTG)
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CC2_MDS       :3;     //[10..8] Timer channel 2 capture and compare mode select. 
                                        //0x0 = NOP (No operation)
                                        //0x1 = 16bit_IC (Input capture)
                                        //0x2 = 16bit_OC (Output compare)
                                        //0x3 = 8bitx2_OC (Two 8-bit compare)
                                        //0x4 = 16bit_PWM (16bit PWM)
                                        //0x5 = 8bitx2_PWM (Two 8bit PWMs)
                                        //0x6 = 16bit_PWM_DTG (16bit PWM with DTG)
                                        //0x7 = 8bitx2_PWM_DTG (Two 8bit PWMs with DTG)
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  CC3_MDS       :3;     //[14..12] Timer channel 3 capture and compare mode select. 
                                        //0x0 = NOP (No operation)
                                        //0x1 = 16bit_IC (Input capture)
                                        //0x2 = 16bit_OC (Output compare)
                                        //0x3 = 8bitx2_OC (Two 8-bit compare)
                                        //0x4 = 16bit_PWM (16bit PWM)
                                        //0x5 = 8bitx2_PWM (Two 8bit PWMs)
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  OC_LCK        :1;     //[16] Timer output compare reload function lock enable bit for all channel
                                        //0 = un-Locked : enable unlocked
                                        //1 = Locked : enable locked
            __I  uint8_t                :6;     //[22..17] 
            __IO uint8_t  DMA_OMDS      :1;     //[23] Timer output DMA request mode select
                                        //0 = UEV : UEV update event only
                                        //1 = ITR : both UEV and ITR
            __IO uint8_t  DMA_CC0E      :1;     //[24] Direct memory access enable for OC0.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_CC1E      :1;     //[25] Direct memory access enable for OC1.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_CC2E      :1;     //[26] Direct memory access enable for OC2.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_CC3E      :1;     //[27] Direct memory access enable for IC3.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CCMDS;                             /*!< CCMDS      ~ Offset[0x30]  TM Timer capture and compare mode select register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IC0_MUX       :2;     //[1..0] Timer channel 0 input Mux select for input capture.
                                        //0x0 = IC00 : TM_IC0
                                        //0x1 = IC01 : TM_ITR
                                        //0x2 = IC02 : CMP0_OUT
                                        //0x3 = IC03 : TM_XOR
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  IC1_MUX       :2;     //[5..4] Timer channel 1 input Mux select for input capture.
                                        //0x0 = IC10 : TM_IC1
                                        //0x1 = IC11 : TM_ITR
                                        //0x2 = IC12 : CMP1_OUT
                                        //0x3 = IC13 : Reserved
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  IC2_MUX       :2;     //[9..8] Timer channel 2 input Mux select for input capture.
                                        //0x0 = IC20 : TM_IC2
                                        //0x1 = IC21 : TM_ITR
                                        //0x2 = IC22 : Reserved
                                        //0x3 = IC23 : Reserved
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  IC3_MUX       :2;     //[13..12] Timer channel 3 input Mux select for input capture.
                                        //0x0 = IC30 : TM_IC3
                                        //0x1 = IC31 : TM_ITR
                                        //0x2 = IC32 : Reserved
                                        //0x3 = IC33 : TM_XOR
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  IC0_TRGS      :2;     //[17..16] Timer channel 0 input trigger edge select.
                                        //0x0 = Disable : disable capture data
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __IO uint8_t  IC1_TRGS      :2;     //[19..18] Timer channel 1 input trigger edge select. 
                                        //0x0 = Disable : disable capture data
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __IO uint8_t  IC2_TRGS      :2;     //[21..20] Timer channel 2 input trigger edge select.
                                        //0x0 = Disable : disable capture data
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __IO uint8_t  IC3_TRGS      :2;     //[23..22] Timer channel 3 input trigger edge select.
                                        //0x0 = Disable : disable capture data
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }ICCR;                              /*!< ICCR       ~ Offset[0x34]  TM Timer input capture control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OS0_STA       :1;     //[0] Timer channel 0 OC compare/compare-L output signal initial state.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS1_STA       :1;     //[1] Timer channel 1 OC compare/compare-L output signal initial state.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS2_STA       :1;     //[2] Timer channel 2 OC compare/compare-L output signal initial state.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS3_STA       :1;     //[3] Timer channel 3 OC compare/compare-L output signal initial state.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS0_LCK       :1;     //[4] TM_OS0_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __IO uint8_t  OS1_LCK       :1;     //[5] TM_OS1_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __IO uint8_t  OS2_LCK       :1;     //[6] TM_OS2_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __IO uint8_t  OS3_LCK       :1;     //[7] TM_OS3_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __IO uint8_t  OS0H_STA      :1;     //[8] Timer channel 0 OC compare-H output signal initial state for two 8-Bit comparator mod
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS1H_STA      :1;     //[9] Timer channel 1 OC compare-H output signal initial state for two 8-Bit comparator mod
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS2H_STA      :1;     //[10] Timer channel 2 OC compare-H output signal initial state for two 8-Bit comparator mod
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS3H_STA      :1;     //[11] Timer channel 3 OC compare-H output signal initial state for two 8-Bit comparator mod
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OS0H_LCK      :1;     //[12] TM_OS0H_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __IO uint8_t  OS1H_LCK      :1;     //[13] TM_OS1H_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __IO uint8_t  OS2H_LCK      :1;     //[14] TM_OS2H_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __IO uint8_t  OS3H_LCK      :1;     //[15] TM_OS3H_STA register write access protected control
                                        //0 = Locked (enable chip hardware control)
                                        //1 = Un-Locked (disable chip hardware control)
            __I  uint8_t                :1;     //[16] 
            __I  uint8_t                :1;     //[17] 
            __I  uint8_t                :1;     //[18] 
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }OSCR;                              /*!< OSCR       ~ Offset[0x38]  TM Timer output compare state register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OC0_OE0       :1;     //[0] Timer channel 0 OC line-0 output enable.
                                        //0 = Disable (output by TM_BK0_STA setting)
                                        //1 = Enable
            __IO uint8_t  OC0_OE1       :1;     //[1] Timer channel 0 OC line-1 output enable.
                                        //0 = Disable (output by TM_BK0_STA setting)
                                        //1 = Enable
            __IO uint8_t  OC0_OE2       :1;     //[2] Timer channel 0 OC line-2 output enable.
                                        //0 = Disable (output by TM_BK0_STA setting)
                                        //1 = Enable
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  OC1_OE0       :1;     //[4] Timer channel 1 OC line-0 output enable.
                                        //0 = Disable (output by TM_BK1_STA setting)
                                        //1 = Enable
            __IO uint8_t  OC1_OE1       :1;     //[5] Timer channel 1 OC line-1 output enable.
                                        //0 = Disable (output by TM_BK1_STA setting)
                                        //1 = Enable
            __IO uint8_t  OC1_OE2       :1;     //[6] Timer channel 1 OC line-2 output enable.
                                        //0 = Disable (output by TM_BK1_STA setting)
                                        //1 = Enable
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  OC2_OE        :1;     //[8] Timer channel 2 OC line output enable.
                                        //0 = Disable (output by TM_BK2_STA setting)
                                        //1 = Enable
            __I  uint8_t                :3;     //[11..9] 
            __IO uint8_t  OC3_OE        :1;     //[12] Timer channel 3 OC line output enable.
                                        //0 = Disable (output by TM_BK3_STA setting)
                                        //1 = Enable
            __I  uint8_t                :3;     //[15..13] 
            __IO uint8_t  OC0N_OE       :1;     //[16] Timer channel 0 OC0N (complement) line output enable.
                                        //0 = Disable (output by TM_BK0N_STA setting)
                                        //1 = Enable
            __I  uint8_t                :3;     //[19..17] 
            __IO uint8_t  OC1N_OE       :1;     //[20] Timer channel 1 OC1N (complement) line output enable.
                                        //0 = Disable (output by TM_BK1N_STA setting)
                                        //1 = Enable
            __I  uint8_t                :3;     //[23..21] 
            __IO uint8_t  OC2N_OE       :1;     //[24] Timer channel 2 OC2N (complement) line output enable.
                                        //0 = Disable (output by TM_BK2N_STA setting)
                                        //1 = Enable
            __I  uint8_t                :3;     //[27..25] 
            __I  uint8_t                :1;     //[28] 
            __I  uint8_t                :1;     //[29] 
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }OCCR0;                             /*!< OCCR0      ~ Offset[0x3C]  TM Timer output compare control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OC0_INV       :1;     //[0] Timer channel 0 output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC1_INV       :1;     //[1] Timer channel 1 output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC2_INV       :1;     //[2] Timer channel 2 output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC3_INV       :1;     //[3] Timer channel 3 output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC0H_INV      :1;     //[4] Timer channel 0 High output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC1H_INV      :1;     //[5] Timer channel 1 High output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC2H_INV      :1;     //[6] Timer channel 2 High output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC3H_INV      :1;     //[7] Timer channel 3 High output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC0N_INV      :1;     //[8] Timer channel 0 complement output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC1N_INV      :1;     //[9] Timer channel 1 complement output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC2N_INV      :1;     //[10] Timer channel 2 complement output inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :5;     //[15..11] 
            __IO uint8_t  OC0_POE0      :1;     //[16] Timer channel 0 OC line-0 output enable preload register bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC0_POE1      :1;     //[17] Timer channel 0 OC line-1 output enable preload register bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC0_POE2      :1;     //[18] Timer channel 0 OC line-2 output enable preload register bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  OC1_POE0      :1;     //[20] Timer channel 1 OC line-0 output enable preload register bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC1_POE1      :1;     //[21] Timer channel 1 OC line-1 output enable preload register bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OC1_POE2      :1;     //[22] Timer channel 1 OC line-2 output enable preload register bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  POE_EN0       :1;     //[24] Timer OC preload enable bit for output enable preload register control
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  POE_EN1       :1;     //[25] Timer OC preload enable bit for output enable preload register control
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  POE_EN2       :1;     //[26] Timer OC preload enable bit for output enable preload register control
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[27] 
            __O  uint8_t  POE_SW        :1;     //[28] Timer output enable registers preload software enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[29] 
            __IO uint8_t  ODLY_SEL      :1;     //[30] Timer output delay mode select
                                        //0x0 = 0Step
                                        //0x1 = 1Step
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }OCCR1;                             /*!< OCCR1      ~ Offset[0x40]  TM Timer output compare control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  PWM_MDS       :2;     //[1..0] Timer OC0/1/2/3 PWM mode select.
                                        //0x0 = Edge Left-aligned
                                        //0x1 = Center-aligned
                                        //0x2 = Reserved
                                        //0x3 = Reserved
            __I  uint8_t                :6;     //[7..2] 
            __IO uint8_t  DTG_DY        :8;     //[15..8] Timer output DTG dead-time delay(CK_DTG clock time base) for all channels
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }PWM;                               /*!< PWM        ~ Offset[0x44]  TM Timer PWM and DTG control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  BK_EN         :1;     //[0] Timer Break Input enable for OC[2:0]. (output state stop or reset)
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[2..1] 
            __IO uint8_t  BK_EN3        :1;     //[3] Timer Break Input enable for OC3. (output state stop or reset)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BK_MDS        :1;     //[4] Timer break event input control mode select.
                                        //0 = Latch mode
                                        //1 = Cycle by cycle
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  BKSW_EN       :1;     //[7] Timer software break input generation enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN0       :1;     //[8] Timer Break external input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN1       :1;     //[9] Timer Break external input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN2       :1;     //[10] Timer Break external input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN3       :1;     //[11] Timer Break external input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN4       :1;     //[12] Timer Break external input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN5       :1;     //[13] Timer Break external input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN6       :1;     //[14] Timer Break external input channels' enable bit. This bit is reserved.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKE_EN7       :1;     //[15] Timer Break external input channels' enable bit. This bit is reserved.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKI_EN0       :1;     //[16] Timer Break internal input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKI_EN1       :1;     //[17] Timer Break internal input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKI_EN2       :1;     //[18] Timer Break internal input channels' enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  BK0_CTL       :1;     //[20] Timer OC0 output switch control when break event happened
                                        //0 = Stop (Switch to stop state register setting)
                                        //1 = Hold (hold the output state)
            __IO uint8_t  BK1_CTL       :1;     //[21] Timer OC1 output switch control when break event happened
                                        //0 = Stop (Switch to stop state register setting)
                                        //1 = Hold (hold the output state)
            __IO uint8_t  BK2_CTL       :1;     //[22] Timer OC2 output switch control when break event happened
                                        //0 = Stop (Switch to stop state register setting)
                                        //1 = Hold (hold the output state)
            __IO uint8_t  BK3_CTL       :1;     //[23] Timer OC3 output switch control when break event happened
                                        //0 = Stop (Switch to stop state register setting)
                                        //1 = Hold (hold the output state)
            __IO uint8_t  STP0_STA      :1;     //[24] Timer BK input active or stop condition output OC0 state select.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  STP1_STA      :1;     //[25] Timer BK input active or stop condition output OC1 state select.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  STP2_STA      :1;     //[26] Timer BK input active or stop condition output OC2 state select.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  STP3_STA      :1;     //[27] Timer BK input active or stop condition output OC3 state select.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  STP0N_STA     :1;     //[28] Timer BK input active or stop condition output OC0N state select.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  STP1N_STA     :1;     //[29] Timer BK input active or stop condition output OC1N state select.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  STP2N_STA     :1;     //[30] Timer BK input active or stop condition output OC2N state select.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }BS;                                /*!< BS         ~ Offset[0x48]  TM Timer break and stop control register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x4C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC0A          :16;    //[15..0] TM Timer capture and compare register 0A for channel 0
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC0A;                              /*!< CC0A       ~ Offset[0x50]  TM Timer capture and compare register 0A */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC0B          :16;    //[15..0] TM Timer capture and compare register 0B for channel 0
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC0B;                              /*!< CC0B       ~ Offset[0x54]  TM Timer capture and compare register 0B */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC1A          :16;    //[15..0] TM Timer capture and compare register 1A for channel 1
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC1A;                              /*!< CC1A       ~ Offset[0x58]  TM Timer capture and compare register 1A */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC1B          :16;    //[15..0] TM Timer capture and compare register 1B for channel 1
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC1B;                              /*!< CC1B       ~ Offset[0x5c]  TM Timer capture and compare register 1B */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC2A          :16;    //[15..0] TM Timer capture and compare register 2A for channel 2
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC2A;                              /*!< CC2A       ~ Offset[0x60]  TM Timer capture and compare register 2A */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC2B          :16;    //[15..0] TM Timer capture and compare register 2B for channel 2
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC2B;                              /*!< CC2B       ~ Offset[0x64]  TM Timer capture and compare register 2B */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC3A          :16;    //[15..0] TM Timer capture and compare register 3A for channel 3
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC3A;                              /*!< CC3A       ~ Offset[0x68]  TM Timer capture and compare register 3A */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CC3B          :16;    //[15..0] Timer TM capture and compare register 3B for channel 3
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CC3B;                              /*!< CC3B       ~ Offset[0x6c]  TM Timer capture and compare register 3B */

} TM_Struct;

/**
 ******************************************************************************
 *
 * @name        TM  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define TM00_Base                       ((uint32_t)0x55000000)              /*!< Timer Control Module-00 */
#define TM01_Base                       ((uint32_t)0x55010000)              /*!< Timer Control Module-01 */
#define TM10_Base                       ((uint32_t)0x55800000)              /*!< Timer Control Module-10 */
#define TM16_Base                       ((uint32_t)0x55860000)              /*!< Timer Control Module-16 */
#define TM20_Base                       ((uint32_t)0x56000000)              /*!< Timer Control Module-20 */
#define TM26_Base                       ((uint32_t)0x56060000)              /*!< Timer Control Module-26 */
#define TM36_Base                       ((uint32_t)0x56860000)              /*!< Timer Control Module-36 */
#define TM00                            ((TM_Struct*) TM00_Base)
#define TM01                            ((TM_Struct*) TM01_Base)
#define TM10                            ((TM_Struct*) TM10_Base)
#define TM16                            ((TM_Struct*) TM16_Base)
#define TM20                            ((TM_Struct*) TM20_Base)
#define TM26                            ((TM_Struct*) TM26_Base)
#define TM36                            ((TM_Struct*) TM36_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        TM  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        TM_STA  [register's definitions]
 *              Offset[0x00]  TM Timer status register
 ******************************************************************************
 */
///@{
#define TM_STA_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_STA */
#define TM_STA_RTUF_mask_w                          ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define TM_STA_RTUF_mask_h1                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_STA_RTUF_mask_b2                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_STA_RTUF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_RTUF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_RTUF_normal_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_RTUF_happened_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_RTUF_happened_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_RTUF_happened_b2                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_QPEF_mask_w                          ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define TM_STA_QPEF_mask_h1                         ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_STA_QPEF_mask_b2                         ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_STA_QPEF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_QPEF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_QPEF_normal_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_QPEF_happened_w                      ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_QPEF_happened_h1                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_QPEF_happened_b2                     ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_IDXF_mask_w                          ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define TM_STA_IDXF_mask_h1                         ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_STA_IDXF_mask_b2                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_STA_IDXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_IDXF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_IDXF_normal_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_IDXF_happened_w                      ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_IDXF_happened_h1                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_IDXF_happened_b2                     ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_DIRCF_mask_w                         ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define TM_STA_DIRCF_mask_h1                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_STA_DIRCF_mask_b2                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_STA_DIRCF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_DIRCF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_DIRCF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_DIRCF_happened_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_DIRCF_happened_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_DIRCF_happened_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF3B_mask_w                          ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define TM_STA_CF3B_mask_h0                         ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define TM_STA_CF3B_mask_b1                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_STA_CF3B_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF3B_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF3B_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF3B_happened_w                      ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF3B_happened_h0                     ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF3B_happened_b1                     ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF2B_mask_w                          ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define TM_STA_CF2B_mask_h0                         ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_STA_CF2B_mask_b1                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_STA_CF2B_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF2B_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF2B_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF2B_happened_w                      ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF2B_happened_h0                     ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF2B_happened_b1                     ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF1B_mask_w                          ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define TM_STA_CF1B_mask_h0                         ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define TM_STA_CF1B_mask_b1                         ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_STA_CF1B_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF1B_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF1B_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF1B_happened_w                      ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF1B_happened_h0                     ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF1B_happened_b1                     ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF0B_mask_w                          ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define TM_STA_CF0B_mask_h0                         ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_STA_CF0B_mask_b1                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_STA_CF0B_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF0B_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF0B_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF0B_happened_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF0B_happened_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF0B_happened_b1                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF3A_mask_w                          ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define TM_STA_CF3A_mask_h0                         ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_STA_CF3A_mask_b1                         ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_STA_CF3A_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF3A_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF3A_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF3A_happened_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF3A_happened_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF3A_happened_b1                     ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF2A_mask_w                          ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define TM_STA_CF2A_mask_h0                         ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_STA_CF2A_mask_b1                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_STA_CF2A_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF2A_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF2A_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF2A_happened_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF2A_happened_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF2A_happened_b1                     ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF1A_mask_w                          ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define TM_STA_CF1A_mask_h0                         ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_STA_CF1A_mask_b1                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_STA_CF1A_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF1A_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF1A_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF1A_happened_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF1A_happened_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF1A_happened_b1                     ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_CF0A_mask_w                          ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_STA_CF0A_mask_h0                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_STA_CF0A_mask_b1                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_STA_CF0A_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_CF0A_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_CF0A_normal_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_CF0A_happened_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_CF0A_happened_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_CF0A_happened_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_TUF2_mask_w                          ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define TM_STA_TUF2_mask_h0                         ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_STA_TUF2_mask_b0                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_STA_TUF2_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_TUF2_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_TUF2_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_TUF2_happened_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_TUF2_happened_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_TUF2_happened_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_TUF_mask_w                           ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define TM_STA_TUF_mask_h0                          ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_STA_TUF_mask_b0                          ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_STA_TUF_normal_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_TUF_normal_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_TUF_normal_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_TUF_happened_w                       ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_TUF_happened_h0                      ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_TUF_happened_b0                      ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_TOF2_mask_w                          ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define TM_STA_TOF2_mask_h0                         ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define TM_STA_TOF2_mask_b0                         ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_STA_TOF2_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_TOF2_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_TOF2_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_TOF2_happened_w                      ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_TOF2_happened_h0                     ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_TOF2_happened_b0                     ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_TOF_mask_w                           ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define TM_STA_TOF_mask_h0                          ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_STA_TOF_mask_b0                          ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_STA_TOF_normal_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_TOF_normal_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_TOF_normal_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_TOF_happened_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_TOF_happened_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_TOF_happened_b0                      ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_EXF_mask_w                           ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define TM_STA_EXF_mask_h0                          ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_STA_EXF_mask_b0                          ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_STA_EXF_normal_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_EXF_normal_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_EXF_normal_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_EXF_happened_w                       ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_EXF_happened_h0                      ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_EXF_happened_b0                      ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_BKF_mask_w                           ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define TM_STA_BKF_mask_h0                          ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_STA_BKF_mask_b0                          ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_STA_BKF_normal_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_STA_BKF_normal_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_STA_BKF_normal_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_STA_BKF_happened_w                       ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define TM_STA_BKF_happened_h0                      ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define TM_STA_BKF_happened_b0                      ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define TM_STA_DIRF_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_STA_DIRF_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_STA_DIRF_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_STA_DIRF_up_counting_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Up counting of 32bit */
#define TM_STA_DIRF_up_counting_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Up counting of 16bit */
#define TM_STA_DIRF_up_counting_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Up counting of 8bit */
#define TM_STA_DIRF_down_counting_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Down counting of 32bit */
#define TM_STA_DIRF_down_counting_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Down counting of 16bit */
#define TM_STA_DIRF_down_counting_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Down counting of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_INT  [register's definitions]
 *              Offset[0x04]  TM Timer interrupt enable register
 ******************************************************************************
 */
///@{
#define TM_INT_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_INT */
#define TM_INT_RTU_IE_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define TM_INT_RTU_IE_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_INT_RTU_IE_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_INT_RTU_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_RTU_IE_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_RTU_IE_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_RTU_IE_enable_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_RTU_IE_enable_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_RTU_IE_enable_b2                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_QPE_IE_mask_w                        ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define TM_INT_QPE_IE_mask_h1                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_INT_QPE_IE_mask_b2                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_INT_QPE_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_QPE_IE_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_QPE_IE_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_QPE_IE_enable_w                      ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_QPE_IE_enable_h1                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_QPE_IE_enable_b2                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_IDX_IE_mask_w                        ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define TM_INT_IDX_IE_mask_h1                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_INT_IDX_IE_mask_b2                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_INT_IDX_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_IDX_IE_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_IDX_IE_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_IDX_IE_enable_w                      ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_IDX_IE_enable_h1                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_IDX_IE_enable_b2                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_DIRC_IE_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define TM_INT_DIRC_IE_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_INT_DIRC_IE_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_INT_DIRC_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_DIRC_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_DIRC_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_DIRC_IE_enable_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_DIRC_IE_enable_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_DIRC_IE_enable_b2                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_CC3_IE_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define TM_INT_CC3_IE_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_INT_CC3_IE_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_INT_CC3_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_CC3_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_CC3_IE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_CC3_IE_enable_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_CC3_IE_enable_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_CC3_IE_enable_b1                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_CC2_IE_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define TM_INT_CC2_IE_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_INT_CC2_IE_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_INT_CC2_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_CC2_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_CC2_IE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_CC2_IE_enable_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_CC2_IE_enable_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_CC2_IE_enable_b1                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_CC1_IE_mask_w                        ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define TM_INT_CC1_IE_mask_h0                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_INT_CC1_IE_mask_b1                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_INT_CC1_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_CC1_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_CC1_IE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_CC1_IE_enable_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_CC1_IE_enable_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_CC1_IE_enable_b1                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_CC0_IE_mask_w                        ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_INT_CC0_IE_mask_h0                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_INT_CC0_IE_mask_b1                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_INT_CC0_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_CC0_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_CC0_IE_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_CC0_IE_enable_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_CC0_IE_enable_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_CC0_IE_enable_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_TIE2_mask_w                          ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define TM_INT_TIE2_mask_h0                         ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define TM_INT_TIE2_mask_b0                         ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_INT_TIE2_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_TIE2_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_TIE2_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_TIE2_enable_w                        ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_TIE2_enable_h0                       ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_TIE2_enable_b0                       ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_TIE_mask_w                           ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define TM_INT_TIE_mask_h0                          ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_INT_TIE_mask_b0                          ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_INT_TIE_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_TIE_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_TIE_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_TIE_enable_w                         ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_TIE_enable_h0                        ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_TIE_enable_b0                        ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_EXIE_mask_w                          ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define TM_INT_EXIE_mask_h0                         ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_INT_EXIE_mask_b0                         ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_INT_EXIE_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_EXIE_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_EXIE_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_EXIE_enable_w                        ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_EXIE_enable_h0                       ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_EXIE_enable_b0                       ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_BKIE_mask_w                          ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define TM_INT_BKIE_mask_h0                         ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_INT_BKIE_mask_b0                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_INT_BKIE_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_BKIE_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_BKIE_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_BKIE_enable_w                        ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_BKIE_enable_h0                       ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_BKIE_enable_b0                       ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_INT_IEA_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_INT_IEA_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_INT_IEA_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_INT_IEA_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_INT_IEA_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_INT_IEA_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_INT_IEA_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_INT_IEA_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_INT_IEA_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CLK  [register's definitions]
 *              Offset[0x08]  TM Timer clock source register
 ******************************************************************************
 */
///@{
#define TM_CLK_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CLK */
#define TM_CLK_RC_CKS_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define TM_CLK_RC_CKS_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_CLK_RC_CKS_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_CLK_RC_CKS_main_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):MAIN of 32bit */
#define TM_CLK_RC_CKS_main_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):MAIN of 16bit */
#define TM_CLK_RC_CKS_main_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):MAIN of 8bit */
#define TM_CLK_RC_CKS_cko_w                         ((uint32_t)0x00100000)  /*!< Bit Value =(1):CKO of 32bit */
#define TM_CLK_RC_CKS_cko_h1                        ((uint16_t)0x0010)      /*!< Bit Value =(1):CKO of 16bit */
#define TM_CLK_RC_CKS_cko_b2                        ((uint8_t )0x10)        /*!< Bit Value =(1):CKO of 8bit */

#define TM_CLK_DTG_DIV_mask_w                       ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define TM_CLK_DTG_DIV_mask_h1                      ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define TM_CLK_DTG_DIV_mask_b2                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define TM_CLK_DTG_DIV_div1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define TM_CLK_DTG_DIV_div1_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define TM_CLK_DTG_DIV_div1_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define TM_CLK_DTG_DIV_div2_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define TM_CLK_DTG_DIV_div2_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define TM_CLK_DTG_DIV_div2_b2                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define TM_CLK_DTG_DIV_div4_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define TM_CLK_DTG_DIV_div4_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define TM_CLK_DTG_DIV_div4_b2                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define TM_CLK_DTG_DIV_div8_w                       ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define TM_CLK_DTG_DIV_div8_h1                      ((uint16_t)0x0003)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define TM_CLK_DTG_DIV_div8_b2                      ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define TM_CLK_CKI_DIV_mask_w                       ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define TM_CLK_CKI_DIV_mask_h0                      ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define TM_CLK_CKI_DIV_mask_b1                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define TM_CLK_CKI_DIV_div1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define TM_CLK_CKI_DIV_div1_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define TM_CLK_CKI_DIV_div1_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define TM_CLK_CKI_DIV_div2_w                       ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define TM_CLK_CKI_DIV_div2_h0                      ((uint16_t)0x1000)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define TM_CLK_CKI_DIV_div2_b1                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define TM_CLK_CKI_DIV_div4_w                       ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define TM_CLK_CKI_DIV_div4_h0                      ((uint16_t)0x2000)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define TM_CLK_CKI_DIV_div4_b1                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define TM_CLK_CKI_DIV_div8_w                       ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define TM_CLK_CKI_DIV_div8_h0                      ((uint16_t)0x3000)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define TM_CLK_CKI_DIV_div8_b1                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define TM_CLK_CKI_SEL_mask_w                       ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define TM_CLK_CKI_SEL_mask_h0                      ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define TM_CLK_CKI_SEL_mask_b1                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define TM_CLK_CKI_SEL_proc_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):PROC of 32bit */
#define TM_CLK_CKI_SEL_proc_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):PROC of 16bit */
#define TM_CLK_CKI_SEL_proc_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):PROC of 8bit */
#define TM_CLK_CKI_SEL_ck_ls_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):CK_LS of 32bit */
#define TM_CLK_CKI_SEL_ck_ls_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CK_LS of 16bit */
#define TM_CLK_CKI_SEL_ck_ls_b1                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):CK_LS of 8bit */

#define TM_CLK_CKS2_SEL_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define TM_CLK_CKS2_SEL_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_CLK_CKS2_SEL_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_CLK_CKS2_SEL_ck_int_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):CK_INT of 32bit */
#define TM_CLK_CKS2_SEL_ck_int_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):CK_INT of 16bit */
#define TM_CLK_CKS2_SEL_ck_int_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):CK_INT of 8bit */
#define TM_CLK_CKS2_SEL_ck_ext_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):CK_EXT of 32bit */
#define TM_CLK_CKS2_SEL_ck_ext_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):CK_EXT of 16bit */
#define TM_CLK_CKS2_SEL_ck_ext_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):CK_EXT of 8bit */

#define TM_CLK_CKS_SEL_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define TM_CLK_CKS_SEL_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_CLK_CKS_SEL_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_CLK_CKS_SEL_ck_int_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):CK_INT of 32bit */
#define TM_CLK_CKS_SEL_ck_int_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):CK_INT of 16bit */
#define TM_CLK_CKS_SEL_ck_int_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):CK_INT of 8bit */
#define TM_CLK_CKS_SEL_ck_ext_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):CK_EXT of 32bit */
#define TM_CLK_CKS_SEL_ck_ext_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):CK_EXT of 16bit */
#define TM_CLK_CKS_SEL_ck_ext_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):CK_EXT of 8bit */

#define TM_CLK_CKE_SEL_mask_w                       ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define TM_CLK_CKE_SEL_mask_h0                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define TM_CLK_CKE_SEL_mask_b0                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define TM_CLK_CKE_SEL_etr_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):ETR of 32bit */
#define TM_CLK_CKE_SEL_etr_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):ETR of 16bit */
#define TM_CLK_CKE_SEL_etr_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):ETR of 8bit */
#define TM_CLK_CKE_SEL_itr_w                        ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):ITR of 32bit */
#define TM_CLK_CKE_SEL_itr_h0                       ((uint16_t)0x0010)      /*!< Bit Value =(0x1):ITR of 16bit */
#define TM_CLK_CKE_SEL_itr_b0                       ((uint8_t )0x10)        /*!< Bit Value =(0x1):ITR of 8bit */
#define TM_CLK_CKE_SEL_in0_w                        ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):IN0 of 32bit */
#define TM_CLK_CKE_SEL_in0_h0                       ((uint16_t)0x0020)      /*!< Bit Value =(0x2):IN0 of 16bit */
#define TM_CLK_CKE_SEL_in0_b0                       ((uint8_t )0x20)        /*!< Bit Value =(0x2):IN0 of 8bit */
#define TM_CLK_CKE_SEL_in1_w                        ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):IN1 of 32bit */
#define TM_CLK_CKE_SEL_in1_h0                       ((uint16_t)0x0030)      /*!< Bit Value =(0x3):IN1 of 16bit */
#define TM_CLK_CKE_SEL_in1_b0                       ((uint8_t )0x30)        /*!< Bit Value =(0x3):IN1 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_TRG  [register's definitions]
 *              Offset[0x0C]  TM Timer trigger control register
 ******************************************************************************
 */
///@{
#define TM_TRG_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_TRG */
#define TM_TRG_GT2_SW_mask_w                        ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define TM_TRG_GT2_SW_mask_h1                       ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define TM_TRG_GT2_SW_mask_b3                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_TRG_GT2_SW_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_TRG_GT2_SW_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_TRG_GT2_SW_disable_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_TRG_GT2_SW_enable_w                      ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_TRG_GT2_SW_enable_h1                     ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_TRG_GT2_SW_enable_b3                     ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_TRG_GT_SW_mask_w                         ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define TM_TRG_GT_SW_mask_h1                        ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_TRG_GT_SW_mask_b3                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_TRG_GT_SW_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_TRG_GT_SW_disable_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_TRG_GT_SW_disable_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_TRG_GT_SW_enable_w                       ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_TRG_GT_SW_enable_h1                      ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_TRG_GT_SW_enable_b3                      ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_TRG_RST2_SW_mask_w                       ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define TM_TRG_RST2_SW_mask_h1                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define TM_TRG_RST2_SW_mask_b3                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_TRG_RST2_SW_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_TRG_RST2_SW_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_TRG_RST2_SW_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_TRG_RST2_SW_enable_w                     ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_TRG_RST2_SW_enable_h1                    ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_TRG_RST2_SW_enable_b3                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_TRG_RST_SW_mask_w                        ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define TM_TRG_RST_SW_mask_h1                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_TRG_RST_SW_mask_b3                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_TRG_RST_SW_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_TRG_RST_SW_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_TRG_RST_SW_disable_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_TRG_RST_SW_enable_w                      ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_TRG_RST_SW_enable_h1                     ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_TRG_RST_SW_enable_b3                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_TRG_TRGO_INV_mask_w                      ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define TM_TRG_TRGO_INV_mask_h1                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_TRG_TRGO_INV_mask_b3                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_TRG_TRGO_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_TRG_TRGO_INV_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_TRG_TRGO_INV_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_TRG_TRGO_INV_enable_w                    ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_TRG_TRGO_INV_enable_h1                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_TRG_TRGO_INV_enable_b3                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_TRG_TRGO_SW_mask_w                       ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define TM_TRG_TRGO_SW_mask_h1                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_TRG_TRGO_SW_mask_b3                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_TRG_TRGO_SW_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_TRG_TRGO_SW_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_TRG_TRGO_SW_0_b3                         ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_TRG_TRGO_SW_1_w                          ((uint32_t)0x01000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_TRG_TRGO_SW_1_h1                         ((uint16_t)0x0100)      /*!< Bit Value =(1):1 of 16bit */
#define TM_TRG_TRGO_SW_1_b3                         ((uint8_t )0x01)        /*!< Bit Value =(1):1 of 8bit */

#define TM_TRG_UEV_SEL_mask_w                       ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define TM_TRG_UEV_SEL_mask_h1                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define TM_TRG_UEV_SEL_mask_b2                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define TM_TRG_UEV_SEL_all_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):All of 32bit */
#define TM_TRG_UEV_SEL_all_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):All of 16bit */
#define TM_TRG_UEV_SEL_all_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):All of 8bit */
#define TM_TRG_UEV_SEL_tof_w                        ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):TOF of 32bit */
#define TM_TRG_UEV_SEL_tof_h1                       ((uint16_t)0x0040)      /*!< Bit Value =(0x1):TOF of 16bit */
#define TM_TRG_UEV_SEL_tof_b2                       ((uint8_t )0x40)        /*!< Bit Value =(0x1):TOF of 8bit */
#define TM_TRG_UEV_SEL_udf_w                        ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):UDF of 32bit */
#define TM_TRG_UEV_SEL_udf_h1                       ((uint16_t)0x0080)      /*!< Bit Value =(0x2):UDF of 16bit */
#define TM_TRG_UEV_SEL_udf_b2                       ((uint8_t )0x80)        /*!< Bit Value =(0x2):UDF of 8bit */

#define TM_TRG_IDX_MDS_mask_w                       ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define TM_TRG_IDX_MDS_mask_h1                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define TM_TRG_IDX_MDS_mask_b2                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define TM_TRG_IDX_MDS_1t2_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1T2 of 32bit */
#define TM_TRG_IDX_MDS_1t2_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1T2 of 16bit */
#define TM_TRG_IDX_MDS_1t2_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):1T2 of 8bit */
#define TM_TRG_IDX_MDS_2t3_w                        ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):2T3 of 32bit */
#define TM_TRG_IDX_MDS_2t3_h1                       ((uint16_t)0x0010)      /*!< Bit Value =(0x1):2T3 of 16bit */
#define TM_TRG_IDX_MDS_2t3_b2                       ((uint8_t )0x10)        /*!< Bit Value =(0x1):2T3 of 8bit */
#define TM_TRG_IDX_MDS_3t4_w                        ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):3T4 of 32bit */
#define TM_TRG_IDX_MDS_3t4_h1                       ((uint16_t)0x0020)      /*!< Bit Value =(0x2):3T4 of 16bit */
#define TM_TRG_IDX_MDS_3t4_b2                       ((uint8_t )0x20)        /*!< Bit Value =(0x2):3T4 of 8bit */
#define TM_TRG_IDX_MDS_4t1_w                        ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):4T1 of 32bit */
#define TM_TRG_IDX_MDS_4t1_h1                       ((uint16_t)0x0030)      /*!< Bit Value =(0x3):4T1 of 16bit */
#define TM_TRG_IDX_MDS_4t1_b2                       ((uint8_t )0x30)        /*!< Bit Value =(0x3):4T1 of 8bit */

#define TM_TRG_IDX_EN_mask_w                        ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define TM_TRG_IDX_EN_mask_h1                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_TRG_IDX_EN_mask_b2                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_TRG_IDX_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_TRG_IDX_EN_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_TRG_IDX_EN_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_TRG_IDX_EN_enable_w                      ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_TRG_IDX_EN_enable_h1                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_TRG_IDX_EN_enable_b2                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_TRG_QEI_MDS_mask_w                       ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define TM_TRG_QEI_MDS_mask_h1                      ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define TM_TRG_QEI_MDS_mask_b2                      ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define TM_TRG_QEI_MDS_no_operation_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No operation of 32bit */
#define TM_TRG_QEI_MDS_no_operation_h1              ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No operation of 16bit */
#define TM_TRG_QEI_MDS_no_operation_b2              ((uint8_t )0x00)        /*!< Bit Value =(0x0):No operation of 8bit */
#define TM_TRG_QEI_MDS_in0pos_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):IN0POS of 32bit */
#define TM_TRG_QEI_MDS_in0pos_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(0x1):IN0POS of 16bit */
#define TM_TRG_QEI_MDS_in0pos_b2                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):IN0POS of 8bit */
#define TM_TRG_QEI_MDS_in0neg_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):IN0NEG of 32bit */
#define TM_TRG_QEI_MDS_in0neg_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(0x2):IN0NEG of 16bit */
#define TM_TRG_QEI_MDS_in0neg_b2                    ((uint8_t )0x02)        /*!< Bit Value =(0x2):IN0NEG of 8bit */
#define TM_TRG_QEI_MDS_in0trg_w                     ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):IN0TRG of 32bit */
#define TM_TRG_QEI_MDS_in0trg_h1                    ((uint16_t)0x0003)      /*!< Bit Value =(0x3):IN0TRG of 16bit */
#define TM_TRG_QEI_MDS_in0trg_b2                    ((uint8_t )0x03)        /*!< Bit Value =(0x3):IN0TRG of 8bit */
#define TM_TRG_QEI_MDS_in1trg_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):IN1TRG of 32bit */
#define TM_TRG_QEI_MDS_in1trg_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(0x4):IN1TRG of 16bit */
#define TM_TRG_QEI_MDS_in1trg_b2                    ((uint8_t )0x04)        /*!< Bit Value =(0x4):IN1TRG of 8bit */
#define TM_TRG_QEI_MDS_both_w                       ((uint32_t)0x00050000)  /*!< Bit Value =(0x5):BOTH of 32bit */
#define TM_TRG_QEI_MDS_both_h1                      ((uint16_t)0x0005)      /*!< Bit Value =(0x5):BOTH of 16bit */
#define TM_TRG_QEI_MDS_both_b2                      ((uint8_t )0x05)        /*!< Bit Value =(0x5):BOTH of 8bit */

#define TM_TRG_TRGO_MDS_mask_w                      ((uint32_t)0x0000F000)  /*!< Bit Mask of 32bit */
#define TM_TRG_TRGO_MDS_mask_h0                     ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define TM_TRG_TRGO_MDS_mask_b1                     ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define TM_TRG_TRGO_MDS_rst_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):RST of 32bit */
#define TM_TRG_TRGO_MDS_rst_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):RST of 16bit */
#define TM_TRG_TRGO_MDS_rst_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):RST of 8bit */
#define TM_TRG_TRGO_MDS_en_w                        ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):EN of 32bit */
#define TM_TRG_TRGO_MDS_en_h0                       ((uint16_t)0x1000)      /*!< Bit Value =(0x1):EN of 16bit */
#define TM_TRG_TRGO_MDS_en_b1                       ((uint8_t )0x10)        /*!< Bit Value =(0x1):EN of 8bit */
#define TM_TRG_TRGO_MDS_uev_w                       ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):UEV of 32bit */
#define TM_TRG_TRGO_MDS_uev_h0                      ((uint16_t)0x2000)      /*!< Bit Value =(0x2):UEV of 16bit */
#define TM_TRG_TRGO_MDS_uev_b1                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):UEV of 8bit */
#define TM_TRG_TRGO_MDS_tof_w                       ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):TOF of 32bit */
#define TM_TRG_TRGO_MDS_tof_h0                      ((uint16_t)0x3000)      /*!< Bit Value =(0x3):TOF of 16bit */
#define TM_TRG_TRGO_MDS_tof_b1                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):TOF of 8bit */
#define TM_TRG_TRGO_MDS_tuf_w                       ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):TUF of 32bit */
#define TM_TRG_TRGO_MDS_tuf_h0                      ((uint16_t)0x4000)      /*!< Bit Value =(0x4):TUF of 16bit */
#define TM_TRG_TRGO_MDS_tuf_b1                      ((uint8_t )0x40)        /*!< Bit Value =(0x4):TUF of 8bit */
#define TM_TRG_TRGO_MDS_en2_w                       ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):EN2 of 32bit */
#define TM_TRG_TRGO_MDS_en2_h0                      ((uint16_t)0x5000)      /*!< Bit Value =(0x5):EN2 of 16bit */
#define TM_TRG_TRGO_MDS_en2_b1                      ((uint8_t )0x50)        /*!< Bit Value =(0x5):EN2 of 8bit */
#define TM_TRG_TRGO_MDS_tof2_w                      ((uint32_t)0x00006000)  /*!< Bit Value =(0x6):TOF2 of 32bit */
#define TM_TRG_TRGO_MDS_tof2_h0                     ((uint16_t)0x6000)      /*!< Bit Value =(0x6):TOF2 of 16bit */
#define TM_TRG_TRGO_MDS_tof2_b1                     ((uint8_t )0x60)        /*!< Bit Value =(0x6):TOF2 of 8bit */
#define TM_TRG_TRGO_MDS_dir_w                       ((uint32_t)0x00007000)  /*!< Bit Value =(0x7):DIR of 32bit */
#define TM_TRG_TRGO_MDS_dir_h0                      ((uint16_t)0x7000)      /*!< Bit Value =(0x7):DIR of 16bit */
#define TM_TRG_TRGO_MDS_dir_b1                      ((uint8_t )0x70)        /*!< Bit Value =(0x7):DIR of 8bit */
#define TM_TRG_TRGO_MDS_uev2_w                      ((uint32_t)0x00008000)  /*!< Bit Value =(0x8):UEV2 of 32bit */
#define TM_TRG_TRGO_MDS_uev2_h0                     ((uint16_t)0x8000)      /*!< Bit Value =(0x8):UEV2 of 16bit */
#define TM_TRG_TRGO_MDS_uev2_b1                     ((uint8_t )0x80)        /*!< Bit Value =(0x8):UEV2 of 8bit */
#define TM_TRG_TRGO_MDS_sw_w                        ((uint32_t)0x00009000)  /*!< Bit Value =(0x9):SW of 32bit */
#define TM_TRG_TRGO_MDS_sw_h0                       ((uint16_t)0x9000)      /*!< Bit Value =(0x9):SW of 16bit */
#define TM_TRG_TRGO_MDS_sw_b1                       ((uint8_t )0x90)        /*!< Bit Value =(0x9):SW of 8bit */
#define TM_TRG_TRGO_MDS_os0_w                       ((uint32_t)0x0000A000)  /*!< Bit Value =(0xA):OS0 of 32bit */
#define TM_TRG_TRGO_MDS_os0_h0                      ((uint16_t)0xA000)      /*!< Bit Value =(0xA):OS0 of 16bit */
#define TM_TRG_TRGO_MDS_os0_b1                      ((uint8_t )0xA0)        /*!< Bit Value =(0xA):OS0 of 8bit */
#define TM_TRG_TRGO_MDS_os1_w                       ((uint32_t)0x0000B000)  /*!< Bit Value =(0xB):OS1 of 32bit */
#define TM_TRG_TRGO_MDS_os1_h0                      ((uint16_t)0xB000)      /*!< Bit Value =(0xB):OS1 of 16bit */
#define TM_TRG_TRGO_MDS_os1_b1                      ((uint8_t )0xB0)        /*!< Bit Value =(0xB):OS1 of 8bit */
#define TM_TRG_TRGO_MDS_os2_w                       ((uint32_t)0x0000C000)  /*!< Bit Value =(0xC):OS2 of 32bit */
#define TM_TRG_TRGO_MDS_os2_h0                      ((uint16_t)0xC000)      /*!< Bit Value =(0xC):OS2 of 16bit */
#define TM_TRG_TRGO_MDS_os2_b1                      ((uint8_t )0xC0)        /*!< Bit Value =(0xC):OS2 of 8bit */
#define TM_TRG_TRGO_MDS_os3_w                       ((uint32_t)0x0000D000)  /*!< Bit Value =(0xD):OS3 of 32bit */
#define TM_TRG_TRGO_MDS_os3_h0                      ((uint16_t)0xD000)      /*!< Bit Value =(0xD):OS3 of 16bit */
#define TM_TRG_TRGO_MDS_os3_b1                      ((uint8_t )0xD0)        /*!< Bit Value =(0xD):OS3 of 8bit */
#define TM_TRG_TRGO_MDS_trgi_w                      ((uint32_t)0x0000E000)  /*!< Bit Value =(0xE):TRGI of 32bit */
#define TM_TRG_TRGO_MDS_trgi_h0                     ((uint16_t)0xE000)      /*!< Bit Value =(0xE):TRGI of 16bit */
#define TM_TRG_TRGO_MDS_trgi_b1                     ((uint8_t )0xE0)        /*!< Bit Value =(0xE):TRGI of 8bit */
#define TM_TRG_TRGO_MDS_poe_w                       ((uint32_t)0x0000F000)  /*!< Bit Value =(0xF):POE of 32bit */
#define TM_TRG_TRGO_MDS_poe_h0                      ((uint16_t)0xF000)      /*!< Bit Value =(0xF):POE of 16bit */
#define TM_TRG_TRGO_MDS_poe_b1                      ((uint8_t )0xF0)        /*!< Bit Value =(0xF):POE of 8bit */

#define TM_TRG_ITR_MUX_mask_w                       ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define TM_TRG_ITR_MUX_mask_h0                      ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define TM_TRG_ITR_MUX_mask_b1                      ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define TM_TRG_ITR_MUX_itr0_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):ITR0 of 32bit */
#define TM_TRG_ITR_MUX_itr0_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):ITR0 of 16bit */
#define TM_TRG_ITR_MUX_itr0_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):ITR0 of 8bit */
#define TM_TRG_ITR_MUX_itr1_w                       ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):ITR1 of 32bit */
#define TM_TRG_ITR_MUX_itr1_h0                      ((uint16_t)0x0100)      /*!< Bit Value =(0x1):ITR1 of 16bit */
#define TM_TRG_ITR_MUX_itr1_b1                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):ITR1 of 8bit */
#define TM_TRG_ITR_MUX_itr2_w                       ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):ITR2 of 32bit */
#define TM_TRG_ITR_MUX_itr2_h0                      ((uint16_t)0x0200)      /*!< Bit Value =(0x2):ITR2 of 16bit */
#define TM_TRG_ITR_MUX_itr2_b1                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):ITR2 of 8bit */
#define TM_TRG_ITR_MUX_itr3_w                       ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):ITR3 of 32bit */
#define TM_TRG_ITR_MUX_itr3_h0                      ((uint16_t)0x0300)      /*!< Bit Value =(0x3):ITR3 of 16bit */
#define TM_TRG_ITR_MUX_itr3_b1                      ((uint8_t )0x03)        /*!< Bit Value =(0x3):ITR3 of 8bit */
#define TM_TRG_ITR_MUX_itr4_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):ITR4 of 32bit */
#define TM_TRG_ITR_MUX_itr4_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(0x4):ITR4 of 16bit */
#define TM_TRG_ITR_MUX_itr4_b1                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):ITR4 of 8bit */
#define TM_TRG_ITR_MUX_itr5_w                       ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):ITR5 of 32bit */
#define TM_TRG_ITR_MUX_itr5_h0                      ((uint16_t)0x0500)      /*!< Bit Value =(0x5):ITR5 of 16bit */
#define TM_TRG_ITR_MUX_itr5_b1                      ((uint8_t )0x05)        /*!< Bit Value =(0x5):ITR5 of 8bit */
#define TM_TRG_ITR_MUX_itr6_w                       ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):ITR6 of 32bit */
#define TM_TRG_ITR_MUX_itr6_h0                      ((uint16_t)0x0600)      /*!< Bit Value =(0x6):ITR6 of 16bit */
#define TM_TRG_ITR_MUX_itr6_b1                      ((uint8_t )0x06)        /*!< Bit Value =(0x6):ITR6 of 8bit */
#define TM_TRG_ITR_MUX_itr7_w                       ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):ITR7 of 32bit */
#define TM_TRG_ITR_MUX_itr7_h0                      ((uint16_t)0x0700)      /*!< Bit Value =(0x7):ITR7 of 16bit */
#define TM_TRG_ITR_MUX_itr7_b1                      ((uint8_t )0x07)        /*!< Bit Value =(0x7):ITR7 of 8bit */

#define TM_TRG_TRG_MUX_mask_w                       ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define TM_TRG_TRG_MUX_mask_h0                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define TM_TRG_TRG_MUX_mask_b0                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define TM_TRG_TRG_MUX_etr_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):ETR of 32bit */
#define TM_TRG_TRG_MUX_etr_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):ETR of 16bit */
#define TM_TRG_TRG_MUX_etr_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):ETR of 8bit */
#define TM_TRG_TRG_MUX_itr_w                        ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):ITR of 32bit */
#define TM_TRG_TRG_MUX_itr_h0                       ((uint16_t)0x0040)      /*!< Bit Value =(0x1):ITR of 16bit */
#define TM_TRG_TRG_MUX_itr_b0                       ((uint8_t )0x40)        /*!< Bit Value =(0x1):ITR of 8bit */
#define TM_TRG_TRG_MUX_in0_w                        ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):IN0 of 32bit */
#define TM_TRG_TRG_MUX_in0_h0                       ((uint16_t)0x0080)      /*!< Bit Value =(0x2):IN0 of 16bit */
#define TM_TRG_TRG_MUX_in0_b0                       ((uint8_t )0x80)        /*!< Bit Value =(0x2):IN0 of 8bit */
#define TM_TRG_TRG_MUX_in1_w                        ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):IN1 of 32bit */
#define TM_TRG_TRG_MUX_in1_h0                       ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):IN1 of 16bit */
#define TM_TRG_TRG_MUX_in1_b0                       ((uint8_t )0xC0)        /*!< Bit Value =(0x3):IN1 of 8bit */

#define TM_TRG_TRGI2_MDS_mask_w                     ((uint32_t)0x00000038)  /*!< Bit Mask of 32bit */
#define TM_TRG_TRGI2_MDS_mask_h0                    ((uint16_t)0x0038)      /*!< Bit Mask of 16bit */
#define TM_TRG_TRGI2_MDS_mask_b0                    ((uint8_t )0x38)        /*!< Bit Mask of 8bit */
#define TM_TRG_TRGI2_MDS_no_operation_w             ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No operation of 32bit */
#define TM_TRG_TRGI2_MDS_no_operation_h0            ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No operation of 16bit */
#define TM_TRG_TRGI2_MDS_no_operation_b0            ((uint8_t )0x00)        /*!< Bit Value =(0x0):No operation of 8bit */
#define TM_TRG_TRGI2_MDS_trigger_r_w                ((uint32_t)0x00000008)  /*!< Bit Value =(0x1):Trigger-R of 32bit */
#define TM_TRG_TRGI2_MDS_trigger_r_h0               ((uint16_t)0x0008)      /*!< Bit Value =(0x1):Trigger-R of 16bit */
#define TM_TRG_TRGI2_MDS_trigger_r_b0               ((uint8_t )0x08)        /*!< Bit Value =(0x1):Trigger-R of 8bit */
#define TM_TRG_TRGI2_MDS_reset_r_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(0x2):Reset-R of 32bit */
#define TM_TRG_TRGI2_MDS_reset_r_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(0x2):Reset-R of 16bit */
#define TM_TRG_TRGI2_MDS_reset_r_b0                 ((uint8_t )0x10)        /*!< Bit Value =(0x2):Reset-R of 8bit */
#define TM_TRG_TRGI2_MDS_gate_h_w                   ((uint32_t)0x00000018)  /*!< Bit Value =(0x3):Gate-H of 32bit */
#define TM_TRG_TRGI2_MDS_gate_h_h0                  ((uint16_t)0x0018)      /*!< Bit Value =(0x3):Gate-H of 16bit */
#define TM_TRG_TRGI2_MDS_gate_h_b0                  ((uint8_t )0x18)        /*!< Bit Value =(0x3):Gate-H of 8bit */
#define TM_TRG_TRGI2_MDS_reset_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(0x4):Reset of 32bit */
#define TM_TRG_TRGI2_MDS_reset_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(0x4):Reset of 16bit */
#define TM_TRG_TRGI2_MDS_reset_b0                   ((uint8_t )0x20)        /*!< Bit Value =(0x4):Reset of 8bit */
#define TM_TRG_TRGI2_MDS_trigger_f_w                ((uint32_t)0x00000028)  /*!< Bit Value =(0x5):Trigger-F of 32bit */
#define TM_TRG_TRGI2_MDS_trigger_f_h0               ((uint16_t)0x0028)      /*!< Bit Value =(0x5):Trigger-F of 16bit */
#define TM_TRG_TRGI2_MDS_trigger_f_b0               ((uint8_t )0x28)        /*!< Bit Value =(0x5):Trigger-F of 8bit */
#define TM_TRG_TRGI2_MDS_reset_f_w                  ((uint32_t)0x00000030)  /*!< Bit Value =(0x6):Reset-F of 32bit */
#define TM_TRG_TRGI2_MDS_reset_f_h0                 ((uint16_t)0x0030)      /*!< Bit Value =(0x6):Reset-F of 16bit */
#define TM_TRG_TRGI2_MDS_reset_f_b0                 ((uint8_t )0x30)        /*!< Bit Value =(0x6):Reset-F of 8bit */
#define TM_TRG_TRGI2_MDS_gate_l_w                   ((uint32_t)0x00000038)  /*!< Bit Value =(0x7):Gate-L of 32bit */
#define TM_TRG_TRGI2_MDS_gate_l_h0                  ((uint16_t)0x0038)      /*!< Bit Value =(0x7):Gate-L of 16bit */
#define TM_TRG_TRGI2_MDS_gate_l_b0                  ((uint8_t )0x38)        /*!< Bit Value =(0x7):Gate-L of 8bit */

#define TM_TRG_TRGI_MDS_mask_w                      ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define TM_TRG_TRGI_MDS_mask_h0                     ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define TM_TRG_TRGI_MDS_mask_b0                     ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define TM_TRG_TRGI_MDS_no_operation_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No operation of 32bit */
#define TM_TRG_TRGI_MDS_no_operation_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No operation of 16bit */
#define TM_TRG_TRGI_MDS_no_operation_b0             ((uint8_t )0x00)        /*!< Bit Value =(0x0):No operation of 8bit */
#define TM_TRG_TRGI_MDS_trigger_r_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Trigger-R of 32bit */
#define TM_TRG_TRGI_MDS_trigger_r_h0                ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Trigger-R of 16bit */
#define TM_TRG_TRGI_MDS_trigger_r_b0                ((uint8_t )0x01)        /*!< Bit Value =(0x1):Trigger-R of 8bit */
#define TM_TRG_TRGI_MDS_reset_r_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Reset-R of 32bit */
#define TM_TRG_TRGI_MDS_reset_r_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Reset-R of 16bit */
#define TM_TRG_TRGI_MDS_reset_r_b0                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Reset-R of 8bit */
#define TM_TRG_TRGI_MDS_gate_h_w                    ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):Gate-H of 32bit */
#define TM_TRG_TRGI_MDS_gate_h_h0                   ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Gate-H of 16bit */
#define TM_TRG_TRGI_MDS_gate_h_b0                   ((uint8_t )0x03)        /*!< Bit Value =(0x3):Gate-H of 8bit */
#define TM_TRG_TRGI_MDS_reset_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):Reset of 32bit */
#define TM_TRG_TRGI_MDS_reset_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(0x4):Reset of 16bit */
#define TM_TRG_TRGI_MDS_reset_b0                    ((uint8_t )0x04)        /*!< Bit Value =(0x4):Reset of 8bit */
#define TM_TRG_TRGI_MDS_trigger_f_w                 ((uint32_t)0x00000005)  /*!< Bit Value =(0x5):Trigger-F of 32bit */
#define TM_TRG_TRGI_MDS_trigger_f_h0                ((uint16_t)0x0005)      /*!< Bit Value =(0x5):Trigger-F of 16bit */
#define TM_TRG_TRGI_MDS_trigger_f_b0                ((uint8_t )0x05)        /*!< Bit Value =(0x5):Trigger-F of 8bit */
#define TM_TRG_TRGI_MDS_reset_f_w                   ((uint32_t)0x00000006)  /*!< Bit Value =(0x6):Reset-F of 32bit */
#define TM_TRG_TRGI_MDS_reset_f_h0                  ((uint16_t)0x0006)      /*!< Bit Value =(0x6):Reset-F of 16bit */
#define TM_TRG_TRGI_MDS_reset_f_b0                  ((uint8_t )0x06)        /*!< Bit Value =(0x6):Reset-F of 8bit */
#define TM_TRG_TRGI_MDS_gate_l_w                    ((uint32_t)0x00000007)  /*!< Bit Value =(0x7):Gate-L of 32bit */
#define TM_TRG_TRGI_MDS_gate_l_h0                   ((uint16_t)0x0007)      /*!< Bit Value =(0x7):Gate-L of 16bit */
#define TM_TRG_TRGI_MDS_gate_l_b0                   ((uint8_t )0x07)        /*!< Bit Value =(0x7):Gate-L of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CR0  [register's definitions]
 *              Offset[0x10]  TM Timer control register 0
 ******************************************************************************
 */
///@{
#define TM_CR0_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CR0 */
#define TM_CR0_RC_STP_mask_w                        ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define TM_CR0_RC_STP_mask_h1                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_CR0_RC_STP_mask_b2                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_CR0_RC_STP_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_RC_STP_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_RC_STP_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_RC_STP_enable_w                      ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_RC_STP_enable_h1                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_RC_STP_enable_b2                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_RC_EN_mask_w                         ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define TM_CR0_RC_EN_mask_h1                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_CR0_RC_EN_mask_b2                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CR0_RC_EN_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_RC_EN_disable_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_RC_EN_disable_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_RC_EN_enable_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_RC_EN_enable_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_RC_EN_enable_b2                      ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_UEX_EN_mask_w                        ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define TM_CR0_UEX_EN_mask_h0                       ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define TM_CR0_UEX_EN_mask_b1                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_CR0_UEX_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_UEX_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_UEX_EN_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_UEX_EN_enable_w                      ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_UEX_EN_enable_h0                     ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_UEX_EN_enable_b1                     ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_USW_EN_mask_w                        ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define TM_CR0_USW_EN_mask_h0                       ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_CR0_USW_EN_mask_b1                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_CR0_USW_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_USW_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_USW_EN_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_USW_EN_enable_w                      ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_USW_EN_enable_h0                     ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_USW_EN_enable_b1                     ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_DIR_INV_mask_w                       ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define TM_CR0_DIR_INV_mask_h0                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define TM_CR0_DIR_INV_mask_b1                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_CR0_DIR_INV_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_CR0_DIR_INV_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_CR0_DIR_INV_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_CR0_DIR_INV_inverted_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(1):Inverted of 32bit */
#define TM_CR0_DIR_INV_inverted_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Inverted of 16bit */
#define TM_CR0_DIR_INV_inverted_b1                  ((uint8_t )0x20)        /*!< Bit Value =(1):Inverted of 8bit */

#define TM_CR0_UEV_DIS_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define TM_CR0_UEV_DIS_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_CR0_UEV_DIS_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_CR0_UEV_DIS_enable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define TM_CR0_UEV_DIS_enable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define TM_CR0_UEV_DIS_enable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define TM_CR0_UEV_DIS_disable_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Disable of 32bit */
#define TM_CR0_UEV_DIS_disable_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Disable of 16bit */
#define TM_CR0_UEV_DIS_disable_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Disable of 8bit */

#define TM_CR0_EX_INV_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define TM_CR0_EX_INV_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_CR0_EX_INV_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_CR0_EX_INV_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define TM_CR0_EX_INV_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define TM_CR0_EX_INV_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define TM_CR0_EX_INV_inverted_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Inverted of 32bit */
#define TM_CR0_EX_INV_inverted_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Inverted of 16bit */
#define TM_CR0_EX_INV_inverted_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Inverted of 8bit */

#define TM_CR0_EX_EN_mask_w                         ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define TM_CR0_EX_EN_mask_h0                        ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_CR0_EX_EN_mask_b1                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_CR0_EX_EN_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_EX_EN_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_EX_EN_disable_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_EX_EN_enable_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_EX_EN_enable_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_EX_EN_enable_b1                      ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_ACLEAR_EN_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define TM_CR0_ACLEAR_EN_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_CR0_ACLEAR_EN_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_CR0_ACLEAR_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_ACLEAR_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_ACLEAR_EN_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_ACLEAR_EN_enable_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_ACLEAR_EN_enable_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_ACLEAR_EN_enable_b1                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_ASTOP_EN_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_CR0_ASTOP_EN_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_CR0_ASTOP_EN_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CR0_ASTOP_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_ASTOP_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_ASTOP_EN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_ASTOP_EN_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_ASTOP_EN_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_ASTOP_EN_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_DIR2_mask_w                          ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define TM_CR0_DIR2_mask_h0                         ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_CR0_DIR2_mask_b0                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_CR0_DIR2_up_w                            ((uint32_t)0x00000000)  /*!< Bit Value =(0):Up of 32bit */
#define TM_CR0_DIR2_up_h0                           ((uint16_t)0x0000)      /*!< Bit Value =(0):Up of 16bit */
#define TM_CR0_DIR2_up_b0                           ((uint8_t )0x00)        /*!< Bit Value =(0):Up of 8bit */
#define TM_CR0_DIR2_down_w                          ((uint32_t)0x00000080)  /*!< Bit Value =(1):Down of 32bit */
#define TM_CR0_DIR2_down_h0                         ((uint16_t)0x0080)      /*!< Bit Value =(1):Down of 16bit */
#define TM_CR0_DIR2_down_b0                         ((uint8_t )0x80)        /*!< Bit Value =(1):Down of 8bit */

#define TM_CR0_DIR_mask_w                           ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define TM_CR0_DIR_mask_h0                          ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_CR0_DIR_mask_b0                          ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_CR0_DIR_up_w                             ((uint32_t)0x00000000)  /*!< Bit Value =(0):Up of 32bit */
#define TM_CR0_DIR_up_h0                            ((uint16_t)0x0000)      /*!< Bit Value =(0):Up of 16bit */
#define TM_CR0_DIR_up_b0                            ((uint8_t )0x00)        /*!< Bit Value =(0):Up of 8bit */
#define TM_CR0_DIR_down_w                           ((uint32_t)0x00000040)  /*!< Bit Value =(1):Down of 32bit */
#define TM_CR0_DIR_down_h0                          ((uint16_t)0x0040)      /*!< Bit Value =(1):Down of 16bit */
#define TM_CR0_DIR_down_b0                          ((uint8_t )0x40)        /*!< Bit Value =(1):Down of 8bit */

#define TM_CR0_MDS_mask_w                           ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define TM_CR0_MDS_mask_h0                          ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define TM_CR0_MDS_mask_b0                          ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define TM_CR0_MDS_cascade_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Cascade of 32bit */
#define TM_CR0_MDS_cascade_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Cascade of 16bit */
#define TM_CR0_MDS_cascade_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):Cascade of 8bit */
#define TM_CR0_MDS_separate_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Separate of 32bit */
#define TM_CR0_MDS_separate_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Separate of 16bit */
#define TM_CR0_MDS_separate_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):Separate of 8bit */
#define TM_CR0_MDS_full_counter_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Full-Counter of 32bit */
#define TM_CR0_MDS_full_counter_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Full-Counter of 16bit */
#define TM_CR0_MDS_full_counter_b0                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):Full-Counter of 8bit */

#define TM_CR0_EN2_mask_w                           ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define TM_CR0_EN2_mask_h0                          ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_CR0_EN2_mask_b0                          ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_CR0_EN2_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_EN2_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_EN2_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_EN2_enable_w                         ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_EN2_enable_h0                        ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_EN2_enable_b0                        ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR0_EN_mask_w                            ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_CR0_EN_mask_h0                           ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_CR0_EN_mask_b0                           ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CR0_EN_disable_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CR0_EN_disable_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CR0_EN_disable_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CR0_EN_enable_w                          ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR0_EN_enable_h0                         ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR0_EN_enable_b0                         ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CR1  [register's definitions]
 *              Offset[0x14]  TM Timer control register 1
 ******************************************************************************
 */
///@{
#define TM_CR1_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CR1 */
#define TM_CR1_CC3B_SEN_mask_w                      ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC3B_SEN_mask_h0                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC3B_SEN_mask_b1                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC3B_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC3B_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC3B_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC3B_SEN_enable_w                    ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC3B_SEN_enable_h0                   ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC3B_SEN_enable_b1                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_CC2B_SEN_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC2B_SEN_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC2B_SEN_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC2B_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC2B_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC2B_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC2B_SEN_enable_w                    ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC2B_SEN_enable_h0                   ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC2B_SEN_enable_b1                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_CC1B_SEN_mask_w                      ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC1B_SEN_mask_h0                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC1B_SEN_mask_b1                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC1B_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC1B_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC1B_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC1B_SEN_enable_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC1B_SEN_enable_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC1B_SEN_enable_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_CC0B_SEN_mask_w                      ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC0B_SEN_mask_h0                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC0B_SEN_mask_b1                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC0B_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC0B_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC0B_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC0B_SEN_enable_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC0B_SEN_enable_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC0B_SEN_enable_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_CC3A_SEN_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC3A_SEN_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC3A_SEN_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC3A_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC3A_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC3A_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC3A_SEN_enable_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC3A_SEN_enable_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC3A_SEN_enable_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_CC2A_SEN_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC2A_SEN_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC2A_SEN_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC2A_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC2A_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC2A_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC2A_SEN_enable_w                    ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC2A_SEN_enable_h0                   ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC2A_SEN_enable_b1                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_CC1A_SEN_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC1A_SEN_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC1A_SEN_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC1A_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC1A_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC1A_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC1A_SEN_enable_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC1A_SEN_enable_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC1A_SEN_enable_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_CC0A_SEN_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_CR1_CC0A_SEN_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_CR1_CC0A_SEN_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CR1_CC0A_SEN_no_effect_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):No-Effect of 32bit */
#define TM_CR1_CC0A_SEN_no_effect_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):No-Effect of 16bit */
#define TM_CR1_CC0A_SEN_no_effect_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):No-Effect of 8bit */
#define TM_CR1_CC0A_SEN_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CR1_CC0A_SEN_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CR1_CC0A_SEN_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CR1_OVR3_MDS_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define TM_CR1_OVR3_MDS_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_CR1_OVR3_MDS_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_CR1_OVR3_MDS_overwritten_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Overwritten of 32bit */
#define TM_CR1_OVR3_MDS_overwritten_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Overwritten of 16bit */
#define TM_CR1_OVR3_MDS_overwritten_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Overwritten of 8bit */
#define TM_CR1_OVR3_MDS_keep_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Keep of 32bit */
#define TM_CR1_OVR3_MDS_keep_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Keep of 16bit */
#define TM_CR1_OVR3_MDS_keep_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Keep of 8bit */

#define TM_CR1_OVR2_MDS_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define TM_CR1_OVR2_MDS_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_CR1_OVR2_MDS_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_CR1_OVR2_MDS_overwritten_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Overwritten of 32bit */
#define TM_CR1_OVR2_MDS_overwritten_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Overwritten of 16bit */
#define TM_CR1_OVR2_MDS_overwritten_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Overwritten of 8bit */
#define TM_CR1_OVR2_MDS_keep_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Keep of 32bit */
#define TM_CR1_OVR2_MDS_keep_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Keep of 16bit */
#define TM_CR1_OVR2_MDS_keep_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Keep of 8bit */

#define TM_CR1_OVR1_MDS_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define TM_CR1_OVR1_MDS_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_CR1_OVR1_MDS_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_CR1_OVR1_MDS_overwritten_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Overwritten of 32bit */
#define TM_CR1_OVR1_MDS_overwritten_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Overwritten of 16bit */
#define TM_CR1_OVR1_MDS_overwritten_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Overwritten of 8bit */
#define TM_CR1_OVR1_MDS_keep_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Keep of 32bit */
#define TM_CR1_OVR1_MDS_keep_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Keep of 16bit */
#define TM_CR1_OVR1_MDS_keep_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Keep of 8bit */

#define TM_CR1_OVR0_MDS_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_CR1_OVR0_MDS_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_CR1_OVR0_MDS_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CR1_OVR0_MDS_overwritten_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Overwritten of 32bit */
#define TM_CR1_OVR0_MDS_overwritten_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Overwritten of 16bit */
#define TM_CR1_OVR0_MDS_overwritten_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Overwritten of 8bit */
#define TM_CR1_OVR0_MDS_keep_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(1):Keep of 32bit */
#define TM_CR1_OVR0_MDS_keep_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Keep of 16bit */
#define TM_CR1_OVR0_MDS_keep_b0                     ((uint8_t )0x01)        /*!< Bit Value =(1):Keep of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CKO  [register's definitions]
 *              Offset[0x18]  TM Timer CKO control register
 ******************************************************************************
 */
///@{
#define TM_CKO_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CKO */
#define TM_CKO_CKO_LCK_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define TM_CKO_CKO_LCK_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_CKO_CKO_LCK_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_CKO_CKO_LCK_locked_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_CKO_CKO_LCK_locked_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_CKO_CKO_LCK_locked_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_CKO_CKO_LCK_un_locked_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_CKO_CKO_LCK_un_locked_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_CKO_CKO_LCK_un_locked_b0                 ((uint8_t )0x08)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_CKO_CKO_STA_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define TM_CKO_CKO_STA_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_CKO_CKO_STA_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_CKO_CKO_STA_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_CKO_CKO_STA_0_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_CKO_CKO_STA_0_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_CKO_CKO_STA_1_w                          ((uint32_t)0x00000004)  /*!< Bit Value =(1):1 of 32bit */
#define TM_CKO_CKO_STA_1_h0                         ((uint16_t)0x0004)      /*!< Bit Value =(1):1 of 16bit */
#define TM_CKO_CKO_STA_1_b0                         ((uint8_t )0x04)        /*!< Bit Value =(1):1 of 8bit */

#define TM_CKO_CKO_SEL_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define TM_CKO_CKO_SEL_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_CKO_CKO_SEL_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_CKO_CKO_SEL_2nd_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):2nd of 32bit */
#define TM_CKO_CKO_SEL_2nd_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):2nd of 16bit */
#define TM_CKO_CKO_SEL_2nd_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):2nd of 8bit */
#define TM_CKO_CKO_SEL_main_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(1):Main of 32bit */
#define TM_CKO_CKO_SEL_main_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(1):Main of 16bit */
#define TM_CKO_CKO_SEL_main_b0                      ((uint8_t )0x02)        /*!< Bit Value =(1):Main of 8bit */

#define TM_CKO_CKO_EN_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_CKO_CKO_EN_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_CKO_CKO_EN_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CKO_CKO_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CKO_CKO_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CKO_CKO_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CKO_CKO_EN_enable_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CKO_CKO_EN_enable_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CKO_CKO_EN_enable_b0                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_RCNT  [register's definitions]
 *              Offset[0x1C]  TM repetition counter register
 ******************************************************************************
 */
///@{
#define TM_RCNT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_RCNT */
#define TM_RCNT_RARR_mask_w                         ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define TM_RCNT_RARR_mask_h1                        ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define TM_RCNT_RARR_mask_b2                        ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define TM_RCNT_RARR_shift_w                        (16)                    /*!< Bit Shift of 32bit */
#define TM_RCNT_RARR_shift_h1                       (0)                     /*!< Bit Shift of 16bit */
#define TM_RCNT_RARR_shift_b2                       (0)                     /*!< Bit Shift of 8bit */

#define TM_RCNT_RCNT_mask_w                         ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define TM_RCNT_RCNT_mask_h0                        ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define TM_RCNT_RCNT_mask_b0                        ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define TM_RCNT_RCNT_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_RCNT_RCNT_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_RCNT_RCNT_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CNT  [register's definitions]
 *              Offset[0x20]  TM Timer main counter register
 ******************************************************************************
 */
///@{
#define TM_CNT_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CNT */
#define TM_CNT_CNT_mask_w                           ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CNT_CNT_mask_h0                          ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CNT_CNT_shift_w                          (0)                     /*!< Bit Shift of 32bit */
#define TM_CNT_CNT_shift_h0                         (0)                     /*!< Bit Shift of 16bit */
#define TM_CNT_CNT_shift_b0                         (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_ARR  [register's definitions]
 *              Offset[0x24]  TM Timer main counter auto-reload value register
 ******************************************************************************
 */
///@{
#define TM_ARR_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_ARR */
#define TM_ARR_ARR_mask_w                           ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_ARR_ARR_mask_h0                          ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */

///@}
/**
 ******************************************************************************
 * @name        TM_PSCNT  [register's definitions]
 *              Offset[0x28]  TM Timer prescaler register
 ******************************************************************************
 */
///@{
#define TM_PSCNT_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_PSCNT */
#define TM_PSCNT_CNTA_mask_w                        ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define TM_PSCNT_CNTA_mask_h1                       ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_PSCNT_CNTA_shift_w                       (16)                    /*!< Bit Shift of 32bit */
#define TM_PSCNT_CNTA_shift_h1                      (0)                     /*!< Bit Shift of 16bit */
#define TM_PSCNT_CNTA_shift_b2                      (0)                     /*!< Bit Shift of 8bit */

#define TM_PSCNT_PSCNT_mask_w                       ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_PSCNT_PSCNT_mask_h0                      ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_PSCNT_PSCNT_shift_w                      (0)                     /*!< Bit Shift of 32bit */
#define TM_PSCNT_PSCNT_shift_h0                     (0)                     /*!< Bit Shift of 16bit */
#define TM_PSCNT_PSCNT_shift_b0                     (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_PSARR  [register's definitions]
 *              Offset[0x2C]  TM Timer prescaler auto-reload register
 ******************************************************************************
 */
///@{
#define TM_PSARR_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_PSARR */
#define TM_PSARR_PSARR_mask_w                       ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_PSARR_PSARR_mask_h0                      ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_PSARR_PSARR_shift_w                      (0)                     /*!< Bit Shift of 32bit */
#define TM_PSARR_PSARR_shift_h0                     (0)                     /*!< Bit Shift of 16bit */
#define TM_PSARR_PSARR_shift_b0                     (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CCMDS  [register's definitions]
 *              Offset[0x30]  TM Timer capture and compare mode select register
 ******************************************************************************
 */
///@{
#define TM_CCMDS_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CCMDS */
#define TM_CCMDS_DMA_CC3E_mask_w                    ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_DMA_CC3E_mask_h1                   ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_DMA_CC3E_mask_b3                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_DMA_CC3E_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CCMDS_DMA_CC3E_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CCMDS_DMA_CC3E_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CCMDS_DMA_CC3E_enable_w                  ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CCMDS_DMA_CC3E_enable_h1                 ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CCMDS_DMA_CC3E_enable_b3                 ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CCMDS_DMA_CC2E_mask_w                    ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_DMA_CC2E_mask_h1                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_DMA_CC2E_mask_b3                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_DMA_CC2E_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CCMDS_DMA_CC2E_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CCMDS_DMA_CC2E_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CCMDS_DMA_CC2E_enable_w                  ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CCMDS_DMA_CC2E_enable_h1                 ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CCMDS_DMA_CC2E_enable_b3                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CCMDS_DMA_CC1E_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_DMA_CC1E_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_DMA_CC1E_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_DMA_CC1E_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CCMDS_DMA_CC1E_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CCMDS_DMA_CC1E_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CCMDS_DMA_CC1E_enable_w                  ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CCMDS_DMA_CC1E_enable_h1                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CCMDS_DMA_CC1E_enable_b3                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CCMDS_DMA_CC0E_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_DMA_CC0E_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_DMA_CC0E_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_DMA_CC0E_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_CCMDS_DMA_CC0E_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_CCMDS_DMA_CC0E_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_CCMDS_DMA_CC0E_enable_w                  ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_CCMDS_DMA_CC0E_enable_h1                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_CCMDS_DMA_CC0E_enable_b3                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_CCMDS_DMA_OMDS_mask_w                    ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_DMA_OMDS_mask_h1                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_DMA_OMDS_mask_b2                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_DMA_OMDS_uev_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):UEV of 32bit */
#define TM_CCMDS_DMA_OMDS_uev_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):UEV of 16bit */
#define TM_CCMDS_DMA_OMDS_uev_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):UEV of 8bit */
#define TM_CCMDS_DMA_OMDS_itr_w                     ((uint32_t)0x00800000)  /*!< Bit Value =(1):ITR of 32bit */
#define TM_CCMDS_DMA_OMDS_itr_h1                    ((uint16_t)0x0080)      /*!< Bit Value =(1):ITR of 16bit */
#define TM_CCMDS_DMA_OMDS_itr_b2                    ((uint8_t )0x80)        /*!< Bit Value =(1):ITR of 8bit */

#define TM_CCMDS_OC_LCK_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_OC_LCK_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_OC_LCK_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_OC_LCK_un_locked_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):un-Locked of 32bit */
#define TM_CCMDS_OC_LCK_un_locked_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):un-Locked of 16bit */
#define TM_CCMDS_OC_LCK_un_locked_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):un-Locked of 8bit */
#define TM_CCMDS_OC_LCK_locked_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Locked of 32bit */
#define TM_CCMDS_OC_LCK_locked_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Locked of 16bit */
#define TM_CCMDS_OC_LCK_locked_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Locked of 8bit */

#define TM_CCMDS_CC3_MDS_mask_w                     ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_CC3_MDS_mask_h0                    ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_CC3_MDS_mask_b1                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_CC3_MDS_nop_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):NOP of 32bit */
#define TM_CCMDS_CC3_MDS_nop_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):NOP of 16bit */
#define TM_CCMDS_CC3_MDS_nop_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):NOP of 8bit */
#define TM_CCMDS_CC3_MDS_16bit_ic_w                 ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):16bit_IC of 32bit */
#define TM_CCMDS_CC3_MDS_16bit_ic_h0                ((uint16_t)0x1000)      /*!< Bit Value =(0x1):16bit_IC of 16bit */
#define TM_CCMDS_CC3_MDS_16bit_ic_b1                ((uint8_t )0x10)        /*!< Bit Value =(0x1):16bit_IC of 8bit */
#define TM_CCMDS_CC3_MDS_16bit_oc_w                 ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):16bit_OC of 32bit */
#define TM_CCMDS_CC3_MDS_16bit_oc_h0                ((uint16_t)0x2000)      /*!< Bit Value =(0x2):16bit_OC of 16bit */
#define TM_CCMDS_CC3_MDS_16bit_oc_b1                ((uint8_t )0x20)        /*!< Bit Value =(0x2):16bit_OC of 8bit */
#define TM_CCMDS_CC3_MDS_8bitx2_oc_w                ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):8bitx2_OC of 32bit */
#define TM_CCMDS_CC3_MDS_8bitx2_oc_h0               ((uint16_t)0x3000)      /*!< Bit Value =(0x3):8bitx2_OC of 16bit */
#define TM_CCMDS_CC3_MDS_8bitx2_oc_b1               ((uint8_t )0x30)        /*!< Bit Value =(0x3):8bitx2_OC of 8bit */
#define TM_CCMDS_CC3_MDS_16bit_pwm_w                ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):16bit_PWM of 32bit */
#define TM_CCMDS_CC3_MDS_16bit_pwm_h0               ((uint16_t)0x4000)      /*!< Bit Value =(0x4):16bit_PWM of 16bit */
#define TM_CCMDS_CC3_MDS_16bit_pwm_b1               ((uint8_t )0x40)        /*!< Bit Value =(0x4):16bit_PWM of 8bit */
#define TM_CCMDS_CC3_MDS_8bitx2_pwm_w               ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):8bitx2_PWM of 32bit */
#define TM_CCMDS_CC3_MDS_8bitx2_pwm_h0              ((uint16_t)0x5000)      /*!< Bit Value =(0x5):8bitx2_PWM of 16bit */
#define TM_CCMDS_CC3_MDS_8bitx2_pwm_b1              ((uint8_t )0x50)        /*!< Bit Value =(0x5):8bitx2_PWM of 8bit */

#define TM_CCMDS_CC2_MDS_mask_w                     ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_CC2_MDS_mask_h0                    ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_CC2_MDS_mask_b1                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_CC2_MDS_nop_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):NOP of 32bit */
#define TM_CCMDS_CC2_MDS_nop_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):NOP of 16bit */
#define TM_CCMDS_CC2_MDS_nop_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):NOP of 8bit */
#define TM_CCMDS_CC2_MDS_16bit_ic_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):16bit_IC of 32bit */
#define TM_CCMDS_CC2_MDS_16bit_ic_h0                ((uint16_t)0x0100)      /*!< Bit Value =(0x1):16bit_IC of 16bit */
#define TM_CCMDS_CC2_MDS_16bit_ic_b1                ((uint8_t )0x01)        /*!< Bit Value =(0x1):16bit_IC of 8bit */
#define TM_CCMDS_CC2_MDS_16bit_oc_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):16bit_OC of 32bit */
#define TM_CCMDS_CC2_MDS_16bit_oc_h0                ((uint16_t)0x0200)      /*!< Bit Value =(0x2):16bit_OC of 16bit */
#define TM_CCMDS_CC2_MDS_16bit_oc_b1                ((uint8_t )0x02)        /*!< Bit Value =(0x2):16bit_OC of 8bit */
#define TM_CCMDS_CC2_MDS_8bitx2_oc_w                ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):8bitx2_OC of 32bit */
#define TM_CCMDS_CC2_MDS_8bitx2_oc_h0               ((uint16_t)0x0300)      /*!< Bit Value =(0x3):8bitx2_OC of 16bit */
#define TM_CCMDS_CC2_MDS_8bitx2_oc_b1               ((uint8_t )0x03)        /*!< Bit Value =(0x3):8bitx2_OC of 8bit */
#define TM_CCMDS_CC2_MDS_16bit_pwm_w                ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):16bit_PWM of 32bit */
#define TM_CCMDS_CC2_MDS_16bit_pwm_h0               ((uint16_t)0x0400)      /*!< Bit Value =(0x4):16bit_PWM of 16bit */
#define TM_CCMDS_CC2_MDS_16bit_pwm_b1               ((uint8_t )0x04)        /*!< Bit Value =(0x4):16bit_PWM of 8bit */
#define TM_CCMDS_CC2_MDS_8bitx2_pwm_w               ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):8bitx2_PWM of 32bit */
#define TM_CCMDS_CC2_MDS_8bitx2_pwm_h0              ((uint16_t)0x0500)      /*!< Bit Value =(0x5):8bitx2_PWM of 16bit */
#define TM_CCMDS_CC2_MDS_8bitx2_pwm_b1              ((uint8_t )0x05)        /*!< Bit Value =(0x5):8bitx2_PWM of 8bit */
#define TM_CCMDS_CC2_MDS_16bit_pwm_dtg_w            ((uint32_t)0x00000600)  /*!< Bit Value =(0x6):16bit_PWM_DTG of 32bit */
#define TM_CCMDS_CC2_MDS_16bit_pwm_dtg_h0           ((uint16_t)0x0600)      /*!< Bit Value =(0x6):16bit_PWM_DTG of 16bit */
#define TM_CCMDS_CC2_MDS_16bit_pwm_dtg_b1           ((uint8_t )0x06)        /*!< Bit Value =(0x6):16bit_PWM_DTG of 8bit */
#define TM_CCMDS_CC2_MDS_8bitx2_pwm_dtg_w           ((uint32_t)0x00000700)  /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 32bit */
#define TM_CCMDS_CC2_MDS_8bitx2_pwm_dtg_h0          ((uint16_t)0x0700)      /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 16bit */
#define TM_CCMDS_CC2_MDS_8bitx2_pwm_dtg_b1          ((uint8_t )0x07)        /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 8bit */

#define TM_CCMDS_CC1_MDS_mask_w                     ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_CC1_MDS_mask_h0                    ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_CC1_MDS_mask_b0                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_CC1_MDS_nop_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):NOP of 32bit */
#define TM_CCMDS_CC1_MDS_nop_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):NOP of 16bit */
#define TM_CCMDS_CC1_MDS_nop_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):NOP of 8bit */
#define TM_CCMDS_CC1_MDS_16bit_ic_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):16bit_IC of 32bit */
#define TM_CCMDS_CC1_MDS_16bit_ic_h0                ((uint16_t)0x0010)      /*!< Bit Value =(0x1):16bit_IC of 16bit */
#define TM_CCMDS_CC1_MDS_16bit_ic_b0                ((uint8_t )0x10)        /*!< Bit Value =(0x1):16bit_IC of 8bit */
#define TM_CCMDS_CC1_MDS_16bit_oc_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):16bit_OC of 32bit */
#define TM_CCMDS_CC1_MDS_16bit_oc_h0                ((uint16_t)0x0020)      /*!< Bit Value =(0x2):16bit_OC of 16bit */
#define TM_CCMDS_CC1_MDS_16bit_oc_b0                ((uint8_t )0x20)        /*!< Bit Value =(0x2):16bit_OC of 8bit */
#define TM_CCMDS_CC1_MDS_8bitx2_oc_w                ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):8bitx2_OC of 32bit */
#define TM_CCMDS_CC1_MDS_8bitx2_oc_h0               ((uint16_t)0x0030)      /*!< Bit Value =(0x3):8bitx2_OC of 16bit */
#define TM_CCMDS_CC1_MDS_8bitx2_oc_b0               ((uint8_t )0x30)        /*!< Bit Value =(0x3):8bitx2_OC of 8bit */
#define TM_CCMDS_CC1_MDS_16bit_pwm_w                ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):16bit_PWM of 32bit */
#define TM_CCMDS_CC1_MDS_16bit_pwm_h0               ((uint16_t)0x0040)      /*!< Bit Value =(0x4):16bit_PWM of 16bit */
#define TM_CCMDS_CC1_MDS_16bit_pwm_b0               ((uint8_t )0x40)        /*!< Bit Value =(0x4):16bit_PWM of 8bit */
#define TM_CCMDS_CC1_MDS_8bitx2_pwm_w               ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):8bitx2_PWM of 32bit */
#define TM_CCMDS_CC1_MDS_8bitx2_pwm_h0              ((uint16_t)0x0050)      /*!< Bit Value =(0x5):8bitx2_PWM of 16bit */
#define TM_CCMDS_CC1_MDS_8bitx2_pwm_b0              ((uint8_t )0x50)        /*!< Bit Value =(0x5):8bitx2_PWM of 8bit */
#define TM_CCMDS_CC1_MDS_16bit_pwm_dtg_w            ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):16bit_PWM_DTG of 32bit */
#define TM_CCMDS_CC1_MDS_16bit_pwm_dtg_h0           ((uint16_t)0x0060)      /*!< Bit Value =(0x6):16bit_PWM_DTG of 16bit */
#define TM_CCMDS_CC1_MDS_16bit_pwm_dtg_b0           ((uint8_t )0x60)        /*!< Bit Value =(0x6):16bit_PWM_DTG of 8bit */
#define TM_CCMDS_CC1_MDS_8bitx2_pwm_dtg_w           ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 32bit */
#define TM_CCMDS_CC1_MDS_8bitx2_pwm_dtg_h0          ((uint16_t)0x0070)      /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 16bit */
#define TM_CCMDS_CC1_MDS_8bitx2_pwm_dtg_b0          ((uint8_t )0x70)        /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 8bit */

#define TM_CCMDS_CC0_MDS_mask_w                     ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define TM_CCMDS_CC0_MDS_mask_h0                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define TM_CCMDS_CC0_MDS_mask_b0                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define TM_CCMDS_CC0_MDS_nop_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):NOP of 32bit */
#define TM_CCMDS_CC0_MDS_nop_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):NOP of 16bit */
#define TM_CCMDS_CC0_MDS_nop_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):NOP of 8bit */
#define TM_CCMDS_CC0_MDS_16bit_ic_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):16bit_IC of 32bit */
#define TM_CCMDS_CC0_MDS_16bit_ic_h0                ((uint16_t)0x0001)      /*!< Bit Value =(0x1):16bit_IC of 16bit */
#define TM_CCMDS_CC0_MDS_16bit_ic_b0                ((uint8_t )0x01)        /*!< Bit Value =(0x1):16bit_IC of 8bit */
#define TM_CCMDS_CC0_MDS_16bit_oc_w                 ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):16bit_OC of 32bit */
#define TM_CCMDS_CC0_MDS_16bit_oc_h0                ((uint16_t)0x0002)      /*!< Bit Value =(0x2):16bit_OC of 16bit */
#define TM_CCMDS_CC0_MDS_16bit_oc_b0                ((uint8_t )0x02)        /*!< Bit Value =(0x2):16bit_OC of 8bit */
#define TM_CCMDS_CC0_MDS_8bitx2_oc_w                ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):8bitx2_OC of 32bit */
#define TM_CCMDS_CC0_MDS_8bitx2_oc_h0               ((uint16_t)0x0003)      /*!< Bit Value =(0x3):8bitx2_OC of 16bit */
#define TM_CCMDS_CC0_MDS_8bitx2_oc_b0               ((uint8_t )0x03)        /*!< Bit Value =(0x3):8bitx2_OC of 8bit */
#define TM_CCMDS_CC0_MDS_16bit_pwm_w                ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):16bit_PWM of 32bit */
#define TM_CCMDS_CC0_MDS_16bit_pwm_h0               ((uint16_t)0x0004)      /*!< Bit Value =(0x4):16bit_PWM of 16bit */
#define TM_CCMDS_CC0_MDS_16bit_pwm_b0               ((uint8_t )0x04)        /*!< Bit Value =(0x4):16bit_PWM of 8bit */
#define TM_CCMDS_CC0_MDS_8bitx2_pwm_w               ((uint32_t)0x00000005)  /*!< Bit Value =(0x5):8bitx2_PWM of 32bit */
#define TM_CCMDS_CC0_MDS_8bitx2_pwm_h0              ((uint16_t)0x0005)      /*!< Bit Value =(0x5):8bitx2_PWM of 16bit */
#define TM_CCMDS_CC0_MDS_8bitx2_pwm_b0              ((uint8_t )0x05)        /*!< Bit Value =(0x5):8bitx2_PWM of 8bit */
#define TM_CCMDS_CC0_MDS_16bit_pwm_dtg_w            ((uint32_t)0x00000006)  /*!< Bit Value =(0x6):16bit_PWM_DTG of 32bit */
#define TM_CCMDS_CC0_MDS_16bit_pwm_dtg_h0           ((uint16_t)0x0006)      /*!< Bit Value =(0x6):16bit_PWM_DTG of 16bit */
#define TM_CCMDS_CC0_MDS_16bit_pwm_dtg_b0           ((uint8_t )0x06)        /*!< Bit Value =(0x6):16bit_PWM_DTG of 8bit */
#define TM_CCMDS_CC0_MDS_8bitx2_pwm_dtg_w           ((uint32_t)0x00000007)  /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 32bit */
#define TM_CCMDS_CC0_MDS_8bitx2_pwm_dtg_h0          ((uint16_t)0x0007)      /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 16bit */
#define TM_CCMDS_CC0_MDS_8bitx2_pwm_dtg_b0          ((uint8_t )0x07)        /*!< Bit Value =(0x7):8bitx2_PWM_DTG of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_ICCR  [register's definitions]
 *              Offset[0x34]  TM Timer input capture control register
 ******************************************************************************
 */
///@{
#define TM_ICCR_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_ICCR */
#define TM_ICCR_IC3_TRGS_mask_w                     ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC3_TRGS_mask_h1                    ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC3_TRGS_mask_b2                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC3_TRGS_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define TM_ICCR_IC3_TRGS_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define TM_ICCR_IC3_TRGS_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define TM_ICCR_IC3_TRGS_rising_edge_w              ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define TM_ICCR_IC3_TRGS_rising_edge_h1             ((uint16_t)0x0040)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define TM_ICCR_IC3_TRGS_rising_edge_b2             ((uint8_t )0x40)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define TM_ICCR_IC3_TRGS_falling_edge_w             ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define TM_ICCR_IC3_TRGS_falling_edge_h1            ((uint16_t)0x0080)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define TM_ICCR_IC3_TRGS_falling_edge_b2            ((uint8_t )0x80)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define TM_ICCR_IC3_TRGS_dual_edge_w                ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define TM_ICCR_IC3_TRGS_dual_edge_h1               ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define TM_ICCR_IC3_TRGS_dual_edge_b2               ((uint8_t )0xC0)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define TM_ICCR_IC2_TRGS_mask_w                     ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC2_TRGS_mask_h1                    ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC2_TRGS_mask_b2                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC2_TRGS_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define TM_ICCR_IC2_TRGS_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define TM_ICCR_IC2_TRGS_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define TM_ICCR_IC2_TRGS_rising_edge_w              ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define TM_ICCR_IC2_TRGS_rising_edge_h1             ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define TM_ICCR_IC2_TRGS_rising_edge_b2             ((uint8_t )0x10)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define TM_ICCR_IC2_TRGS_falling_edge_w             ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define TM_ICCR_IC2_TRGS_falling_edge_h1            ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define TM_ICCR_IC2_TRGS_falling_edge_b2            ((uint8_t )0x20)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define TM_ICCR_IC2_TRGS_dual_edge_w                ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define TM_ICCR_IC2_TRGS_dual_edge_h1               ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define TM_ICCR_IC2_TRGS_dual_edge_b2               ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define TM_ICCR_IC1_TRGS_mask_w                     ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC1_TRGS_mask_h1                    ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC1_TRGS_mask_b2                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC1_TRGS_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define TM_ICCR_IC1_TRGS_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define TM_ICCR_IC1_TRGS_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define TM_ICCR_IC1_TRGS_rising_edge_w              ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define TM_ICCR_IC1_TRGS_rising_edge_h1             ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define TM_ICCR_IC1_TRGS_rising_edge_b2             ((uint8_t )0x04)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define TM_ICCR_IC1_TRGS_falling_edge_w             ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define TM_ICCR_IC1_TRGS_falling_edge_h1            ((uint16_t)0x0008)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define TM_ICCR_IC1_TRGS_falling_edge_b2            ((uint8_t )0x08)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define TM_ICCR_IC1_TRGS_dual_edge_w                ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define TM_ICCR_IC1_TRGS_dual_edge_h1               ((uint16_t)0x000C)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define TM_ICCR_IC1_TRGS_dual_edge_b2               ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define TM_ICCR_IC0_TRGS_mask_w                     ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC0_TRGS_mask_h1                    ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC0_TRGS_mask_b2                    ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC0_TRGS_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define TM_ICCR_IC0_TRGS_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define TM_ICCR_IC0_TRGS_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define TM_ICCR_IC0_TRGS_rising_edge_w              ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define TM_ICCR_IC0_TRGS_rising_edge_h1             ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define TM_ICCR_IC0_TRGS_rising_edge_b2             ((uint8_t )0x01)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define TM_ICCR_IC0_TRGS_falling_edge_w             ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define TM_ICCR_IC0_TRGS_falling_edge_h1            ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define TM_ICCR_IC0_TRGS_falling_edge_b2            ((uint8_t )0x02)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define TM_ICCR_IC0_TRGS_dual_edge_w                ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define TM_ICCR_IC0_TRGS_dual_edge_h1               ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define TM_ICCR_IC0_TRGS_dual_edge_b2               ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define TM_ICCR_IC3_MUX_mask_w                      ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC3_MUX_mask_h0                     ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC3_MUX_mask_b1                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC3_MUX_ic30_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IC30 of 32bit */
#define TM_ICCR_IC3_MUX_ic30_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IC30 of 16bit */
#define TM_ICCR_IC3_MUX_ic30_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):IC30 of 8bit */
#define TM_ICCR_IC3_MUX_ic31_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):IC31 of 32bit */
#define TM_ICCR_IC3_MUX_ic31_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(0x1):IC31 of 16bit */
#define TM_ICCR_IC3_MUX_ic31_b1                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):IC31 of 8bit */
#define TM_ICCR_IC3_MUX_ic32_w                      ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):IC32 of 32bit */
#define TM_ICCR_IC3_MUX_ic32_h0                     ((uint16_t)0x2000)      /*!< Bit Value =(0x2):IC32 of 16bit */
#define TM_ICCR_IC3_MUX_ic32_b1                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):IC32 of 8bit */
#define TM_ICCR_IC3_MUX_ic33_w                      ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):IC33 of 32bit */
#define TM_ICCR_IC3_MUX_ic33_h0                     ((uint16_t)0x3000)      /*!< Bit Value =(0x3):IC33 of 16bit */
#define TM_ICCR_IC3_MUX_ic33_b1                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):IC33 of 8bit */

#define TM_ICCR_IC2_MUX_mask_w                      ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC2_MUX_mask_h0                     ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC2_MUX_mask_b1                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC2_MUX_ic20_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IC20 of 32bit */
#define TM_ICCR_IC2_MUX_ic20_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IC20 of 16bit */
#define TM_ICCR_IC2_MUX_ic20_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):IC20 of 8bit */
#define TM_ICCR_IC2_MUX_ic21_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):IC21 of 32bit */
#define TM_ICCR_IC2_MUX_ic21_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):IC21 of 16bit */
#define TM_ICCR_IC2_MUX_ic21_b1                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):IC21 of 8bit */
#define TM_ICCR_IC2_MUX_ic22_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):IC22 of 32bit */
#define TM_ICCR_IC2_MUX_ic22_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(0x2):IC22 of 16bit */
#define TM_ICCR_IC2_MUX_ic22_b1                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):IC22 of 8bit */
#define TM_ICCR_IC2_MUX_ic23_w                      ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):IC23 of 32bit */
#define TM_ICCR_IC2_MUX_ic23_h0                     ((uint16_t)0x0300)      /*!< Bit Value =(0x3):IC23 of 16bit */
#define TM_ICCR_IC2_MUX_ic23_b1                     ((uint8_t )0x03)        /*!< Bit Value =(0x3):IC23 of 8bit */

#define TM_ICCR_IC1_MUX_mask_w                      ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC1_MUX_mask_h0                     ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC1_MUX_mask_b0                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC1_MUX_ic10_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IC10 of 32bit */
#define TM_ICCR_IC1_MUX_ic10_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IC10 of 16bit */
#define TM_ICCR_IC1_MUX_ic10_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):IC10 of 8bit */
#define TM_ICCR_IC1_MUX_ic11_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):IC11 of 32bit */
#define TM_ICCR_IC1_MUX_ic11_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(0x1):IC11 of 16bit */
#define TM_ICCR_IC1_MUX_ic11_b0                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):IC11 of 8bit */
#define TM_ICCR_IC1_MUX_ic12_w                      ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):IC12 of 32bit */
#define TM_ICCR_IC1_MUX_ic12_h0                     ((uint16_t)0x0020)      /*!< Bit Value =(0x2):IC12 of 16bit */
#define TM_ICCR_IC1_MUX_ic12_b0                     ((uint8_t )0x20)        /*!< Bit Value =(0x2):IC12 of 8bit */
#define TM_ICCR_IC1_MUX_ic13_w                      ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):IC13 of 32bit */
#define TM_ICCR_IC1_MUX_ic13_h0                     ((uint16_t)0x0030)      /*!< Bit Value =(0x3):IC13 of 16bit */
#define TM_ICCR_IC1_MUX_ic13_b0                     ((uint8_t )0x30)        /*!< Bit Value =(0x3):IC13 of 8bit */

#define TM_ICCR_IC0_MUX_mask_w                      ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define TM_ICCR_IC0_MUX_mask_h0                     ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define TM_ICCR_IC0_MUX_mask_b0                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define TM_ICCR_IC0_MUX_ic00_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IC00 of 32bit */
#define TM_ICCR_IC0_MUX_ic00_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IC00 of 16bit */
#define TM_ICCR_IC0_MUX_ic00_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):IC00 of 8bit */
#define TM_ICCR_IC0_MUX_ic01_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):IC01 of 32bit */
#define TM_ICCR_IC0_MUX_ic01_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(0x1):IC01 of 16bit */
#define TM_ICCR_IC0_MUX_ic01_b0                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):IC01 of 8bit */
#define TM_ICCR_IC0_MUX_ic02_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):IC02 of 32bit */
#define TM_ICCR_IC0_MUX_ic02_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(0x2):IC02 of 16bit */
#define TM_ICCR_IC0_MUX_ic02_b0                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):IC02 of 8bit */
#define TM_ICCR_IC0_MUX_ic03_w                      ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):IC03 of 32bit */
#define TM_ICCR_IC0_MUX_ic03_h0                     ((uint16_t)0x0003)      /*!< Bit Value =(0x3):IC03 of 16bit */
#define TM_ICCR_IC0_MUX_ic03_b0                     ((uint8_t )0x03)        /*!< Bit Value =(0x3):IC03 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_OSCR  [register's definitions]
 *              Offset[0x38]  TM Timer output compare state register
 ******************************************************************************
 */
///@{
#define TM_OSCR_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_OSCR */
#define TM_OSCR_OS3H_LCK_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS3H_LCK_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS3H_LCK_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS3H_LCK_locked_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS3H_LCK_locked_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS3H_LCK_locked_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS3H_LCK_un_locked_w                ((uint32_t)0x00008000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS3H_LCK_un_locked_h0               ((uint16_t)0x8000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS3H_LCK_un_locked_b1               ((uint8_t )0x80)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS2H_LCK_mask_w                     ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS2H_LCK_mask_h0                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS2H_LCK_mask_b1                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS2H_LCK_locked_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS2H_LCK_locked_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS2H_LCK_locked_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS2H_LCK_un_locked_w                ((uint32_t)0x00004000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS2H_LCK_un_locked_h0               ((uint16_t)0x4000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS2H_LCK_un_locked_b1               ((uint8_t )0x40)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS1H_LCK_mask_w                     ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS1H_LCK_mask_h0                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS1H_LCK_mask_b1                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS1H_LCK_locked_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS1H_LCK_locked_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS1H_LCK_locked_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS1H_LCK_un_locked_w                ((uint32_t)0x00002000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS1H_LCK_un_locked_h0               ((uint16_t)0x2000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS1H_LCK_un_locked_b1               ((uint8_t )0x20)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS0H_LCK_mask_w                     ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS0H_LCK_mask_h0                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS0H_LCK_mask_b1                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS0H_LCK_locked_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS0H_LCK_locked_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS0H_LCK_locked_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS0H_LCK_un_locked_w                ((uint32_t)0x00001000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS0H_LCK_un_locked_h0               ((uint16_t)0x1000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS0H_LCK_un_locked_b1               ((uint8_t )0x10)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS3H_STA_mask_w                     ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS3H_STA_mask_h0                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS3H_STA_mask_b1                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS3H_STA_0_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS3H_STA_0_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS3H_STA_0_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS3H_STA_1_w                        ((uint32_t)0x00000800)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS3H_STA_1_h0                       ((uint16_t)0x0800)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS3H_STA_1_b1                       ((uint8_t )0x08)        /*!< Bit Value =(1):1 of 8bit */

#define TM_OSCR_OS2H_STA_mask_w                     ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS2H_STA_mask_h0                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS2H_STA_mask_b1                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS2H_STA_0_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS2H_STA_0_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS2H_STA_0_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS2H_STA_1_w                        ((uint32_t)0x00000400)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS2H_STA_1_h0                       ((uint16_t)0x0400)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS2H_STA_1_b1                       ((uint8_t )0x04)        /*!< Bit Value =(1):1 of 8bit */

#define TM_OSCR_OS1H_STA_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS1H_STA_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS1H_STA_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS1H_STA_0_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS1H_STA_0_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS1H_STA_0_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS1H_STA_1_w                        ((uint32_t)0x00000200)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS1H_STA_1_h0                       ((uint16_t)0x0200)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS1H_STA_1_b1                       ((uint8_t )0x02)        /*!< Bit Value =(1):1 of 8bit */

#define TM_OSCR_OS0H_STA_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS0H_STA_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS0H_STA_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS0H_STA_0_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS0H_STA_0_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS0H_STA_0_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS0H_STA_1_w                        ((uint32_t)0x00000100)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS0H_STA_1_h0                       ((uint16_t)0x0100)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS0H_STA_1_b1                       ((uint8_t )0x01)        /*!< Bit Value =(1):1 of 8bit */

#define TM_OSCR_OS3_LCK_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS3_LCK_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS3_LCK_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS3_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS3_LCK_locked_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS3_LCK_locked_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS3_LCK_un_locked_w                 ((uint32_t)0x00000080)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS3_LCK_un_locked_h0                ((uint16_t)0x0080)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS3_LCK_un_locked_b0                ((uint8_t )0x80)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS2_LCK_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS2_LCK_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS2_LCK_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS2_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS2_LCK_locked_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS2_LCK_locked_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS2_LCK_un_locked_w                 ((uint32_t)0x00000040)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS2_LCK_un_locked_h0                ((uint16_t)0x0040)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS2_LCK_un_locked_b0                ((uint8_t )0x40)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS1_LCK_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS1_LCK_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS1_LCK_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS1_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS1_LCK_locked_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS1_LCK_locked_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS1_LCK_un_locked_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS1_LCK_un_locked_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS1_LCK_un_locked_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS0_LCK_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS0_LCK_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS0_LCK_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS0_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define TM_OSCR_OS0_LCK_locked_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define TM_OSCR_OS0_LCK_locked_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define TM_OSCR_OS0_LCK_un_locked_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define TM_OSCR_OS0_LCK_un_locked_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define TM_OSCR_OS0_LCK_un_locked_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define TM_OSCR_OS3_STA_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS3_STA_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS3_STA_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS3_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS3_STA_0_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS3_STA_0_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS3_STA_1_w                         ((uint32_t)0x00000008)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS3_STA_1_h0                        ((uint16_t)0x0008)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS3_STA_1_b0                        ((uint8_t )0x08)        /*!< Bit Value =(1):1 of 8bit */

#define TM_OSCR_OS2_STA_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS2_STA_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS2_STA_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS2_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS2_STA_0_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS2_STA_0_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS2_STA_1_w                         ((uint32_t)0x00000004)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS2_STA_1_h0                        ((uint16_t)0x0004)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS2_STA_1_b0                        ((uint8_t )0x04)        /*!< Bit Value =(1):1 of 8bit */

#define TM_OSCR_OS1_STA_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS1_STA_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS1_STA_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS1_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS1_STA_0_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS1_STA_0_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS1_STA_1_w                         ((uint32_t)0x00000002)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS1_STA_1_h0                        ((uint16_t)0x0002)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS1_STA_1_b0                        ((uint8_t )0x02)        /*!< Bit Value =(1):1 of 8bit */

#define TM_OSCR_OS0_STA_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_OSCR_OS0_STA_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_OSCR_OS0_STA_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OSCR_OS0_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_OSCR_OS0_STA_0_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_OSCR_OS0_STA_0_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_OSCR_OS0_STA_1_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):1 of 32bit */
#define TM_OSCR_OS0_STA_1_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):1 of 16bit */
#define TM_OSCR_OS0_STA_1_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):1 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_OCCR0  [register's definitions]
 *              Offset[0x3C]  TM Timer output compare control register 0
 ******************************************************************************
 */
///@{
#define TM_OCCR0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_OCCR0 */
#define TM_OCCR0_OC2N_OE_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC2N_OE_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC2N_OE_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC2N_OE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC2N_OE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC2N_OE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC2N_OE_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC2N_OE_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC2N_OE_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC1N_OE_mask_w                     ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC1N_OE_mask_h1                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC1N_OE_mask_b2                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC1N_OE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC1N_OE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC1N_OE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC1N_OE_enable_w                   ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC1N_OE_enable_h1                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC1N_OE_enable_b2                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC0N_OE_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC0N_OE_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC0N_OE_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC0N_OE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC0N_OE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC0N_OE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC0N_OE_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC0N_OE_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC0N_OE_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC3_OE_mask_w                      ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC3_OE_mask_h0                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC3_OE_mask_b1                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC3_OE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC3_OE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC3_OE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC3_OE_enable_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC3_OE_enable_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC3_OE_enable_b1                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC2_OE_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC2_OE_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC2_OE_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC2_OE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC2_OE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC2_OE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC2_OE_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC2_OE_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC2_OE_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC1_OE2_mask_w                     ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC1_OE2_mask_h0                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC1_OE2_mask_b0                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC1_OE2_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC1_OE2_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC1_OE2_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC1_OE2_enable_w                   ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC1_OE2_enable_h0                  ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC1_OE2_enable_b0                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC1_OE1_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC1_OE1_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC1_OE1_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC1_OE1_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC1_OE1_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC1_OE1_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC1_OE1_enable_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC1_OE1_enable_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC1_OE1_enable_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC1_OE0_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC1_OE0_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC1_OE0_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC1_OE0_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC1_OE0_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC1_OE0_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC1_OE0_enable_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC1_OE0_enable_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC1_OE0_enable_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC0_OE2_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC0_OE2_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC0_OE2_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC0_OE2_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC0_OE2_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC0_OE2_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC0_OE2_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC0_OE2_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC0_OE2_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC0_OE1_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC0_OE1_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC0_OE1_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC0_OE1_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC0_OE1_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC0_OE1_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC0_OE1_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC0_OE1_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC0_OE1_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR0_OC0_OE0_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_OCCR0_OC0_OE0_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_OCCR0_OC0_OE0_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR0_OC0_OE0_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR0_OC0_OE0_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR0_OC0_OE0_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR0_OC0_OE0_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR0_OC0_OE0_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR0_OC0_OE0_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_OCCR1  [register's definitions]
 *              Offset[0x40]  TM Timer output compare control register 1
 ******************************************************************************
 */
///@{
#define TM_OCCR1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_OCCR1 */
#define TM_OCCR1_ODLY_SEL_mask_w                    ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_ODLY_SEL_mask_h1                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_ODLY_SEL_mask_b3                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_ODLY_SEL_0step_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0Step of 32bit */
#define TM_OCCR1_ODLY_SEL_0step_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0Step of 16bit */
#define TM_OCCR1_ODLY_SEL_0step_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):0Step of 8bit */
#define TM_OCCR1_ODLY_SEL_1step_w                   ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):1Step of 32bit */
#define TM_OCCR1_ODLY_SEL_1step_h1                  ((uint16_t)0x4000)      /*!< Bit Value =(0x1):1Step of 16bit */
#define TM_OCCR1_ODLY_SEL_1step_b3                  ((uint8_t )0x40)        /*!< Bit Value =(0x1):1Step of 8bit */

#define TM_OCCR1_POE_SW_mask_w                      ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_POE_SW_mask_h1                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_POE_SW_mask_b3                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_POE_SW_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_POE_SW_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_POE_SW_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_POE_SW_enable_w                    ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_POE_SW_enable_h1                   ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_POE_SW_enable_b3                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_POE_EN2_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_POE_EN2_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_POE_EN2_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_POE_EN2_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_POE_EN2_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_POE_EN2_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_POE_EN2_enable_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_POE_EN2_enable_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_POE_EN2_enable_b3                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_POE_EN1_mask_w                     ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_POE_EN1_mask_h1                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_POE_EN1_mask_b3                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_POE_EN1_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_POE_EN1_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_POE_EN1_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_POE_EN1_enable_w                   ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_POE_EN1_enable_h1                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_POE_EN1_enable_b3                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_POE_EN0_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_POE_EN0_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_POE_EN0_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_POE_EN0_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_POE_EN0_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_POE_EN0_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_POE_EN0_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_POE_EN0_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_POE_EN0_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC1_POE2_mask_w                    ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC1_POE2_mask_h1                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC1_POE2_mask_b2                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC1_POE2_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC1_POE2_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC1_POE2_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC1_POE2_enable_w                  ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC1_POE2_enable_h1                 ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC1_POE2_enable_b2                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC1_POE1_mask_w                    ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC1_POE1_mask_h1                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC1_POE1_mask_b2                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC1_POE1_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC1_POE1_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC1_POE1_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC1_POE1_enable_w                  ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC1_POE1_enable_h1                 ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC1_POE1_enable_b2                 ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC1_POE0_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC1_POE0_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC1_POE0_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC1_POE0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC1_POE0_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC1_POE0_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC1_POE0_enable_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC1_POE0_enable_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC1_POE0_enable_b2                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC0_POE2_mask_w                    ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC0_POE2_mask_h1                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC0_POE2_mask_b2                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC0_POE2_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC0_POE2_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC0_POE2_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC0_POE2_enable_w                  ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC0_POE2_enable_h1                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC0_POE2_enable_b2                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC0_POE1_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC0_POE1_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC0_POE1_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC0_POE1_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC0_POE1_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC0_POE1_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC0_POE1_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC0_POE1_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC0_POE1_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC0_POE0_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC0_POE0_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC0_POE0_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC0_POE0_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC0_POE0_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC0_POE0_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC0_POE0_enable_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC0_POE0_enable_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC0_POE0_enable_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC2N_INV_mask_w                    ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC2N_INV_mask_h0                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC2N_INV_mask_b1                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC2N_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC2N_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC2N_INV_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC2N_INV_enable_w                  ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC2N_INV_enable_h0                 ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC2N_INV_enable_b1                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC1N_INV_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC1N_INV_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC1N_INV_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC1N_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC1N_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC1N_INV_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC1N_INV_enable_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC1N_INV_enable_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC1N_INV_enable_b1                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC0N_INV_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC0N_INV_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC0N_INV_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC0N_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC0N_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC0N_INV_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC0N_INV_enable_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC0N_INV_enable_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC0N_INV_enable_b1                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC3H_INV_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC3H_INV_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC3H_INV_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC3H_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC3H_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC3H_INV_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC3H_INV_enable_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC3H_INV_enable_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC3H_INV_enable_b0                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC2H_INV_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC2H_INV_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC2H_INV_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC2H_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC2H_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC2H_INV_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC2H_INV_enable_w                  ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC2H_INV_enable_h0                 ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC2H_INV_enable_b0                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC1H_INV_mask_w                    ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC1H_INV_mask_h0                   ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC1H_INV_mask_b0                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC1H_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC1H_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC1H_INV_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC1H_INV_enable_w                  ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC1H_INV_enable_h0                 ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC1H_INV_enable_b0                 ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC0H_INV_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC0H_INV_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC0H_INV_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC0H_INV_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC0H_INV_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC0H_INV_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC0H_INV_enable_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC0H_INV_enable_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC0H_INV_enable_b0                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC3_INV_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC3_INV_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC3_INV_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC3_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC3_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC3_INV_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC3_INV_enable_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC3_INV_enable_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC3_INV_enable_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC2_INV_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC2_INV_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC2_INV_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC2_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC2_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC2_INV_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC2_INV_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC2_INV_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC2_INV_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC1_INV_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC1_INV_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC1_INV_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC1_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC1_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC1_INV_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC1_INV_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC1_INV_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC1_INV_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_OCCR1_OC0_INV_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_OCCR1_OC0_INV_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_OCCR1_OC0_INV_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_OCCR1_OC0_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_OCCR1_OC0_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_OCCR1_OC0_INV_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_OCCR1_OC0_INV_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_OCCR1_OC0_INV_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_OCCR1_OC0_INV_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_PWM  [register's definitions]
 *              Offset[0x44]  TM Timer PWM and DTG control register
 ******************************************************************************
 */
///@{
#define TM_PWM_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_PWM */
#define TM_PWM_DTG_DY_mask_w                        ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define TM_PWM_DTG_DY_mask_h0                       ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define TM_PWM_DTG_DY_mask_b1                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define TM_PWM_DTG_DY_shift_w                       (8)                     /*!< Bit Shift of 32bit */
#define TM_PWM_DTG_DY_shift_h0                      (8)                     /*!< Bit Shift of 16bit */
#define TM_PWM_DTG_DY_shift_b1                      (0)                     /*!< Bit Shift of 8bit */

#define TM_PWM_PWM_MDS_mask_w                       ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define TM_PWM_PWM_MDS_mask_h0                      ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define TM_PWM_PWM_MDS_mask_b0                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define TM_PWM_PWM_MDS_edge_left_aligned_w          ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Edge Left-aligned of 32bit */
#define TM_PWM_PWM_MDS_edge_left_aligned_h0         ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Edge Left-aligned of 16bit */
#define TM_PWM_PWM_MDS_edge_left_aligned_b0         ((uint8_t )0x00)        /*!< Bit Value =(0x0):Edge Left-aligned of 8bit */
#define TM_PWM_PWM_MDS_center_aligned_w             ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Center-aligned of 32bit */
#define TM_PWM_PWM_MDS_center_aligned_h0            ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Center-aligned of 16bit */
#define TM_PWM_PWM_MDS_center_aligned_b0            ((uint8_t )0x01)        /*!< Bit Value =(0x1):Center-aligned of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_BS  [register's definitions]
 *              Offset[0x48]  TM Timer break and stop control register
 ******************************************************************************
 */
///@{
#define TM_BS_default                               ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_BS */
#define TM_BS_STP2N_STA_mask_w                      ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define TM_BS_STP2N_STA_mask_h1                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_BS_STP2N_STA_mask_b3                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_BS_STP2N_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_BS_STP2N_STA_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_BS_STP2N_STA_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_BS_STP2N_STA_1_w                         ((uint32_t)0x40000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_BS_STP2N_STA_1_h1                        ((uint16_t)0x4000)      /*!< Bit Value =(1):1 of 16bit */
#define TM_BS_STP2N_STA_1_b3                        ((uint8_t )0x40)        /*!< Bit Value =(1):1 of 8bit */

#define TM_BS_STP1N_STA_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define TM_BS_STP1N_STA_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define TM_BS_STP1N_STA_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_BS_STP1N_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_BS_STP1N_STA_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_BS_STP1N_STA_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_BS_STP1N_STA_1_w                         ((uint32_t)0x20000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_BS_STP1N_STA_1_h1                        ((uint16_t)0x2000)      /*!< Bit Value =(1):1 of 16bit */
#define TM_BS_STP1N_STA_1_b3                        ((uint8_t )0x20)        /*!< Bit Value =(1):1 of 8bit */

#define TM_BS_STP0N_STA_mask_w                      ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define TM_BS_STP0N_STA_mask_h1                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_BS_STP0N_STA_mask_b3                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_BS_STP0N_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_BS_STP0N_STA_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_BS_STP0N_STA_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_BS_STP0N_STA_1_w                         ((uint32_t)0x10000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_BS_STP0N_STA_1_h1                        ((uint16_t)0x1000)      /*!< Bit Value =(1):1 of 16bit */
#define TM_BS_STP0N_STA_1_b3                        ((uint8_t )0x10)        /*!< Bit Value =(1):1 of 8bit */

#define TM_BS_STP3_STA_mask_w                       ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define TM_BS_STP3_STA_mask_h1                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_BS_STP3_STA_mask_b3                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_BS_STP3_STA_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_BS_STP3_STA_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_BS_STP3_STA_0_b3                         ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_BS_STP3_STA_1_w                          ((uint32_t)0x08000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_BS_STP3_STA_1_h1                         ((uint16_t)0x0800)      /*!< Bit Value =(1):1 of 16bit */
#define TM_BS_STP3_STA_1_b3                         ((uint8_t )0x08)        /*!< Bit Value =(1):1 of 8bit */

#define TM_BS_STP2_STA_mask_w                       ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define TM_BS_STP2_STA_mask_h1                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_BS_STP2_STA_mask_b3                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_BS_STP2_STA_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_BS_STP2_STA_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_BS_STP2_STA_0_b3                         ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_BS_STP2_STA_1_w                          ((uint32_t)0x04000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_BS_STP2_STA_1_h1                         ((uint16_t)0x0400)      /*!< Bit Value =(1):1 of 16bit */
#define TM_BS_STP2_STA_1_b3                         ((uint8_t )0x04)        /*!< Bit Value =(1):1 of 8bit */

#define TM_BS_STP1_STA_mask_w                       ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define TM_BS_STP1_STA_mask_h1                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_BS_STP1_STA_mask_b3                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_BS_STP1_STA_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_BS_STP1_STA_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_BS_STP1_STA_0_b3                         ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_BS_STP1_STA_1_w                          ((uint32_t)0x02000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_BS_STP1_STA_1_h1                         ((uint16_t)0x0200)      /*!< Bit Value =(1):1 of 16bit */
#define TM_BS_STP1_STA_1_b3                         ((uint8_t )0x02)        /*!< Bit Value =(1):1 of 8bit */

#define TM_BS_STP0_STA_mask_w                       ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define TM_BS_STP0_STA_mask_h1                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_BS_STP0_STA_mask_b3                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_BS_STP0_STA_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define TM_BS_STP0_STA_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define TM_BS_STP0_STA_0_b3                         ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define TM_BS_STP0_STA_1_w                          ((uint32_t)0x01000000)  /*!< Bit Value =(1):1 of 32bit */
#define TM_BS_STP0_STA_1_h1                         ((uint16_t)0x0100)      /*!< Bit Value =(1):1 of 16bit */
#define TM_BS_STP0_STA_1_b3                         ((uint8_t )0x01)        /*!< Bit Value =(1):1 of 8bit */

#define TM_BS_BK3_CTL_mask_w                        ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define TM_BS_BK3_CTL_mask_h1                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_BS_BK3_CTL_mask_b2                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_BS_BK3_CTL_stop_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Stop of 32bit */
#define TM_BS_BK3_CTL_stop_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Stop of 16bit */
#define TM_BS_BK3_CTL_stop_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Stop of 8bit */
#define TM_BS_BK3_CTL_hold_w                        ((uint32_t)0x00800000)  /*!< Bit Value =(1):Hold of 32bit */
#define TM_BS_BK3_CTL_hold_h1                       ((uint16_t)0x0080)      /*!< Bit Value =(1):Hold of 16bit */
#define TM_BS_BK3_CTL_hold_b2                       ((uint8_t )0x80)        /*!< Bit Value =(1):Hold of 8bit */

#define TM_BS_BK2_CTL_mask_w                        ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define TM_BS_BK2_CTL_mask_h1                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define TM_BS_BK2_CTL_mask_b2                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_BS_BK2_CTL_stop_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Stop of 32bit */
#define TM_BS_BK2_CTL_stop_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Stop of 16bit */
#define TM_BS_BK2_CTL_stop_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Stop of 8bit */
#define TM_BS_BK2_CTL_hold_w                        ((uint32_t)0x00400000)  /*!< Bit Value =(1):Hold of 32bit */
#define TM_BS_BK2_CTL_hold_h1                       ((uint16_t)0x0040)      /*!< Bit Value =(1):Hold of 16bit */
#define TM_BS_BK2_CTL_hold_b2                       ((uint8_t )0x40)        /*!< Bit Value =(1):Hold of 8bit */

#define TM_BS_BK1_CTL_mask_w                        ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define TM_BS_BK1_CTL_mask_h1                       ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define TM_BS_BK1_CTL_mask_b2                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_BS_BK1_CTL_stop_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Stop of 32bit */
#define TM_BS_BK1_CTL_stop_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Stop of 16bit */
#define TM_BS_BK1_CTL_stop_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Stop of 8bit */
#define TM_BS_BK1_CTL_hold_w                        ((uint32_t)0x00200000)  /*!< Bit Value =(1):Hold of 32bit */
#define TM_BS_BK1_CTL_hold_h1                       ((uint16_t)0x0020)      /*!< Bit Value =(1):Hold of 16bit */
#define TM_BS_BK1_CTL_hold_b2                       ((uint8_t )0x20)        /*!< Bit Value =(1):Hold of 8bit */

#define TM_BS_BK0_CTL_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define TM_BS_BK0_CTL_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_BS_BK0_CTL_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_BS_BK0_CTL_stop_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Stop of 32bit */
#define TM_BS_BK0_CTL_stop_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Stop of 16bit */
#define TM_BS_BK0_CTL_stop_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Stop of 8bit */
#define TM_BS_BK0_CTL_hold_w                        ((uint32_t)0x00100000)  /*!< Bit Value =(1):Hold of 32bit */
#define TM_BS_BK0_CTL_hold_h1                       ((uint16_t)0x0010)      /*!< Bit Value =(1):Hold of 16bit */
#define TM_BS_BK0_CTL_hold_b2                       ((uint8_t )0x10)        /*!< Bit Value =(1):Hold of 8bit */

#define TM_BS_BKI_EN2_mask_w                        ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define TM_BS_BKI_EN2_mask_h1                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define TM_BS_BKI_EN2_mask_b2                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_BS_BKI_EN2_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKI_EN2_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKI_EN2_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKI_EN2_enable_w                      ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKI_EN2_enable_h1                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKI_EN2_enable_b2                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKI_EN1_mask_w                        ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define TM_BS_BKI_EN1_mask_h1                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define TM_BS_BKI_EN1_mask_b2                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_BS_BKI_EN1_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKI_EN1_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKI_EN1_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKI_EN1_enable_w                      ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKI_EN1_enable_h1                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKI_EN1_enable_b2                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKI_EN0_mask_w                        ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define TM_BS_BKI_EN0_mask_h1                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_BS_BKI_EN0_mask_b2                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_BS_BKI_EN0_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKI_EN0_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKI_EN0_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKI_EN0_enable_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKI_EN0_enable_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKI_EN0_enable_b2                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN7_mask_w                        ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN7_mask_h0                       ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN7_mask_b1                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN7_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN7_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN7_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN7_enable_w                      ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN7_enable_h0                     ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN7_enable_b1                     ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN6_mask_w                        ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN6_mask_h0                       ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN6_mask_b1                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN6_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN6_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN6_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN6_enable_w                      ((uint32_t)0x00004000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN6_enable_h0                     ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN6_enable_b1                     ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN5_mask_w                        ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN5_mask_h0                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN5_mask_b1                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN5_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN5_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN5_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN5_enable_w                      ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN5_enable_h0                     ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN5_enable_b1                     ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN4_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN4_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN4_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN4_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN4_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN4_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN4_enable_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN4_enable_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN4_enable_b1                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN3_mask_w                        ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN3_mask_h0                       ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN3_mask_b1                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN3_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN3_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN3_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN3_enable_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN3_enable_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN3_enable_b1                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN2_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN2_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN2_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN2_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN2_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN2_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN2_enable_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN2_enable_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN2_enable_b1                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN1_mask_w                        ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN1_mask_h0                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN1_mask_b1                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN1_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN1_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN1_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN1_enable_w                      ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN1_enable_h0                     ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN1_enable_b1                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKE_EN0_mask_w                        ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define TM_BS_BKE_EN0_mask_h0                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define TM_BS_BKE_EN0_mask_b1                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_BS_BKE_EN0_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKE_EN0_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKE_EN0_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKE_EN0_enable_w                      ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKE_EN0_enable_h0                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKE_EN0_enable_b1                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BKSW_EN_mask_w                        ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define TM_BS_BKSW_EN_mask_h0                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define TM_BS_BKSW_EN_mask_b0                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define TM_BS_BKSW_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BKSW_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BKSW_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BKSW_EN_enable_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BKSW_EN_enable_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BKSW_EN_enable_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BK_MDS_mask_w                         ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define TM_BS_BK_MDS_mask_h0                        ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define TM_BS_BK_MDS_mask_b0                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define TM_BS_BK_MDS_latch_mode_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Latch mode of 32bit */
#define TM_BS_BK_MDS_latch_mode_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Latch mode of 16bit */
#define TM_BS_BK_MDS_latch_mode_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Latch mode of 8bit */
#define TM_BS_BK_MDS_cycle_by_cycle_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Cycle by cycle of 32bit */
#define TM_BS_BK_MDS_cycle_by_cycle_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Cycle by cycle of 16bit */
#define TM_BS_BK_MDS_cycle_by_cycle_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Cycle by cycle of 8bit */

#define TM_BS_BK_EN3_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define TM_BS_BK_EN3_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define TM_BS_BK_EN3_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define TM_BS_BK_EN3_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BK_EN3_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BK_EN3_disable_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BK_EN3_enable_w                       ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BK_EN3_enable_h0                      ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BK_EN3_enable_b0                      ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define TM_BS_BK_EN_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define TM_BS_BK_EN_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define TM_BS_BK_EN_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define TM_BS_BK_EN_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define TM_BS_BK_EN_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define TM_BS_BK_EN_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define TM_BS_BK_EN_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define TM_BS_BK_EN_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define TM_BS_BK_EN_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC0A  [register's definitions]
 *              Offset[0x50]  TM Timer capture and compare register 0A
 ******************************************************************************
 */
///@{
#define TM_CC0A_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC0A */
#define TM_CC0A_CC0A_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC0A_CC0A_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC0A_CC0A_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC0A_CC0A_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC0A_CC0A_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC0B  [register's definitions]
 *              Offset[0x54]  TM Timer capture and compare register 0B
 ******************************************************************************
 */
///@{
#define TM_CC0B_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC0B */
#define TM_CC0B_CC0B_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC0B_CC0B_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC0B_CC0B_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC0B_CC0B_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC0B_CC0B_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC1A  [register's definitions]
 *              Offset[0x58]  TM Timer capture and compare register 1A
 ******************************************************************************
 */
///@{
#define TM_CC1A_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC1A */
#define TM_CC1A_CC1A_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC1A_CC1A_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC1A_CC1A_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC1A_CC1A_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC1A_CC1A_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC1B  [register's definitions]
 *              Offset[0x5c]  TM Timer capture and compare register 1B
 ******************************************************************************
 */
///@{
#define TM_CC1B_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC1B */
#define TM_CC1B_CC1B_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC1B_CC1B_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC1B_CC1B_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC1B_CC1B_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC1B_CC1B_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC2A  [register's definitions]
 *              Offset[0x60]  TM Timer capture and compare register 2A
 ******************************************************************************
 */
///@{
#define TM_CC2A_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC2A */
#define TM_CC2A_CC2A_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC2A_CC2A_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC2A_CC2A_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC2A_CC2A_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC2A_CC2A_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC2B  [register's definitions]
 *              Offset[0x64]  TM Timer capture and compare register 2B
 ******************************************************************************
 */
///@{
#define TM_CC2B_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC2B */
#define TM_CC2B_CC2B_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC2B_CC2B_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC2B_CC2B_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC2B_CC2B_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC2B_CC2B_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC3A  [register's definitions]
 *              Offset[0x68]  TM Timer capture and compare register 3A
 ******************************************************************************
 */
///@{
#define TM_CC3A_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC3A */
#define TM_CC3A_CC3A_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC3A_CC3A_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC3A_CC3A_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC3A_CC3A_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC3A_CC3A_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        TM_CC3B  [register's definitions]
 *              Offset[0x6c]  TM Timer capture and compare register 3B
 ******************************************************************************
 */
///@{
#define TM_CC3B_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of TM_CC3B */
#define TM_CC3B_CC3B_mask_w                         ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define TM_CC3B_CC3B_mask_h0                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define TM_CC3B_CC3B_shift_w                        (0)                     /*!< Bit Shift of 32bit */
#define TM_CC3B_CC3B_shift_h0                       (0)                     /*!< Bit Shift of 16bit */
#define TM_CC3B_CC3B_shift_b0                       (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32x02z_TM_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32x02z_TM.h                          */
/*----------------------------------------------------------------------------*/
