
/*
  USBSerial_API.h

  Copyright (c) 2023, Magawin
  Original code (pre-library): Copyright (c) 2011, Peter Barrett

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef   _USBSERIAL_API_H_
#define   _USBSERIAL_API_H_


#include <Arduino.h>

#include "MG32x02z.h" 


#if !defined(USBCON)   // || !defined(USBD_USE_HID_COMPOSITE)

#error "USB HID not enabled! Select 'HID' in the 'Tools->USB interface' menu."

#else

//================================================================================



#ifdef __cplusplus
#include "chip.h"
#endif

#include "MG32x02z_USBD_USBSerialDescriptor.h"
#include "MG32x02z_USBD_API.h"
 
// <<< Use Configuration Wizard in Context Menu >>>
//<o0> Bridge Device is  <0=> UART


#ifdef __cplusplus
 extern "C" {
#endif

 
// <<< Use Configuration Wizard in Context Menu >>>
//<o0> Bridge Device is  <0=> UART

#define API_COM_BRIDGE_DEVICE        1 

#define API_COM_BRIDGE_DEVICE_UART   ((API_COM_BRIDGE_DEVICE))


// <<< end of Configuration section >>>   
 
 
 
 
 /**
 * @name	============== CDC (Class Definitions for Communications Devices) protocal Relationship ==============
 *   		
 */ 
///@{     
    
//--------------------------------------------------------------------------------             
//Communications Class Subclass Codes                            
//    - Subclass codes for the Communications interface class

#define CDC_RESERVED                                0x00
#define CDC_DIRECT_LINE_CONTROL_MODEL               0x01        /*!< Reference USBPSTN1.2.*/
#define CDC_ABSTRACT_CONTROL_MODEL                  0x02        /*!< Reference USBPSTN1.2.*/
#define CDC_TELEPHONE_CONTROL_MODEL                 0x03        /*!< Reference USBPSTN1.2.*/
#define CDC_MULTI_CHANNEL_CONTROL_MODEL             0x04        /*!< Reference USBPSTN1.2.*/
#define CDC_CAPI_CONTROL_MODEL                      0x05        /*!< Reference USBISDN1.2.*/
#define CDC_ETHERNET_NETWORKING_CONTROL_MODEL       0x06        /*!< Reference USBISDN1.2.*/
#define CDC_ATM_NETWORKING_CONTROL_MODEL            0x07        /*!< Reference USBECM1.2.*/
#define CDC_WIRELESS_HANDSET_CONTROL_MODEL          0x08        /*!< Reference USBATM1.2.*/
#define CDC_DEVICE_MANAGEMENT                       0x09        /*!< Reference USBWMC1.1.*/
#define CDC_MOBILE_DIRECT_LINE_MODEL                0x0A        /*!< Reference USBWMC1.1.*/
#define CDC_OBEX                                    0x0B        /*!< Reference USBWMC1.1.*/
#define CDC_ETHERNET_EMULATION_MODEL                0x0C        /*!< Reference USBEEM1.0.*/
#define CDC_NETWORK_CONTROL_MODEL                   0x0D        /*!< Reference USBNCM1.0.*/
    
//---------------------------------------------------
//Communication Interface Class Control Protocol Codes 
#define USBSPEC                                     0x00        /*!< No class specific protocol required .*/
#define CDC_AT_ITU_T_V_250                          0x01        /*!< AT Commands V.250 etc.*/
#define CDC_AT_PCCA_101                             0x02        /*!< AT Commands defined by PCCA-101.*/
#define CDC_AT_PCCA_101_AnnexO                      0x03        /*!< AT Commands defined by PCCA-101 & Annex O.*/
#define CDC_AT_GSM_7_07                             0x04        /*!< AT Commands defined by GSM 07.07.*/
#define CDC_AT_3GPP_27_07                           0x05        /*!< AT Commands defined by 3GPP 27.007.*/
#define CDC_AT_C_S0017_0                            0x06        /*!< AT Commands defined by TIA for CDMA.*/
#define CDC_USB_EEM                                 0x07        /*!< Ethernet Emulation Model*/
#define CDC_ExternalProtocol                        0xFE        /*!< External Protocol : Commands defiend by Command Set Functional Descriptor*/
#define CDC_VENDOR_SPEC                             0xFF        /*!< Vendor-specific*/
    
    
    
//-------------------------------------------------------------------------------- 
//Data Interface Class Code      
#define bInterfaceClass_CDC_DATA                    0x0A       
    
    
    
//-------------------------------------------------------------------------------- 
//Data Interface Class Protocol Codes

#define CDC_DATA_USBSPEC                            0x00         /*!< No class specific protocol required.*/
#define CDC_DATA_USBNCM1_0                          0x01         /*!< Network Transfer Block.*/
#define CDC_DATA_I_430                              0x30         /*!< Physical interface protocol for ISDN BRI.*/
#define CDC_DATA_ISO_IEC_3309_1993                  0x31         /*!< HDLC.*/
#define CDC_DATA_NONE_TRANSPARENT                   0x32         /*!< Transparent.*/
#define CDC_DATA_Q_921M                             0x50         /*!< Management protocol for Q.921 data link protocol.*/
#define CDC_DATA_Q_921                              0x51         /*!< Data link protocol for Q.931.*/
#define CDC_DATA_Q_921TM                            0x52         /*!< TEI-multiplexor for Q.921 data link protocol.*/
#define CDC_DATA_V_42BIS                            0x90         /*!< Data compression procedures.*/
#define CDC_DATA_Q_931_EURO_ISDN                    0x91         /*!< Euro-ISDN protocol control.*/
#define CDC_DATA_V_120                              0x92         /*!< V.24 rate adaptation to ISDN.*/
#define CDC_DATA_CAPI2_0                            0x93         /*!< CAPI Commands.*/
#define CDC_DATA_NONE_HOST_BASED_DRIVER             0xFD         
#define CDC_DATA_CDCSPEC                            0xFE         /*!< The protocol(s) are described using a Protocol Unit Functional Descriptors on Communications Class Interface.*/
#define CDC_DATA_VENDOR_SPEC                        0xFF         /*!< Vendor-specific.*/
    

//----------------------------------------------------------------------------------
//bDescriptor SubType in Communications Class Functional Descriptor
//   - The bDescriptor Type values are the same ones defined in the USB Device Class
//     Definition for Audio Devices Specification.
#define HEADER_FUNCTIONAL_DESCRIPTOR                                                  0x00     /*!< Header Function Descriptor , which marks the beginning of the concatenated set of  
                                                                                                    functional descriptos for the interface.*/
#define CALL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                                         0x01     /*!< Call Management Functional Descriptor.*/
#define ABSTRACT_CONTROL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                             0x02     /*!< Abstract Control Management Functional Descriptor.*/
#define DIRECT_LINE_MANAGEMENT_FUNCITIONAL_DESCRIPTOR                                 0x03     /*!< Direct Line Management Functional Descriptor.*/
#define TELEPHONE_RINGER_FUNCTIONAL_DESCRIPTOR                                        0x04     /*!< Telephone Ringer Functional Descriptor.*/
#define TELEPHONE_CALL_LINE_STATE_REPORTING_CAPABILITIES_FUNCITIONAL_DESCRIPTOR       0x05     /*!< Telephone Call and Line State Reporting Capabilities Functional Descriptor.*/
#define UNION_FUNCTIONAL_DESCRIPTOR                                                   0x06     /*!< Uion Functional Descriptor.*/
#define COUNTRY_SELECTION_FUNCTIONAL_DESCRIPTOR                                       0x07     /*!< Country Selection Functional Descriptor.*/
#define TELEPHONE_OPERATIONAL_MODES_FUNCTIONAL_DESCRIPTOR                             0x08     /*!< Telephone Operational Modes Functional Descriptor.*/
#define USB_TERMINAL_FUNCTIONAL_DESCRIPTOR                                            0x09     /*!< USB Terminal Functional Descriptor.*/
#define NETWORK_CHANNEL_TERMINAL_DESCRIPTOR                                           0x0A     /*!< Network Channel Terminal Descriptor.*/
#define PROTOCOL_UNIT_FUNCTIONAL_DESCRIPTOR                                           0x0B     /*!< Protocol Unit Functional Descriptor.*/
#define EXTENSION_UNIT_FUNCTIONAL_DESCRIPTOR                                          0x0C     /*!< Extension Unit Functional Descriptor.*/
#define MULTI_CHANNEL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                                0x0D     /*!< Multi-Channel Management Functional Descriptor.*/
#define CAPI_CONTROL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                                 0x0E     /*!< CAPI Control Management Functional Descriptor.*/
#define ETHERNET_NETWORKING_FUNCTIONAL_DESCRIPTOR                                     0x0F     /*!< Ethernet Networking Functional Descriptor.*/
#define ATM_NETWORKING_FUNCTIONAL_DESCRIPTOR                                          0x10     /*!< ATM Networking Functional Descriptor.*/
#define WIRELESS_HANDSET_CONTROL_MODEL_FUNCTIONAL_DESCRIPTOR                          0x11     /*!< Wireless Handset Control Model Functional Descriptor.*/    
#define MOBILE_DIRECT_LINE_MODEL_FUNCTIONAL_DESCRIPTOR                                0x12     /*!< Mobile Direct Line Model Functional Descriptor.*/
#define MDLM_DETAIL_FUNCTIONAL_DESCRIPTOR                                             0x13     /*!< MDLM Detail Functional Descriptor.*/
#define DEVICE_MANAGEMENT_MODEL_FUNCTIONAL_DESCRIPTOR                                 0x14     /*!< Device Management Model Functional Descriptor.*/
#define OBEX_FUNCTIONAL_DESCRIPTOR                                                    0x15     /*!< OBEX Functional Descriptor*/
#define COMMAND_SET_FUNCTIONAL_DESCRIPTOR                                             0x16     /*!< Command Set Functional Descriptor.*/
#define COMMAND_SET_DETAIL_FUNCTIONAL__DESCRIPTOR                                     0x17     /*!< Command Set Detail Functional Descriptor.*/
#define TELEPHONE_CONTROL_MODEL_FUNCTIONAL_DESCRIPTOR                                 0x18     /*!< Teltphone Control Model Functional Descriptor.*/
#define OBEX_SERVICE_IDENTIFIER_FUNCTIONAL_DESCRIPTOR                                 0x19     /*!< OBEX Service Identifier Functional Descriptor.*/
#define NCM_FUNCTIONAL_DESCRIPTOR                                                     0x1A     /*!< NVM Functional Descriptor.*/


//----------------------------------------------------------------------------------
//Class-Specific Request Codes.
#define SEND_ENCAPSULATED_COMMAND                     0x00                 /*!< Reference CDC120 6.2.1 */
#define GET_ENCAPSULATED_RESPONSE                     0x01                 /*!< Reference CDC120 6.2.1 */
#define SET_COMM_FEATURE                              0x02                 /*!< Reference USBPSTN1.2   */
#define GET_COMM_FEATURE                              0x03                 /*!< Reference USBPSTN1.2   */
#define CLEAR_COMM_FEATURE                            0x04                 /*!< Reference USBPSTN1.2   */
#define SET_AUX_LINE_STATE                            0x10                 /*!< Reference USBPSTN1.2   */
#define SET_HOOK_STATE                                0x11                 /*!< Reference USBPSTN1.2   */
#define PULSE_SETUP                                   0x12                 /*!< Reference USBPSTN1.2   */
#define SEND_PULSE                                    0x13                 /*!< Reference USBPSTN1.2   */
#define SET_PULSE_TIME                                0x14                 /*!< Reference USBPSTN1.2   */
#define PING_AUX_JACK                                 0x15                 /*!< Reference USBPSTN1.2   */
#define SET_LINE_CODING                               0x20                 /*!< Reference USBPSTN1.2   */
#define GET_LINE_CODING                               0x21                 /*!< Reference USBPSTN1.2   */
#define SET_CONTROL_LINE_STATE                        0x22                 /*!< Reference USBPSTN1.2   */
#define SET_BREAK                                     0x23                 /*!< Reference USBPSTN1.2   */
#define SET_RINGER_PARMS                              0x30                 /*!< Reference USBPSTN1.2   */
#define GET_RINGER_PARMS                              0x31                 /*!< Reference USBPSTN1.2   */
#define SET_OPERATION_PARMS                           0x32                 /*!< Reference USBPSTN1.2   */
#define GET_OPERATION_PARMS                           0x33                 /*!< Reference USBPSTN1.2   */
#define SET_LINE_PARMS                                0x34                 /*!< Reference USBPSTN1.2   */
#define GET_LINE_PARMS                                0x35                 /*!< Reference USBPSTN1.2   */
#define DIAL_DIGITS                                   0x36                 /*!< Reference USBPSTN1.2   */
#define SET_UNIT_PARAMETER                            0x37                 /*!< Reference USBISDN1.2   */
#define GET_UNIT_PARAMETER                            0x38                 /*!< Reference USBISDN1.2   */
#define CLEAR_UNIT_PARAMETER                          0x39                 /*!< Reference USBISDN1.2   */
#define GET_PROFILE                                   0x3A                 /*!< Reference USBISDN1.2   */
#define SET_ETHERNET_MULTICAST_FILTERS                0x40                 /*!< Reference USBECM1.2    */
#define SET_ETHERNET_POWER_MANAGEMENT_PATTERN_FILTER  0x41                 /*!< Reference USBECM1.2    */
#define GET_ETHERNET_POWER_MANAGEMENT_PATTERN_FILTER  0x42                 /*!< Reference USBECM1.2    */
#define SET_ETHERNET_PACKET_FILTER                    0x43                 /*!< Reference USBECM1.2    */
#define GET_ETHERNET_STATISTIC                        0x44                 /*!< Reference USBECM1.2    */
#define SET_ATM_DATA_FORMAT                           0x50                 /*!< Reference USBATM1.2    */
#define GET_ATM_DEVICE_STATISTICS                     0x51                 /*!< Reference USBATM1.2    */
#define SET_ATM_DEFAULT_VC                            0x52                 /*!< Reference USBATM1.2    */
#define GET_ATM_VC_STATISTICS                         0x53                 /*!< Reference USBATM1.2    */
#define GET_NTB_PARAMETERS                            0x80                 /*!< Reference USBNCM1.0    */
#define GET_NET_ADDRESS                               0x81                 /*!< Reference USBNCM1.0    */
#define SET_NET_ADDRESS                               0x82                 /*!< Reference USBNCM1.0    */
#define GET_NTB_FORMAT                                0x83                 /*!< Reference USBNCM1.0    */
#define SET_NTB_FORMAT                                0x84                 /*!< Reference USBNCM1.0    */
#define GET_NTB_INPUT_SIZE                            0x85                 /*!< Reference USBNCM1.0    */
#define SET_NTB_INPUT_SIZE                            0x86                 /*!< Reference USBNCM1.0    */
#define GET_MAX_DATAGRAM_SIZE                         0x87                 /*!< Reference USBNCM1.0    */
#define SET_MAX_DATAGRAM_SIZE                         0x88                 /*!< Reference USBNCM1.0    */
#define GET_CRC_MODE                                  0x89                 /*!< Reference USBNCM1.0    */
#define SET_CRC_MODE                                  0x8A                 /*!< Reference USBNCM1.0    */
    
    
//----------------------------------------------------------------------------------    
// Class-Specific Notification Codes for PSTN subclasses.
#define PSTN_NETWORK_CONNECTION                       0x00                 
#define PSTN_RESPONSE_AVAILABLE                       0x01                 /*!< This notification allows the device to notify the host a response is available.*/
#define PSTN_AUX_JACK_HOOK_STATE                      0x08                 /*!< This notification indicates the loop has changed on the auxiliary phone interface of the USB device.*/
#define PSTN_RING_DETECT                              0x09                 /*!< This notification indicates ring voltage on the POTS line interface of the USB device.*/
#define PSTN_SERIAL_STATE                             0x20                 /*!< This notification sends asynchronous notification of UART status.*/
#define PSTN_CALL_STATE_CHANGE                        0x28                 /*!< This notification identifies that a change has occurred to the state of a call on the line corresponding to
                                                                                the interface or union for the line*/
#define PSTN_LINE_STATE_CHANGE                        0x23                 /*!< This notification identifies that a change has occurred to the state of the line corresponding to the interface or 
                                                                                master interface of a union sending the notification message.*/

    
    
///@}  
 
 
/**
 * @name	============== Line Coding Relationship ==============
 *   		
 */ 
///@{ 
 

#define COM_STOPBIT_1_0           0                                /*!< 1   Stop bit  .*/
#define COM_STOPBIT_1_5           1                                /*!< 1.5 Stop bits .*/
#define COM_STOPBIT_2_0           2                                /*!< 2   Stop bits .*/
                                                                   
#define COM_PARITY_None           0                                /*!< Parity = None  .*/
#define COM_PARITY_Odd            1                                /*!< Parity = Odd   .*/
#define COM_PARITY_Even           2                                /*!< Parity = Even  .*/
#define COM_PARITY_Mark           3                                /*!< Parity = Mark  .*/
#define COM_PARITY_Space          4                                /*!< Parity = Space .*/


#define COM_SUCCESS               0
#define COM_FAILURE               1


/** 
 * @struct	COM_LineCoding_TypeDef
 * @brief	character formatting properties.
 */
typedef struct
{    
    uint8_t    Flag;                                                /*!< Set by Host setting occur .*/
    uint8_t    StopBit;                                             /*!< Stop bit.*/
    uint8_t    Parity;                                              /*!< Parity bit type.*/
    uint8_t    DataBit;                                             /*!< Data bits.*/
    ctype      BaudRate;                                            /*!< Data terminal rate ,in bits per second.*/
}COM_LineCoding_TypeDef;



/**
 * @name	============== Line State Relationship ==============
 *   		
 */ 
///@{


/** 
 * @struct	COM_LineState_TypeDef
 * @brief	Control Signal Bitmap struct.
 */
typedef struct
{    
    uint8_t   Flag;                                                   /*!< The flag is that receive SetControlLineState request.*/
    uint8_t   __Padding;                                              /*!< Reserved byte.*/
    union
    {
        __IO uint16_t  H;
        __IO uint8_t   B[2];
        struct
        {
            __IO uint8_t DTE_EN               : 1;                    /*!< Indicates to DCE if DTE is present or not. This signal corresponds to V.24 signal 108/2 and RS-232 signal DTR.
                                                                               0 - Not Present.
                                                                               1 - Present.
                                                                      */
            __IO uint8_t CarrierControl_EN    : 1;                    /*!< Carrier control for half duplex moderns. This signal corresponds to V.24 signal 105 and RS-232 siganl RTS.
                                                                               0 - Deactivate carrier
                                                                               1 - Activate carrier
                                                                           The device ignores the value of this bit when operating in full duplex mode.
                                                                      */
            __IO uint8_t                      : 6;                    /*! RESERVED (Reset to zero) .*/
            __IO uint8_t                      : 8;                    /*! RESERVED (Reset to zero) .*/
        }MBIT;
    }ControlSignalBitmp;
}COM_LineState_TypeDef;



/**
 * @name	============== Break Relationship ==============
 *   		
 */ 
///@{


/** 
 * @struct	COM_SendBreak_TypeDef
 * @brief	SendBreak request. 
 */
typedef struct
{    
    uint8_t   Flag;                                                    /*!< The flag is that receive SEND_BREAK request.*/
    uint8_t   __Padding;                                               /*!< Reserved byte.*/
    union
    {
        __IO uint16_t  H;
        __IO uint8_t   B[2];
    }DurationTime;                                                     /*!< The value field contains the length of time , in milliseconds , of the break singal.
                                                                            If the value contains a value of FFFFh, then the device will send a break until another 
                                                                            SendBreak request is received with the value of 0000h.
                                                                       */
}COM_SendBreak_TypeDef;

void API_COM_SendBreak(uint8_t* SendBreakBuf); 

/**
 * @name	========== PSTN Subclass Specific Notifications (SerialState)==============
 *   		
 */ 
///@{
#if API_COM_BRIDGE_DEVICE == API_COM_BRIDGE_DEVICE_UART


#define PSTN_URT_bRxCarrier                 0x01                       /*!< State of receiver carrier detection mechanism of device.
                                                                            This signal corresponds to V.24 signal 109 and RS-232 signal DCD.*/
#define PSTN_URT_bTxCarrier                 0x02                       /*!< State of transmission carrier.
                                                                            This signal corresponds to V.24 signal 106 and RS-232 signal DSR.*/
#define PSTN_URT_bBrek                      0x04                       /*!< State of break detection mechanism of the device.*/
#define PSTN_URT_bRingSignal                0x08                       /*!< State of ring signal detection of the device.*/
#define PSTN_URT_bFraming                   0x10                       /*!< A framing error has occurred.*/
#define PSTN_URT_bParity                    0x20                       /*!< A parity error has occurred.*/
#define PSTN_URT_bOverRun                   0x40                       /*!< Received data has been discarded due to overrun in the device.*/

#endif

//@}


/**
 * @name	============== COM Control Relationship ==============
 *   		
 */ 
///@{

/** 
 * @struct	COM_TypeDef
 * @brief	COM Control Relationship Parameter.
 */

typedef struct
{    
    volatile uint8_t       COM_USB_StatusUpstream_Busy;            /*!< The flag is that the device is transmitting COM status .*/
                           
    volatile uint8_t       COM_USB_DataUpstream_Busy;              /*!< The flag is that the device is transmitting data to USB. */
    volatile uint8_t       COM_USB_DataUpstream_OverrunFlag;       /*!< The flag is that the device software RX buffer overflow.*/
                           
    volatile uint8_t       COM_USB_DataDownstream_Busy;            /*!< The flag is that the device is transmitting data to URT*/
    volatile uint32_t      COM_USB_DataDownstream_Size;            /*!< The URT TX transmit data size in this time.*/
    
    COM_LineCoding_TypeDef LineCoding;                             /*!< Line coding relationship parameter.*/
    COM_LineState_TypeDef  LineState;                              /*!< Line state relationship parameter.*/
    COM_SendBreak_TypeDef  SendBreak;                              /*!< Send break relationship parameter*/
    
#if API_COM_BRIDGE_DEVICE == API_COM_BRIDGE_DEVICE_UART
    uint8_t                COM_Status_EP_SRAM[10];                 /*!< Serial state save SRAM address.*/
    uint8_t                Status;                                 /*!< Serial state */
    uint8_t                __Padding[1];                           /*!< Reserved byte.*/
#endif
    
    
}COM_TypeDef;


extern COM_TypeDef COM;

//void MCU_Init(void);
//void API_COM_Init(void);                                            /*!< COM inital function.*/
//void API_USBD_COM_main(void);                                       /*!< COM main function.*/

//void      API_COM_GetLineCoding(uint8_t* gLineCodingBuf);
//uint32_t  API_COM_SetLineCoding(uint8_t* sLineCodingBuf);
//void API_COM_SetControlLineState(uint8_t* sControlLineStateBuf);
//void API_COM_ReceiveDownstreamData(void);                           /*!< COM receive downstream data function.*/

//@}

void API_UsbSerial_SetUARTState(void);

void API_UsbSerial_ReceiveDownstreamData(void);
void API_UsbSerial_SetDataUpstream_Busy( uint8_t State );
void API_UsbSerial_SetUpstreamBusyStatue( uint8_t State );
void API_UsbSerial_SetDownstreamBusyStatue( uint8_t State );
void API_UsbSerial_GetLineCoding(uint8_t* gLineCodingBuf);
void API_UsbSerial_SetControlLineState(uint8_t* sControlLineStateBuf);
void API_UsbSerial_SendBreak(uint8_t* SendBreakBuf);
uint32_t API_UsbSerial_SetLineCoding(uint8_t* sLineCodingBuf);





void UsbSerial_SetAPIDefault(void);
int API_UsbSerial_IsEmulationOK(void);





#ifdef __cplusplus
}
#endif




#endif  //#if !defined(USBCON)

#endif  //#ifndef   _USBSERIAL_API_H_