#ifndef _WDT_H_
#define _WDT_H_

#include "MG32x02z_DRV.h"

#define WDTO_15MS     IWDT_DIV_2
#define WDTO_30MS     IWDT_DIV_4
#define WDTO_60MS     IWDT_DIV_8
#define WDTO_120MS    IWDT_DIV_16
#define WDTO_250MS    IWDT_DIV_32
#define WDTO_500MS    IWDT_DIV_64
#define WDTO_1S       IWDT_DIV_128
#define WDTO_2S       IWDT_DIV_256
#define WDTO_4S       IWDT_DIV_512
#define WDTO_8S       IWDT_DIV_1024


#define wdt_reset()  {IWDT_ClearFlag(IWDT_TF); IWDT_RefreshCounter();}


void wdt_disable (void);
void wdt_enable (const uint8_t value);

void wdt_disableRST (void);
void wdt_enableRST (void);



#endif
