# EEPROM

#### Emulation of Arduino EEPROM in chip's IAP flash

If you call `EEPROM.toNVS()`, a copy of your EEPROM data will be save to the key "eeprom" in NVS flash, exactly like when you would use the original `EEPROM.h`. You can also manually revert to the last save by calling `EEPROM.fromNVS()`.

The function `EEPROM.wasRestored()` will tell you whether or not the contents were automaticcaly restored from NVS in this boot cycle.


### Details

* This library will always claim `EEPROM_SIZE` (set at 512, change in the .h file) bytes of the IAP Flash. You can set a lower number when calling `EEPROM.begin()`, but that number only  limits what your code can read/write, not the actual flash used.

* Cannot repeat it often enough: **only useful in combination with the ESP's deep sleep, data in this fake EEPROM does not survive powercycling, resetting or reflashing** 
