

 /**
 ******************************************************************************
 *
 * @file        USBD_Core.h
 * @brief       The USBD core Code's h file.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2022/01/12
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
#ifndef _MG32X02Z_USBD_API_H_
#define _MG32X02Z_USBD_API_H_



#ifdef __cplusplus
extern "C" {
#endif



#include "MG32x02z.h"
#include "MG32x02z__ExtraStruct.h"
#include "MG32x02z_PW_DRV.h"
#include "MG32x02z_SYS_DRV.h"
#include "MG32x02z_MEM_DRV.h"
#include "MG32x02z_USB_DRV.h"
//#include "MG32x02z_USB_Init.h"


typedef struct  
{
    uint8_t             Status;              
    uint8_t             IdleRate;
    uint8_t             Protocol;
    uint8_t             padding;


    uint16_t  mHID0_ReportLength;                    /*!< HID0 report size */
    uint16_t  mHID1_ReportLength;                    /*!< HID0 report size */
    const uint8_t*  pUSB_INTERFACE0_HID_REPORT;           /*!< HID report of interface0.*/
    const uint8_t*  pUSB_INTERFACE1_HID_REPORT;           /*!< HID report of interface0.*/


    const uint8_t*  pUSB_DEVICE_DESCRIPTOR;               /*!< Device Descriptor.*/
    const uint8_t*  pUSB_CONFIGURATION_DESCRIPTOR;        /*!< Configuration Descriptor.*/
    const uint8_t*  pUSB_STRING_DESCRIPTOR;               /*!< String descriptor.*/

    //#if MF_STRING == 1                                          
    const uint8_t*  pManufacturer_Descriptor;             /*!< Manufacture string descriptor.*/
    //#endif      
   // #if PD_STRING == 1                                          
    const uint8_t*  pProduct_Descriptor;                  /*!< Product string descriptor.*/
    //#endif   
    //#if SN_STRING == 1                                          
    const uint8_t*  pSerialNumber_Descriptor;             /*!< Serial number string descriptor.*/
    //#endif 

    //#if MG_USB_LPM_EN == 1                                      
    const uint8_t*  pUSB_BOS_DESCRIPTOR;                  /*!< BOS descriptor.*/
    const uint8_t*  pUSB_EXT_DESCRIPTOR;                  /*!< Device capabilty descriptor.*/
    //#endif

}USBState_TypeDef;


extern USBState_TypeDef  g_UsbEP1Ctr;



typedef void F_USB_CallbackFun(void);

typedef void F_USB_ReadEndpointData(        USB_EP_Struct* EPX, uint8_t *bRBuffer ,     uint32_t bRXShift , uint32_t bRXCnt);
typedef void F_USB_WriteEndpointData(       USB_EP_Struct* EPX, uint8_t __I *btBuffer , uint32_t bTXShift , uint8_t bTXCnt );
typedef void F_USB_WriteEndpointConstData(  USB_EP_Struct* EPX, uint8_t ConstData ,     uint32_t cTXShift , uint8_t cTXCnt );
typedef void F_USB_WriteEndpointSingleData( USB_EP_Struct* EPX, uint8_t sData ,         uint8_t shift);

typedef struct _ST_USB_FUN
{
    F_USB_CallbackFun*  pfUsbInit;
    F_USB_CallbackFun*  pfEP0ReadData;
    F_USB_CallbackFun*  pfGetStatus;
    F_USB_CallbackFun*  pfClearFeature;
    F_USB_CallbackFun*  pfSetFeature;
    F_USB_CallbackFun*  pfGetDescriptor;
    F_USB_CallbackFun*  pfSetConfiguration;
    F_USB_CallbackFun*  pfSetInterface;
    F_USB_CallbackFun*  pfGetInterface;
    F_USB_CallbackFun*  pfControlRead;
    F_USB_CallbackFun*  pfStandardRequest;
    F_USB_CallbackFun*  pfClassRequest;
    F_USB_CallbackFun*  pfControlWrite;

    F_USB_ReadEndpointData*  pfReadEndpointData;
    F_USB_WriteEndpointData*  pfWriteEndpointData;
    F_USB_WriteEndpointConstData*  pfWriteEndpointConstData;
    F_USB_WriteEndpointSingleData*  pfWriteEndpointSingleData;

    F_USB_CallbackFun*  pfStateEvent;
    F_USB_CallbackFun*  pfIRQHandler;
}ST_USB_FUN;
extern ST_USB_FUN  g_UsbFun;



/*Mouse Status*/
#define USBA_Status_Idle                0x00                       /*!< Mouse state is idle*/
#define USBA_Status_Init                0x80                       /*!< Mouse state is initializing.*/
#define USBA_Status_UpdateReport        0x40                       /*!< Mouse update data to host.*/
#define USBA_Status_BNTReportChange     0x01                       /*!< Mouse button data of report change.*/
#define USBA_Status_SensorReportChange  0x02                       /*!< Mouse sensor data of report change.*/
#define USBA_Status_WheelReportChange   0x04                       /*!< Mouse wheel data of report change.*/

#define USBA_Status_ReportChange        (USBA_Status_BNTReportChange    | \
                                         USBA_Status_SensorReportChange | \
                                         USBA_Status_WheelReportChange)           /*Mouse report data change mask*/

#define    HIBYTE( V1 )     ((uint8_t)((V1) >> 8))                           /*!<Get high byte (8 ~ 15 bit) of 16 bit data.*/
#define    LOBYTE( V1 )     ((uint8_t)((V1) & 0xFF))                         /*!<Get low byte (8 ~ 15 bit) of 16 bit data.*/







void USB_SetAPIDefault(void);
void USB_IRQHandler(void);
void Usb_StateHandler(void);




void API_USBD_Inital(void);
void API_USBD_ReadEndpointData( USB_EP_Struct* EPX, uint8_t *bRBuffer , uint32_t bRXShift , uint32_t bRXCnt);
void API_USBD_WriteEndpointData( USB_EP_Struct* EPX, uint8_t __I *btBuffer , uint32_t bTXShift , uint8_t bTXCnt );
void API_USBD_WriteEndpointConstData( USB_EP_Struct* EPX, uint8_t ConstData , uint32_t cTXShift , uint8_t cTXCnt );
void API_USBD_WriteEndpointSingleData( USB_EP_Struct* EPX, uint8_t sData , uint8_t shift);




#ifdef __cplusplus
}
#endif

#endif