/**
 ******************************************************************************
 *
 ******************************************************************************
 * @file    uaet.H
 * @author  cuij
 * @version V1.0.0
 * @date    11-02-2023
 * @brief   The  code is that use adapted to Arduino interface
 *
 * @par         Project
 *              MG32x02z
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
  ******************************************************************************
  Copyright (c) 2023 megawin Technology Co., Ltd. All rights reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __UART_H
#define __UART_H

/* Includes ------------------------------------------------------------------*/
//#include "variant.h"
#include "MG32x02z.h"
#include "system_MG32x02z.h"

#ifdef __cplusplus
 extern "C" {
#endif

/* Exported types ------------------------------------------------------------*/
/*
    URT0_IRQn
    URT123_IRQn
    URT4x_IRQn
*/

typedef enum {
  USART0_E = 0,
  USART1_E,
  USART2_E,
#if defined(URT3)
  USART3_E,
#endif
  USART4_E ,
  USART5_E,
  USART6_E,
  USART7_E,
  NB_UART_MANAGED,
} uart_id_e;




/* Exported constants --------------------------------------------------------*/

/* Exported macro ------------------------------------------------------------*/


/* Exported functions ------------------------------------------------------- */
void megawin_Uart_init(void);


#ifdef __cplusplus
}
#endif

#endif /* __UART_H */


/*********COPYRIGHT(c) 2022 megawin Technology Co., Ltd *****END OF FILE****/
