/**************************************************************************************************
* Flash and EEPROM support unlimited reading of their data, 
* but limit the number of times data can be written.
* EEPROM has a limit on the number of write operations, 
* so be careful not to place the write operation in the loop or other loop executing functions.
**************************************************************************************************/
/**************************************************************************************************
*      The TH244A(mcu :MG32F02U128) internal 128K bytes of FLASH program memory,
* built-in control logic that simulates FLASH as EEPROM
* (It can be set range from 0.5K bytes to 8K bytes ), 
* part of the program FLASH can be divided into data FLASH space according to application needs, 
* and EEPROM-like interface access is realized through the EEPROM controller.
*       When you include library - EEPROM.h in your ino project,
*  as default,you can use 512 bytes flash space as EEPROM fuction.
*/
/**************************************************************************************************
* If you need more EEPROM space, you need to modify the definition of 
* a specified macro: EEPROM_SIZE in library EEPROM.h file. 
* Can't support define EEPROM_SIZE in Arduino sketch .ino file.
* (EEPROM.h file PATH refer to:
*  ......\Arduino15\packages\megawin\hardware\MG32x02z\2.3.0\libraris\EEPROM\src)
* Support set EEPROM_SIZE range from 0.5K to 8K in increments of 0.5K bytes.
* Here the default setting is 512 bytes. You can modify the value to other as following list.
* Unspecify comments when you need to compile.
**************************************************************************************************/
//====Need to modify the definition of a specified macro: EEPROM_SIZE in library //EEPROM.h file.
// Can't  support define EEPROM_SIZE in Arduino sketch .ino file.
//================Support EEPROM_SIZE list begin. =======================
//#define EEPROM_SIZE 512   //default set EEPROM 0.5K   512 bytes
//#define EEPROM_SIZE 1024  // set EEPROM 1K   1024 bytes
//#define EEPROM_SIZE 1536  // set EEPROM 1.5K   1536 bytes
//#define EEPROM_SIZE 2048  // set EEPROM 2K   2048 bytes
//#define EEPROM_SIZE 2560  // set EEPROM 2.5K   2560 bytes
//#define EEPROM_SIZE 3072  // set EEPROM 3K   3072 bytes
//#define EEPROM_SIZE 3584  // set EEPROM 3.5K   3584 bytes
//#define EEPROM_SIZE 4096  // set EEPROM 4K   4096 bytes
//#define EEPROM_SIZE 4608  // set EEPROM 4.5K   4608 bytes
//#define EEPROM_SIZE 5120  // set EEPROM 5K   5120 bytes
//#define EEPROM_SIZE 5632  // set EEPROM 5.5K   5632 bytes
//#define EEPROM_SIZE 6144  // set EEPROM 6K   6144 bytes
//#define EEPROM_SIZE 6656  // set EEPROM 6.5K   6656 bytes
//#define EEPROM_SIZE 7168  // set EEPROM 7K   7168 bytes
//#define EEPROM_SIZE 7680  // set EEPROM 7.5K   7680 bytes
//#define EEPROM_SIZE 8192  // set EEPROM 8K   8192 bytes
//===========Support EEPROM_SIZE list end============

/*
Single byte read and write  : EEPROM.read(address);        EEPROM.write(address, byte)
Multi bytes read and write  : EEPROM.get(address,data);   EEPROM.put(address,data)
EEPROM.commit();  Submit to save data from the temporary storage area to flash, achieving power-off protection
Here, store char data(1 byte)& int data  (4 bytes)& float data(4 bytes) & string(char array)  (25 bytes) data to EEPROM
*/

//Load Library Files
#include <EEPROM.h>

//Define four different types of variabless
char charVal = 'a';                           // 1  byte of char data to be stored in EEPROM
int intVar = 999999;                          // 4  bytes of int data to be stored in EEPROM
float floatVar = 234.567;                     // 4  bytes of floating-point data to be stored in EEPROM
char string[] = "Test EEPROM store string.";  // 26 bytes of string to be stored in EEPROM,include  a stop byte 0.

//Define three addresses to store four variables
int charValAddr = 0;
int intVarAddr = 1;
int fVarAddr = 5;
int stringAddr = 9;

void setup() {
  EEPROM.begin(512);
  Serial.begin(9600);

  //sizeof() is used to calculate the type length of the sizeof operator, in bytes
  Serial.println(" ");
  Serial.println("char data : " + String(sizeof(charVal)) + " byte.");     //1 byte
  Serial.println("int data  : " + String(sizeof(intVar)) + " bytes.");     //4 bytes
  Serial.println("float data : " + String(sizeof(floatVar)) + " bytes.");  //4ytes
  Serial.println("string data : " + String(sizeof(string)) + " bytes.");   //26 bytes of string to be stored in EEPROM,include  a stop byte 0.



  EEPROM.write(charValAddr, charVal);  // Store charVal in EEPROM address 0
  delay(10);
  EEPROM.put(intVarAddr, intVar);  // Store intVar in EEPROM address 1
  delay(10);
  EEPROM.put(fVarAddr, floatVar);  // Store floatVar in EEPROM address 5
  delay(10);
  EEPROM.put(stringAddr, string);  // Store string in EEPROM address 9
  delay(10);
  EEPROM.commit();  //Submit to save data from the temporary storage area to flash,
  Serial.println("Finished writing data!");

  Serial.println("Start reading float data:");
  charVal = EEPROM.read(charValAddr);
  EEPROM.get(intVarAddr, intVar);
  EEPROM.get(fVarAddr, floatVar);
  EEPROM.get(stringAddr, string);
  Serial.println("charVal is " + String(charVal));
  Serial.println("intVar is " + String(intVar));
  Serial.println("floatVar is " + String(floatVar, 3));  // three decimal places
  Serial.println("string is " + String(string));
  Serial.println("End read.");


  for (int addr = 0; addr < 512; addr++) {
    int data = EEPROM.read(addr);  //read one byte
    Serial.print(data);
    Serial.print(" ");
    delay(2);
    if ((addr + 1) % 256 == 0)  //
    {
      Serial.println("");
    }
  }
  Serial.println("End read");
}

void loop() {
  //  put your main code here, to run repeatedly:
}

