/**
 ******************************************************************************
 * @file    uaet.c
 * @author  cuij
 * @version V1.0.0
 * @date    11-02-2023
 * @brief   The  code is that use adapted to Arduino interface
 *
 * @par         Project
 *              MG32x02z
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************
  Copyright (c) 2023 megawin Technology Co., Ltd. All rights reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "MG32x02z.h"
#include "system_MG32x02z.h"
#include "uart.h"
#include "MG32x02z_URT.h"
#include "Arduino.h"


#ifdef __cplusplus
 extern "C" {
#endif


extern URT_HandleTypeDef        mURT0;
extern URT_HandleTypeDef        mURT1;
extern URT_HandleTypeDef        mURT2;
#if defined(URT3)
extern URT_HandleTypeDef        mURT3;
#endif
extern URT_HandleTypeDef        mURT4;
extern URT_HandleTypeDef        mURT5;
extern URT_HandleTypeDef        mURT6;
extern URT_HandleTypeDef        mURT7;


void megawin_Uart_init(void)
{
    // mURT0 URT0;
    mURT0.Instance            =  URT0;
    mURT0.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT0.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT0.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT0.Init.Mode           =  URT_TX_RX;
    mURT0.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT0.Init.Parity         =  URT_PARITY_NO;
    mURT0.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT0.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;


    // mURT1 URT1;
    mURT1.Instance            =  URT1;
    mURT1.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT1.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT1.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT1.Init.Mode           =  URT_TX_RX;
    mURT1.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT1.Init.Parity         =  URT_PARITY_NO;
    mURT1.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT1.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;


    // mURT2 URT2;
    mURT2.Instance            =  URT2;
    mURT2.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT2.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT2.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT2.Init.Mode           =  URT_TX_RX;
    mURT2.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT2.Init.Parity         =  URT_PARITY_NO;
    mURT2.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT2.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;

#if defined(URT3)
    // mURT3 URT3;
    mURT3.Instance            =  URT3;
    mURT3.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT3.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT3.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT3.Init.Mode           =  URT_TX_RX;
    mURT3.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT3.Init.Parity         =  URT_PARITY_NO;
    mURT3.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT3.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;
#endif

    // mURT4 URT4;
    mURT4.Instance            =  URT4;
    mURT4.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT4.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT4.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT4.Init.Mode           =  URT_TX_RX;
    mURT4.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT4.Init.Parity         =  URT_PARITY_NO;
    mURT4.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT4.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;


    // mURT5 URT5;
    mURT5.Instance            =  URT5;
    mURT5.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT5.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT5.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT5.Init.Mode           =  URT_TX_RX;
    mURT5.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT5.Init.Parity         =  URT_PARITY_NO;
    mURT5.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT5.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;


    // mURT6 URT6;
    mURT6.Instance            =  URT6;
    mURT6.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT6.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT6.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT6.Init.Mode           =  URT_TX_RX;
    mURT6.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT6.Init.Parity         =  URT_PARITY_NO;
    mURT6.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT6.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;


    // mURT7 URT7;
    mURT7.Instance            =  URT7;
    mURT7.Init.BaudRate       =  DEFAULT_INIT_BAUDRATE;                            
    mURT7.Init.WordLength     =  UART_WORDLENGTH_8B;
    mURT7.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    mURT7.Init.Mode           =  URT_TX_RX;
    mURT7.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    mURT7.Init.Parity         =  URT_PARITY_NO;
    mURT7.Init.StopBits       =  URT_STOPBIT_1_0;
    
    mURT7.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;

}

#ifdef __cplusplus
}
#endif


/*********COPYRIGHT(c) 2022 megawin Technology Co., Ltd *****END OF FILE****/
