/*
  Copyright (c) 2011 Arduino.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef HardwareSerial_h
#define HardwareSerial_h


#include <inttypes.h>


#ifdef __cplusplus

#include "Stream.h"
#include "chip.h"

#include "uart.h"
#include "pins_arduino.h"

#ifdef SERIAL_BUFFER_SIZE
#undef SERIAL_BUFFER_SIZE
#endif

#define SERIAL_BUFFER_SIZE  64

#define BLOCKING_FOREVER


class HardwareSerial : public Stream
{
/*
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  public:
    virtual void begin(unsigned long);
    virtual void end();
    virtual int available(void) = 0;
    virtual int peek(void) = 0;
    virtual int read(void) = 0;
    virtual void flush(void) = 0;
    virtual size_t write(uint8_t) = 0;
    using Print::write; // pull in write(str) and write(buf, size) from Print
    virtual operator bool() = 0;
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
*/

public:
    HardwareSerial( );
    virtual ~HardwareSerial(){;}
    HardwareSerial( URT_HandleTypeDef *uartdef);
    HardwareSerial( URT_HandleTypeDef *uartdef,  uint16_t  RxPin,  uint16_t  TxPin,  IRQn_Type  irqn);

    virtual void begin();
    virtual void begin( unsigned long baudRate );
    
    virtual int begin(  uint16_t   ArdRxPin,      uint16_t   ArdTxPin,   unsigned long baudRate);
    virtual int begin(  URT_HandleTypeDef        *uartdef,
                        uint16_t   ArdRxPin,      uint16_t   ArdTxPin,
                        IRQn_Type      irqn,      unsigned long baudRate);
                
    virtual void rs485Begin(unsigned long baudRate);
    virtual int  rs485Begin(  URT_HandleTypeDef *uartdef,
                              uint16_t   ArdRxPin,       uint16_t   ArdTxPin,
                              IRQn_Type      irqn,       unsigned long baudRate  );
                  
    virtual void end(void);
    virtual int available(void);
    virtual int availableForWrite(void);
    virtual int peek(void);
    virtual int read(void);
    virtual void flush(void);

    virtual size_t write(const uint8_t data);
    virtual size_t write(uint8_t *buffer, size_t size);
    virtual size_t write(const char *buffer ) { return write( ( uint8_t*)&buffer[0], strlen((char*)&buffer[0]) ); }

    
    //using Print::write; // pull in write(str) and write(buf, size) from Print

    virtual int printHex(  uint8_t uc_data   );
    virtual int printHex(  uint16_t uc_data  );
    virtual int printHex(  uint32_t uc_data  );
    
    virtual int printHex(  int      data   ){ return printHex((uint32_t)data); }
    virtual int printHex(  int8_t   data   ){ return printHex((uint8_t)data);  }
    virtual int printHex(  int16_t  data   ){ return printHex((uint16_t)data); }
    virtual int printHex(  int32_t  data   ){ return printHex((uint8_t)data);  }

    virtual int printDec(uint32_t uc_data );

    virtual void IrqTransHandler(void);
    virtual void IrqRecvHandler(void);

    virtual operator bool() { return true; }

    virtual void serialEvent(){;}

private:
        URT_HandleTypeDef    *m_usart_typedef;
        IRQn_Type             m_irqtype;

        uint16_t              m_available;

        uint16_t              m_tx_pin;
        uint16_t              m_tx_pinAFS;
        uint16_t              m_rx_pin;
        uint16_t              m_rx_pinAFS;

        uint8_t   m_rxTemp;
        uint8_t   m_rxpData[SERIAL_BUFFER_SIZE];
        uint32_t  m_rxData_Count;
        uint8_t   m_rxBegin;
        uint8_t   m_rxEnd;

        uint8_t   m_txdata;

};

extern void serialEventRun(void) __attribute__((weak));



extern URT_HandleTypeDef        mURT0;
extern URT_HandleTypeDef        mURT1;
extern URT_HandleTypeDef        mURT2;
extern URT_HandleTypeDef        mURT3;
extern URT_HandleTypeDef        mURT4;
extern URT_HandleTypeDef        mURT5;
extern URT_HandleTypeDef        mURT6;
extern URT_HandleTypeDef        mURT7;

#endif




#ifdef __cplusplus
 extern "C" {
#endif

size_t uart_write( uart_id_e uart_id, uint8_t data );

#if defined(DEBUG_PRTINT) 
int DEG_printHex(  uint32_t uc_data   );
int DEG_printDec(  uint32_t uc_data   );
int DEG_print(  const  char* str   );
int DEG_write(  const char* str,  size_t size   );
int DEG_putc(  char  c   );
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
#if defined(HWSERIAL0)
extern HardwareSerial Serial;
#endif
#if defined(HWSERIAL1)
extern HardwareSerial Serial1;
#endif
#if defined(HWSERIAL2)
extern HardwareSerial Serial2;
#endif

#if defined(URT3)&&defined(HWSERIAL3)
extern HardwareSerial Serial3;
#endif

#if defined(HWSERIAL4)
extern HardwareSerial Serial4;
#endif
#if defined(HWSERIAL5)
extern HardwareSerial Serial5;
#endif
#if defined(HWSERIAL6)
extern HardwareSerial Serial6;
#endif
#if defined(HWSERIAL7)
extern HardwareSerial Serial7;
#endif

#endif  //#ifdef __cplusplus




#endif
