/*******************************************************************************
* LowPower Library
* Version: 1.00
* Date: 09-05-2024
* Author: cuij
* Company: megawin Technology Co., Ltd.
* Website: www.megawin.com
*
* This is a lightweight low power library for Arduino.
*
* Unported License.
*
* Revision  Description
* ========  ===========
* 1.00      Initial public release.
*******************************************************************************/
#ifndef LowPower_h
#define LowPower_h

#include "Arduino.h"
#include "sleep.h"
#include "IWDT.h"

enum period_t
{
	SLEEP_15MS  = WDTO_15MS,
	SLEEP_30MS  = WDTO_30MS,
	SLEEP_60MS  = WDTO_60MS,
	SLEEP_120MS = WDTO_120MS,
	SLEEP_250MS = WDTO_250MS,
	SLEEP_500MS = WDTO_500MS,
	SLEEP_1S    = WDTO_1S,
	SLEEP_2S    = WDTO_2S,
	SLEEP_4S    = WDTO_4S,
	SLEEP_8S    = WDTO_8S,
	SLEEP_FOREVER = -1
};

enum bod_t
{
	BOD_OFF,
	BOD_ON
};

enum adc_t
{
	ADC_OFF,
	ADC_ON
};


enum usb_t
{
	USB_OFF,
	USB_ON
};


enum rtc_t
{
	RTC_OFF,
	RTC_ON
};


class LowPowerClass
{
public:
    void idle( period_t period=SLEEP_FOREVER );

    void standby( period_t period=SLEEP_FOREVER );
    void longPowerDown(uint32_t sleepTime);

    void sleep(uint32_t sleepTime);

    //void powerDown(period_t period, adc_t adc=ADC_OFF, bod_t bod=BOD_OFF, usb_t usb=USB_OFF);
    void powerDown(period_t period, adc_t adc=ADC_OFF, bod_t bod=BOD_OFF, usb_t usb=USB_OFF, rtc_t rtc=RTC_OFF);
    void powerStandby(period_t period, adc_t adc=ADC_OFF, usb_t usb=USB_OFF);
};

extern LowPowerClass LowPower;
#endif