
#include "MG32x02z_IWDT_MID.h"
#include "wdt.h"


__weak void ISR_WDT_vect()
{
    ;
}

#ifdef __cplusplus
 extern "C" {
#endif

extern IWDT_HandleTypeDef   mIWDT;
void CPP_IWDT_OF_IRQ()
{
	wdt_reset();
    ISR_WDT_vect();
}
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
 extern "C" {
#endif

IWDT_HandleTypeDef   mIWDT;


#ifdef __cplusplus
}
#endif


void Stop_Test()
{
    //特定时候需要屏蔽系统的一些复位源
    UnProtectModuleReg(RSTprotect);
    RST_CRstSource_Config (RST_IWDT_CE, DISABLE);
    RST_WRstSource_Config(RST_IWDT_WE, DISABLE);

    RST_CRstSource_Config(RST_SW_CE, DISABLE);
    RST_CRstSource_Config(RST_CPU_CE, DISABLE);
    RST_CRstSource_Config(RST_BOD0_CE, DISABLE);
    RST_CRstSource_Config(RST_BOD1_CE, DISABLE);
    RST_CRstSource_Config(RST_BOD2_CE, DISABLE);
    RST_CRstSource_Config(RST_LPM_CE, DISABLE);
    RST_CRstSource_Config(RST_CSC_CE, DISABLE);
    RST_CRstSource_Config(RST_MEM_CE, DISABLE);
    RST_CRstSource_Config(RST_IWDT_CE, DISABLE);
    RST_CRstSource_Config(RST_WWDT_CE, DISABLE);
    RST_CRstSource_Config(RST_ADC_CE, DISABLE);
    RST_CRstSource_Config(RST_CMP0_CE, DISABLE);
    RST_CRstSource_Config(RST_CMP1_CE, DISABLE);

    RST_WRstSource_Config ( RST_SW_WE, DISABLE);
    RST_WRstSource_Config ( RST_CPU_WE, DISABLE);
    RST_WRstSource_Config ( RST_BOD0_WE, DISABLE);
    RST_WRstSource_Config ( RST_BOD1_WE, DISABLE);
    RST_WRstSource_Config ( RST_BOD2_WE, DISABLE);
    RST_WRstSource_Config ( RST_LPM_WE, DISABLE);
    RST_WRstSource_Config ( RST_CSC_WE, DISABLE);
    RST_WRstSource_Config ( RST_MEM_WE, DISABLE);
    RST_WRstSource_Config ( RST_IWDT_WE, DISABLE);
    RST_WRstSource_Config ( RST_WWDT_WE, DISABLE);
    RST_WRstSource_Config ( RST_ADC_WE, DISABLE);
    RST_WRstSource_Config ( RST_CMP0_WE, DISABLE);
    RST_WRstSource_Config ( RST_CMP1_WE, DISABLE);
    ProtectModuleReg(RSTprotect);
    
    wdt_disable();

    UnProtectModuleReg(CSCprotect); 
    CSC_PeriphOnModeClock_Config(CSC_ON_IWDT, DISABLE);
    CSC_PeriphSTOPModeClock_Config(CSC_STP_IWDT, DISABLE);
    CSC_PeriphSLEEPModeClock_Config(CSC_SLP_IWDT, DISABLE);
    ProtectModuleReg(CSCprotect);  
    
    UnProtectModuleReg(CSCprotect); 
    CSC_PeriphOnModeClock_Config(CSC_ON_RTC, DISABLE);
    CSC_PeriphSTOPModeClock_Config(CSC_STP_RTC, DISABLE);
    CSC_PeriphSLEEPModeClock_Config(CSC_SLP_RTC, DISABLE);
    ProtectModuleReg(CSCprotect);  
    
    UnProtectModuleReg(PWprotect);                                // Unprotect PW module
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_IWDT, DISABLE);        // IWDT Wake Up Set
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_RTC, DISABLE); 
    ProtectModuleReg(PWprotect);                                  // protect PW module
    
    
    UnProtectModuleReg(PWprotect);
    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_POR, DISABLE);
   
    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_BOD0, DISABLE);
    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_BOD1, DISABLE);
    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_BOD2, DISABLE);

    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_CMP0, DISABLE);
    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_CMP1, DISABLE);
    
    PW_PeriphSTOPModeContinuous_Config(PW_STPPO_USB, DISABLE);
    ProtectModuleReg(PWprotect);
    
    CM0_SysTick_Cmd(DISABLE);
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    __WFI(); 
    CM0_SysTick_Cmd(ENABLE);
}



void wdt_disable (void)
{
    UnProtectModuleReg(IWDTprotect);
    IWDT_Cmd(DISABLE);
    ProtectModuleReg(IWDTprotect);

    UnProtectModuleReg(IWDTprotect);
    IWDT_StopModeWakeUpEvent_Config (  (IWDT_EW0_WPEN| IWDT_EW1_WPEN| IWDT_TF_WPEN), DISABLE);

    IWDT_IT_Config ((IWDT_INT_EW0 |IWDT_INT_EW1), DISABLE);
    IWDT_IT_Config (IWDT_INT_TF, DISABLE);
    
    UnProtectModuleReg(PWprotect);                                // Unprotect PW module
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_IWDT, DISABLE);        // IWDT Wake Up Set
    ProtectModuleReg(PWprotect);                                  // protect PW module

    ProtectModuleReg(IWDTprotect);
}


void wdt_enableRST (void)
{
    UnProtectModuleReg(RSTprotect);
    RST_CRstSource_Config (RST_IWDT_CE, ENABLE);
    RST_WRstSource_Config(RST_IWDT_WE, ENABLE);
    ProtectModuleReg(RSTprotect);
}

void wdt_disableRST (void)
{
    UnProtectModuleReg(RSTprotect);
    RST_CRstSource_Config (RST_IWDT_CE, DISABLE);
    RST_WRstSource_Config(RST_IWDT_WE, DISABLE);
    ProtectModuleReg(RSTprotect);
}



void wdt_enable(const uint8_t value)
{
    UnProtectModuleReg(CSCprotect); 
    CSC_PeriphOnModeClock_Config(CSC_ON_IWDT, ENABLE);
    CSC_PeriphSTOPModeClock_Config(CSC_STP_IWDT, ENABLE);
    CSC_PeriphSLEEPModeClock_Config(CSC_SLP_IWDT, ENABLE);
    ProtectModuleReg(CSCprotect);                                   // protect CSC module

    mIWDT.Instance = IWDT; 
    mIWDT.Init.Interrupt = (IWDT_IT_TIE);

    switch( value )
    {
        case WDTO_15MS:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_2;
            break;
        case WDTO_30MS:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_4;
            break;
        case WDTO_60MS:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_8;
            break;
        case WDTO_120MS:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_16;
            break;
        case WDTO_250MS:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_32;
            break;
        case WDTO_500MS:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_64;
            break;
        case WDTO_1S:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_128;
            break;
        case WDTO_2S:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_256;
            break;
        case WDTO_4S:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_512;
            break;
        case WDTO_8S:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_1024;
            break;
        default:
            mIWDT.Init.Prescaler = IWDT_PRESCALER_256;
            break;
    }

    UnProtectModuleReg(IWDTprotect);
    IWDT_Divider_Select( (IWDT_DIVS_TypeDef) value); 
    IWDT_Cmd(ENABLE);

    //IWDT_StopModeWakeUpEvent_Config (  (IWDT_EW0_WPEN| IWDT_EW1_WPEN| IWDT_TF_WPEN), ENABLE);
    IWDT_StopModeWakeUpEvent_Config (  (IWDT_TF_WPEN), ENABLE);
    //NVIC_SetPriority(  xxx,  1);

    IWDT_IT_Config ((IWDT_INT_EW0 |IWDT_INT_EW1), DISABLE);
    IWDT_IT_Config (IWDT_INT_TF, ENABLE);

    /*=== IWDT Wake Up Set ===*/
    UnProtectModuleReg(PWprotect);                                // Unprotect PW module
    PW_PeriphSTOPModeWakeUp_Config(PW_WKSTP_IWDT, ENABLE);        // IWDT Wake Up Set
    ProtectModuleReg(PWprotect);                                  // protect PW module

    IWDT_RefreshCounter();  
    ProtectModuleReg(IWDTprotect);

    wdt_reset();
}

