/*
In wdt_enable (timeout), timeout is the timeout period.
If the  watchdog does not eat after this period, 
the microcontroller will restart or Trigger watchdog interrupt service Routine(ISR). 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  In this example,watchdog interrupt service Routine will be triggered once watchdog does not eat after timeout period. 
  Here ,in loop(), 
  if delay time < 2s,  Feed the dog promptly,the ISR will never be executed.
  If delay time > 2s, Watchdog timeout ,the ISR will be executed. In this example ,change the LED status.
  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
*/
/*
Timeout period as following:
  SLEEP_15MS  = WDTO_15MS,     // watchdog timer  15ms timeout
  SLEEP_30MS  = WDTO_30MS,     // watchdog timer 30ms timeout
  SLEEP_60MS  = WDTO_60MS,     // watchdog timer 60ms timeout
  SLEEP_120MS = WDTO_120MS,    // watchdog timer 120ms timeout
  SLEEP_250MS = WDTO_250MS,    // watchdog timer 250ms timeout
  SLEEP_500MS = WDTO_500MS,    // watchdog timer 500ms timeout
  SLEEP_1S    = WDTO_1S,       // watchdog timer 1s timeout
  SLEEP_2S    = WDTO_2S,       // watchdog timer 2s timeout
  SLEEP_4S    = WDTO_4S,       // watchdog timer 4s timeout
  SLEEP_8S    = WDTO_8S,       // watchdog timer 8s timeout
*/
/*
wdt_disableRST();           //  Disable WDT interrupt reset MCU function.
                            //  Generally used in conjunction with ISR(WDT_vect).
wdt_enableRST();            //  Enable  WDT interrupt reset MCU function.
wdt_enable(timeout period); //  Enable the watchdog and set a timeout time
wdt_disable();              //  Disable the watchdog
wdt_reset();                //  Watchdog timer reset (feeding dog)
*/


#include "IWDT.h"

const int LEDpin = 13;
volatile int state =HIGH;


ISR(WDT_vect)
{
  state = !state;             
  wdt_reset();
}


void setup()
{
    pinMode( LEDpin, OUTPUT);
    wdt_disableRST();      //  Disable WDT interrupt reset MCU function.
    wdt_enable(WDTO_2S);   //  Enable the watchdog and set a timeout time as 2s
    wdt_reset();           //  Watchdog timer reset (feeding dog)
}

void loop() 
{
    digitalWrite( LEDpin,  state );

    //  Here ,if delay time < 2s,  Feed the dog promptly,the ISR will never be executed.
    //  If delay time > 2s, Watchdog timeout ,the ISR will be executed. In this example ,change the LED status.
    delay(100);

    //for this test reset will do in interrupt.
    //wdt_reset();  
}