///////////////////////////////////////////////////
//
//	FILE:       MPC82_KeyScanPowerDown_Demo.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.4.23
//	PURPOSE:    Demo KeyScan and PowerDown Function
//
///////////////////////////////////////////////////
#include "REG_MPC82L54.H"
//#include "REG_MPC82G516.H"
//#define DEBUG
#ifdef DEBUG
#include "debug.h"
#endif

unsigned char get_key = 0xff;
unsigned char pre_key = 0xff;
void Initial()
{
    IE0 = 0;//Clean EX0 flag
    IE = 0x81;//Enable External 0
	P1 &= 0x0f;//Set P14 ~ P17 to Low
	P2 |= 0xf0;//Set P24 ~ P27 to High(Input)
	PCON = 0x02;//Set power down mode
}
unsigned char Key_scan()
{

	P2 |= 0xf0;
	P1 |= 0xf0;
	P14 = 0;
	if(P24 == 0)
		return 0x00;
	if(P25 == 0)
		return 0x04;
	if(P26 == 0)
		return 0x08;
	if(P27 == 0)
		return 0x0c;
	P14 = 1;	
	P15 = 0;
	if(P24 == 0)
		return 0x01;
	if(P25 == 0)
		return 0x05;
	if(P26 == 0)
		return 0x09;
	if(P27 == 0)
		return 0x0d;
	P15 = 1;
	P16 = 0;
	if(P24 == 0)
		return 0x02;
	if(P25 == 0)
		return 0x06;
	if(P26 == 0)
		return 0x0a;
	if(P27 == 0)
		return 0x0e;
	P16 = 1;
	P17 = 0;
	if(P24 == 0)
		return 0x03;
	if(P25 == 0)
		return 0x07;
	if(P26 == 0)
		return 0x0b;
	if(P27 == 0)
		return 0x0f;
	P17 = 1;
	return 0xff;
}
void External_0_Interrupt() interrupt 0
{
	EX0 = 0;//External 0 interrupt
    get_key = Key_scan();
#ifdef DEBUG
	if(get_key!=0xff)
    	Debug_show_msg_to_LCD(get_key);
#endif	
	P1 &= 0x0f;//Set P14 ~ P17 to Low
	P2 |= 0xf0;//Set P24 ~ P27 to High(Input)
	EX0 = 1;
	PCON = 0x02;//Set power down mode
}
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{
#ifdef DEBUG
    Debug_clear_LCD();
#endif
    Initial();
    while(1)
    {
//	    get_key = Key_scan();
       	if((get_key!=0xff)&&(get_key!=pre_key))
       	{
			pre_key=get_key;
       	}
	}
}