///////////////////////////////////////////////////
//
//	FILE:       MPC82_IR_Demo.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.4.30
//	PURPOSE:    Demo IR Receiver Function
//	Description:                                       
//              Input:11MHz clock to 8051.    
//           IR Input:P3.2 (Use External Interrupt 0)  
//            Circuit:MPC82_IR_Demo_Circuit.jpg        
//
///////////////////////////////////////////////////
//#include "REG_MPC82L54.H"
#include "REG_MPC82G516.H"

#include "MPC_IR_LIB.h"
//#define DEBUG //For Megawin GNU Debugger
#ifdef DEBUG
#include "debug.h"
#endif

void Initial()
{
    IT0 = 1;//Set falling edge in External 0
    IE0 = 0;//Clean EX0 flag
    IE = 0x81;//Enable Timer 0 & External 0
    TMOD = 0x01;//Mode 1 (16bit timer)
}

void External_0_Interrupt() interrupt 0
{
    EX0 = 0;
    Get_IR_code();
}
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{
    extern unsigned char key_code;
#ifdef DEBUG
    Debug_clear_LCD();
#endif
    Initial();
    Set_Custom_code(0x73);
    while(1)
    {
        IR_polling();

        if(key_code!=0xff)
        {
#ifdef DEBUG
            Debug_show_msg_to_LCD(key_code);
#endif
            key_code=0xff;
        }
    }
}
