/*** Functions used by other modules ***/

/*
For Keil C51, #include "Debug.H", then the following functions can be used:

   (1) Clear the LCD display of the Debugger
       Function: Debug_clear_LCD();

   (2) Show a message on the LCD display of the Debugger
       Function: Debug_show_msg_to_LCD(unsigned char msg);

   (3) Show a message on the 7-segment display of the Debugger
       Function: Debug_show_msg_to_7seg(unsigned char msg);

   (4) Set a breakpoint in the application code, and pressing the "GO-key"
       on the Debugger to let the application code continue to go
       Function: Debug_set_breakpoint(unsigned char BP_number);

   (5) Show a message to PC
       Function: Debug_show_msg_to_PC(unsigned char msg);

   (6) Get one byte data from PC, to be used in the application program
       Function: arg=Debug_get_argument_from_PC(); //return value: unsigned char arg
*/

//Prototype definition

extern void dbg_clear_LCD(void);
extern void dbg_show_msg_to_LCD(unsigned char msg);
extern void dbg_show_msg_to_7seg(unsigned char msg);
extern void dbg_set_breakpoint(unsigned char BP_number);
extern void dbg_show_msg_to_PC(unsigned char msg);
extern unsigned char dbg_get_argument_from_PC();

//Mnemonic definition

#define Debug_clear_LCD            dbg_clear_LCD
#define Debug_show_msg_to_LCD      dbg_show_msg_to_LCD
#define Debug_show_msg_to_7seg     dbg_show_msg_to_7seg
#define Debug_set_breakpoint       dbg_set_breakpoint
#define Debug_show_msg_to_PC       dbg_show_msg_to_PC
#define Debug_get_argument_from_PC dbg_get_argument_from_PC

