///////////////////////////////////////////////////
//
//    FILE:       MPC89E(L)52_IAP_Sample_for_ASM.A51
//    COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//    PURPOSE:    Demo IAP Function
//
///////////////////////////////////////////////////
AP_End_Addr       EQU      01FFFh
IAP_Start_Addr    EQU      02000h
IAP_End_Addr      EQU      037FFh
Xtal_Freq         EQU      12                //Unit:MHz

$INCLUDE (REG_MPC89L51-515.INC)

TDATA             SEGMENT  DATA
                  RSEG     TDATA	
StackSpace:       DS       030h
Trigger_Check1:   DS       001h
Trigger_Check2:   DS       001h

CSEG              AT       00000h            //ORG 00000h
      JMP   START

Using    0
CSEG              AT       0003Bh            //ORG 0003Bh

START:
      MOV   Trigger_Check1,#055h
      MOV   SP,#(StackSpace-1)
///////////////////////////////////////////////////
//
//	   Main()
//
///////////////////////////////////////////////////
      CALL  Initiation

      CALL  IAP_Erase_512B

      CALL  IAP_Write_512B

      CALL  IAP_Read_Check_512B

      CALL  Display_PASS
            
      JMP   $

///////////////////////////////////////////////////
//
//	   Initiation()
//
///////////////////////////////////////////////////
Initiation:
      MOV   Trigger_Check2,#000h
      RET   

///////////////////////////////////////////////////
//
//    IAP_Erase_512B   512Bytes/Page
//
///////////////////////////////////////////////////
IAP_Erase_512B:
      MOV   R6,#High(IAP_Start_Addr)
      MOV   R7,#Low(IAP_Start_Addr)
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Page_Erase

      MOV   R6,#High(IAP_Start_Addr)
      MOV   R7,#Low(IAP_Start_Addr)      
      CALL  IAP_Blank_Check   
      RET

///////////////////////////////////////////////////
//
//    Blank Check
//
///////////////////////////////////////////////////
IAP_Blank_Check:
      PUSH  AR5
      PUSH  ACC
      PUSH  DPH
      PUSH  DPL
      MOV   DPH,R6
      MOV   DPL,R7
      INC   R6
      INC   R6
      MOV   R5,AR6
IAP_Blank_Check_Loop:
      MOV   R6,DPH  
      MOV   R7,DPL
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Read_Byte
      MOV   A,R7
      CJNE  R7,#0FFh,IAP_Erase_Fail
      INC   DPTR
      MOV   A,DPH
      CJNE  A,AR5,IAP_Blank_Check_Loop
      POP   DPL
      POP   DPH
      POP   ACC
      POP   AR5
      RET 

IAP_Erase_Fail:
IAP_Write_Fail:
      CLR   P1.2
      SETB  P1.3
      JMP   $

///////////////////////////////////////////////////
//
//    IAP_Read_Check_512Byte
//
///////////////////////////////////////////////////
IAP_Read_Check_512B:
      PUSH  ACC
      PUSH  AR5
      PUSH  DPH
      PUSH  DPL
      MOV   DPTR,#IAP_Start_Addr
      MOV   R5,DPH
      INC   AR5
      INC   AR5
IAP_Check_Loop:
      MOV   R6,DPH
      MOV   R7,DPL
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Read_Byte
      MOV   A,DPH
      ADD   A,DPL
      CJNE  A,AR7,IAP_Write_Fail
      INC   DPTR
      MOV   A,DPH
      CJNE  A,AR5,IAP_Check_Loop
      POP   DPL
      POP   DPH
      POP   AR5
      POP   ACC
      RET

///////////////////////////////////////////////////
//
//    IAP_Write_512Byte
//
///////////////////////////////////////////////////
IAP_Write_512B:
      PUSH  AR4
      PUSH  AR5
      PUSH  ACC
      PUSH  DPH
      PUSH  DPL
      MOV   DPTR,#IAP_Start_Addr
      MOV   R4,DPH
      INC   AR4
      INC   AR4
IAP_Write_Loop:
      MOV   R6,DPH
      MOV   R7,DPL
      MOV   A,DPH
      ADD   A,DPL
      MOV   R5,A
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Write_Byte
      INC   DPTR
      MOV   A,DPH
      CJNE  A,AR4,IAP_Write_Loop
      POP   DPL
      POP   DPH
      POP   ACC
      POP   AR5
      POP   AR4
      RET

///////////////////////////////////////////////////
//
//    Function:Erase_IAP()
//    Erase One page (512 bytes)
//    IAP Address High Byte R6
//    IAP Address Low Byte  R7
//
///////////////////////////////////////////////////
IAP_Page_Erase:
   IF       (Xtal_Freq<=6)                   //File:MPC89x51A_A11.pdf Page:29
      MOV   ISPCR,#003h    
   ELSEIF   (Xtal_Freq<=10)
      MOV   ISPCR,#002h
   ELSEIF   (Xtal_Freq<=20)
      MOV   ISPCR,#001h
   ELSEIF   (Xtal_Freq<=40)
      MOV   ISPCR,#000h
   ENDIF

      ORL   ISPCR,#080h
      MOV   IFMT,#003h                       //IAP Flash Mode Table (Erase Mode)
      MOV   IFADRH,R6                        //IAP Flash Address High Byte
      MOV   IFADRL,R7                        //IAP Flash Address Low Byte

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   IFMT,#000h
      ANL   ISPCR,#07Fh
      RET

///////////////////////////////////////////////////
//
//    Function:Read_IAP()
//    Read one byte from IAP address
//    IAP Address High Byte R6
//    IAP Address Low Byte  R7
//    Return data to R7
//  
///////////////////////////////////////////////////
IAP_Read_Byte:
   IF       (Xtal_Freq<=6)                   //File:MPC89x51A_A11.pdf Page:29
      MOV   ISPCR,#003h    
   ELSEIF   (Xtal_Freq<=10)
      MOV   ISPCR,#002h
   ELSEIF   (Xtal_Freq<=20)
      MOV   ISPCR,#001h
   ELSEIF   (Xtal_Freq<=40)
      MOV   ISPCR,#000h
   ENDIF

      ORL   ISPCR,#080h                      //IAP Function Enable
      MOV   IFADRH,R6                        //IAP Flash Address High Byte
      MOV   IFADRL,R7                        //IAP Flash Address Low Byte
      MOV   IFMT,#001h                       //IAP Flash Mode Table (Read Mode)
	   MOV   ISPCR,#080h                      //Enable IAP to change flash

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   R7,IFD                           //Return Flash data
      MOV   IFMT,#000h                        
      ANL   ISPCR,#07Fh                      //IAP Function Disable
      RET

Trigger2_Fail:
      MOV   SCMD,#000h  
Trigger1_Fail:
      CLR   P1.2
      SETB  P1.3
      JMP   $

///////////////////////////////////////////////////
//
//	   Function:Write_IAP()
//    Write to IAP address one byte
//    Write data R5  
//    IAP Address High Byte R6
//    IAP Address Low Byte  R7
//
///////////////////////////////////////////////////
IAP_Write_Byte:
   IF       (Xtal_Freq<=6)                   //File:MPC89x51A_A11.pdf Page:29
      MOV   ISPCR,#003h    
   ELSEIF   (Xtal_Freq<=10)
      MOV   ISPCR,#002h
   ELSEIF   (Xtal_Freq<=20)
      MOV   ISPCR,#001h
   ELSEIF   (Xtal_Freq<=40)
      MOV   ISPCR,#000h
   ENDIF

      ORL   ISPCR,#080h
	   MOV   IFMT,#002h                       //IAP Flash Mode Table (Write Mode)
      MOV   IFADRH,R6                        //IAP Flash Address High Byte
      MOV   IFADRL,R7                        //IAP Flash Address Low Byte
      MOV   IFD,R5                           //Flash data buffer

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   IFMT,#000h
      ANL   ISPCR,#07Fh
      RET

///////////////////////////////////////////////////
//
//    Display_PASS
//
///////////////////////////////////////////////////
Display_PASS:
      CLR   P1.3
      SETB  P1.2
      RET
      
CSEG  AT    01000h
      DB    055h,0AAh,0BBh,0CCh,0DDh,0FFh  
      END
