///////////////////////////////////////////////////
//
//  FILE:       PWM_Demo.c
//  AUTHOR:	    Neo (Hsin-Chih Lin)
//  COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//  CREATED:    2008.7.8
//  PURPOSE:    Demo PCA_PWM Function
//  VERSION:    1.3
//
///////////////////////////////////////////////////

//#define MPC82G516
#ifdef MPC82G516
#include "REG_MPC82G516.H"
#else
#include "REG_MPC82L54.H"
#endif
void Init_PWM();
void Set_Frequency(char mod_freq);
void Set_Duty(unsigned char module,unsigned int mod_timer);

///////////////////////////////////////////////////
//
//  Function:Main()
//  Purpose :PWM demo software
//           (Pulse Width Modulator)
//
///////////////////////////////////////////////////
void delay5ms()
{
    unsigned int j;
    for(j=0;j<4978;j++) ;
}

void Main()
{
    unsigned int i;
	Init_PWM();
	Set_Frequency(0xf0);
//	Set_Duty(0,0x0080);
	CCON	|=	0x40;				//Start PCA Counter
	TR0 	=	1;  				//Start Timer_0 Counter
	while (1)
    {
        /*
        for(i=0;i<0xff;i++)
        {
            Set_Duty(0,i);
            Set_Duty(1,0xff-i);
            delay5ms();
        }
        for(i=0xff;i>0;i--)
        {
            Set_Duty(0,i);
            Set_Duty(1,0xff-i);
            delay5ms();
        }*/
       //===================================================================================
        //Ϊ ͳ  0x100 ʱPWM˸ߵƽ ư 
        Set_Duty(0,0x000);
        Set_Duty(1,0x020);
        Set_Duty(2,0x0A0);
        Set_Duty(3,0x100);
        delay5ms();
       //===================================================================================
    }
}
///////////////////////////////////////////////////
//
//	Function:Init_PWM()
//  Purpose :Initial PWM parameter
//
///////////////////////////////////////////////////
void Init_PWM()
{
//  CMOD	=	0x00;				//Set PCA Mode (PCA clock source as OSC/12)
//  CMOD	=	0x02;				//Set PCA Mode (PCA clock source as OSC/2)
    CMOD	=	0x04;				//Set PCA Mode (PCA clock source as Timer 0-Overflow)
//  CMOD	=	0x06;				//Set PCA Mode (PCA clock source as ECI(P3.4))
	CCAPM0	=	0x42;				//Configure PCA Module0 to PWM
	CCAPM1	=	0x42;				//Configure PCA Module1 to PWM
	CCAPM2	=	0x42;				//Configure PCA Module2 to PWM
	CCAPM3	=	0x42;				//Configure PCA Module3 to PWM
//	CCAPM4	=	0x42;				//Configure PCA Module4 to PWM(Only for MPC82G516)
//	CCAPM5	=	0x42;				//Configure PCA Module5 to PWM(Only for MPC82G516)
	TMOD	=	0x02;				//Set Timer 0 Mode to Mode2(Auto load TH to TL when overflow)
#ifdef MPC82G516
	AUXR2	=	0x80;				//T0x12 Frequency * 12
#else
	AUXR	=	0x80;				//T0x12 Frequency * 12
#endif
}
///////////////////////////////////////////////////
//
//	Function:Set_Frequency(char mod_freq)
//	Params.:
//    mod_freq:
//		You can setup frequency from 
//		30Hz(mod_freq = 0) to 
//		93.7KHz(mod_freq = 0xff, AUXR(2) = 0x80)
//
///////////////////////////////////////////////////
void Set_Frequency(char mod_freq)
{
	TH0		=	mod_freq;			//Set Timer 0 Clock Start
}
///////////////////////////////////////////////////
//
//	Function:Set_Duty(char module,char mod_timer)
//  Parames:
//	  module:
//		Select which module do you want set.(0-5)
//
//	  mod_timer:
//		Set duty length.(0-0x100)
//      0x0000 is all output high,
//      0x0100 is all output low
//
///////////////////////////////////////////////////
void Set_Duty(unsigned char module,unsigned int mod_timer)
{
	switch(module)
	{
		case 0:
		    if(mod_timer >=0x100)
			    PCAPWM0=PCAPWM0|0x02;
			else
				PCAPWM0=PCAPWM0&0xFD;
			CCAP0H	=	mod_timer;
			break;
		case 1:
		    if(mod_timer >=0x100)
			    PCAPWM1=PCAPWM1|0x02;
			else
				PCAPWM1=PCAPWM1&0xFD;
			CCAP1H	=	mod_timer;
			break;
		case 2:
		    if(mod_timer >=0x100)
			    PCAPWM2=PCAPWM2|0x02;
			else
				PCAPWM2=PCAPWM2&0xFD;
			CCAP2H	=	mod_timer;
			break;
		case 3:
		    if(mod_timer >=0x100)
			    PCAPWM3=PCAPWM3|0x02;
			else
				PCAPWM3=PCAPWM3&0xFD;
			CCAP3H	=	mod_timer;
			break;
#ifdef MPC82G516
		case 4:
		    if(mod_timer >=0x100)
			    PCAPWM4=PCAPWM4|0x02;
			else
				PCAPWM4=PCAPWM4&0xFD;
			CCAP4H	=	mod_timer;
			break;
		case 5:
		    if(mod_timer >=0x100)
			    PCAPWM5=PCAPWM5|0x02;
			else
				PCAPWM5=PCAPWM5&0xFD;
			CCAP5H	=	mod_timer;
			break;
#endif
	}
}
