///////////////////////////////////////////////////
//
//	FILE:       MPC82G516_ISP_Demo.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.5.26
//	PURPOSE:    Demo ISP Function
//
///////////////////////////////////////////////////
//#define DEBUG
#define BAUDRATE    B_9600
#define B_2400      0
#define B_4800      1
#define B_9600      2
#define B_19200     3
#define B_38400     4
#define B_57600     5
#define B_115200    6
#define B_230400    7

#include "REG_MPC82G516.H"
#ifdef DEBUG
#include "debug.h"
#endif
void Init_Uart(void);
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
char State=0;
void main(void)
{
#ifdef DEBUG
    Debug_show_msg_to_LCD(0x11);
#endif
    Init_Uart();
	while (1) 
    {
        if(State==4)
        {
            State = 0;
            ISPCR = 0x60;       //Enter ISP Code
        }
    }
}
void UART_Interrupt() interrupt 4
{
    if(TI)              //if transfer complete
        TI=0;           //clear TI

    if(RI)
    {                   //if receive complete
        RI=0;           //clear RI
    	switch(State)
	    {
		    case 0:
                if(SBUF==0x7a)
                    State=1;
    			break;
	    	case 1:
                if(SBUF==0x31)
                    State=2;
    			break;
	    	case 2:
                if(SBUF==0x7a)
                    State=3;
    			break;
			    break;
    		case 3:
                if(SBUF==0x31)
                    State=4;
		    	break;
    	}
    }
}
///////////////////////////////////////////////////
//
//	Function:Init_UART()
//  Initial UART at Mode 1 and use Timer1 at mode 2
//  Ex:We set buad rete is 4800
//  11MHz / 12 / 16 / 4800 = 11.93 => 12
//  TH = 256-12 = 0xf4
//
///////////////////////////////////////////////////
void Init_Uart(void)
{
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
    IE=0x90;                                    //EA & ES
#if BAUDRATE == B_2400
//  11MHz / 12 / 32 / 2400 => 12
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
#elif BAUDRATE == B_4800
//  11MHz / 12 / 16 / 4800 => 12
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
#elif BAUDRATE == B_9600
//  11MHz / 12 / 16 / 9600 => 6
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfa;                                   //Set Timer1 overflow rate
    TL1=0xfa;
    TR1 =1;                                     //Start Timer1
#elif BAUDRATE == B_19200
//  11MHz / 32 / 19200 => 18
    TH1=0xee;                                   //Set Timer1 overflow rate
    TL1=0xee;
    TR1 =1;                                     //Start Timer1
    AUXR2=0x40;                                 //T1X12 = 1
#elif BAUDRATE == B_38400
//  11MHz / 16 / 38400 => 18
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xee;                                   //Set Timer1 overflow rate
    TL1=0xee;
    TR1 =1;                                     //Start Timer1
    AUXR2=0x40;                                 //T1X12 = 1
#elif BAUDRATE == B_57600
//  11MHz / 16 / 57600 => 12
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xf4;                                   //Set Timer1 overflow rate
    TL1=0xf4;
    TR1 =1;                                     //Start Timer1
    AUXR2=0x40;                                 //T1X12 = 1
#elif BAUDRATE == B_115200
//  11MHz / 16 / 115200 => 6
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfa;                                   //Set Timer1 overflow rate
    TL1=0xfa;
    TR1 =1;                                     //Start Timer1
    AUXR2=0x40;                                 //T1X12 = 1
#elif BAUDRATE == B_230400
//  11MHz / 16 / 230400 => 3
    PCON=0x80;                                  //Set SMOD = 1 (Double Baud rate)
    TH1=0xfd;                                   //Set Timer1 overflow rate
    TL1=0xfd;
    TR1 =1;                                     //Start Timer1
    AUXR2=0x40;                                 //T1X12 = 1
#endif
}
