///////////////////////////////////////////////////
//
//    FILE:       MG87FE(L)2051_IAP_Sample_for_ASM.A51
//    COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//    PURPOSE:    Demo IAP Function
//
///////////////////////////////////////////////////
AP_End_Addr       EQU      007FFh
IAP_Start_Addr    EQU      01800h            //Min_Value:0x0200   Max_Vlaue:0xFFFF  Step: +0x0200
IAP_End_Addr      EQU      01BFFh
Xtal_Freq         EQU      12                //Unit:MHz

$INCLUDE (REG_MG87FL2051-6051.INC)
                              
TDATA             SEGMENT  DATA
                  RSEG     TDATA	
StackSpace:       DS       030h
Trigger_Check1:   DS       001h
Trigger_Check2:   DS       001h

CSEG              AT       00000h            //ORG 00000h
      JMP   START

Using    0
CSEG              AT       0003Bh            //ORG 0003Bh
START:
      MOV   Trigger_Check1,#055h
      MOV   SP,#(StackSpace-1)
///////////////////////////////////////////////////
//
//	   Main()
//
///////////////////////////////////////////////////
      CALL  Initiation

      CALL  Set_IAP_Spcae

      CALL  IAP_Erase_512B

      CALL  IAP_Write_512B

      CALL  IAP_Read_Check_512B

      CALL  Display_PASS    

      JMP   $

///////////////////////////////////////////////////
//
//	   Initiation()
//
///////////////////////////////////////////////////
Initiation:
      MOV   Trigger_Check2,#000h
      RET   

///////////////////////////////////////////////////
//
//    Set_IAP_Space()
//
///////////////////////////////////////////////////
Set_IAP_Spcae:
      PUSH  AR7
      PUSH  AR6

      MOV   R7,#High(IAP_Start_Addr)
      MOV   Trigger_Check2,#0AAh
      CALL  Write_IAPLB


      MOV   Trigger_Check2,#0AAh
      CALL  Read_IAPLB

      CJNE  R6,#High(IAP_Start_Addr),IAP_Set_Fail

      POP   AR6
      POP   AR7
      RET

IAP_Set_Fail:
      JMP   Trigger1_Fail

///////////////////////////////////////////////////
//
//    IAP_Erase_512B   512Bytes/Page
//
///////////////////////////////////////////////////
IAP_Erase_512B:
      MOV   R6,#High(IAP_Start_Addr)
      MOV   R7,#Low(IAP_Start_Addr)
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Page_Erase

      MOV   R6,#High(IAP_Start_Addr)
      MOV   R7,#Low(IAP_Start_Addr)      
      CALL  IAP_Blank_Check   
      RET

///////////////////////////////////////////////////
//
//    Blank Check
//
///////////////////////////////////////////////////
IAP_Blank_Check:
      PUSH  AR4
      PUSH  AR5
      PUSH  ACC
      PUSH  DPH
      PUSH  DPL
      PUSH  ACC

      MOV   R5,AR6
      INC   R5
      INC   R5
      MOV   DPH,R6
      MOV   DPL,R7
IAP_Blank_Check_Loop:
      MOV   R6,DPH  
      MOV   R7,DPL
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Read_Byte
      CJNE  R6,#0FFh,IAP_Erase_Fail
      INC   DPTR
      MOV   A,DPH
      CJNE  A,AR5,IAP_Blank_Check_Loop

      POP   ACC
      POP   DPL
      POP   DPH
      POP   ACC
      POP   AR5
      POP   AR4
      RET 

IAP_Erase_Fail:
IAP_Write_Fail:
      CLR   P1.2
      SETB  P1.3
      JMP   $

///////////////////////////////////////////////////
//
//    IAP_Read_Check_512Byte
//
///////////////////////////////////////////////////
IAP_Read_Check_512B:
      PUSH  ACC
      PUSH  AR5
      PUSH  DPH
      PUSH  DPL

      MOV   DPTR,#IAP_Start_Addr
      MOV   R5,DPH
      INC   AR5
      INC   AR5
IAP_Check_Loop:
      MOV   R6,DPH
      MOV   R7,DPL
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Read_Byte
      MOV   A,DPH
      ADD   A,DPL
      CJNE  A,AR6,IAP_Write_Fail
      INC   DPTR
      MOV   A,DPH
      CJNE  A,AR5,IAP_Check_Loop

      POP   DPL
      POP   DPH
      POP   AR5
      POP   ACC
      RET

///////////////////////////////////////////////////
//
//    IAP_Write_512Byte
//
///////////////////////////////////////////////////
IAP_Write_512B:
      PUSH  AR4
      PUSH  AR5
      PUSH  ACC
      PUSH  DPH
      PUSH  DPL
      MOV   DPTR,#IAP_Start_Addr
      MOV   R4,DPH
      INC   AR4
      INC   AR4
IAP_Write_Loop:
      MOV   R6,DPH
      MOV   R7,DPL
      MOV   A,DPH
      ADD   A,DPL
      MOV   R5,A
      MOV   Trigger_Check2,#0AAh
      CALL  IAP_Write_Byte
      INC   DPTR
      MOV   A,DPH
      CJNE  A,AR4,IAP_Write_Loop
      POP   DPL
      POP   DPH
      POP   ACC
      POP   AR5
      POP   AR4
      RET

///////////////////////////////////////////////////
//
//    Function:Read_IAPLB()
//    Read one byte from IAP address
//    Return IAPLB to R6
//    Return ISPCR to R7 for Check CFAIL bit
//  
///////////////////////////////////////////////////
Read_IAPLB:
      PUSH  ACC

      ANL   CKCON2,#0C0h
      ORL   CKCON2,#((Xtal_Freq-1)AND 0C0h)
      MOV   ISPCR,#080h                      //IAP Function Enable
      MOV   IFMT,#005h                       //IAP Flash Mode Table (Read Mode)
      MOV   IFADRH,#High(IAP_End_Addr)       //IAP Flash Address High Byte
      MOV   IFADRL,#Low(IAP_End_Addr)        //IAP Flash Address Low Byte
      MOV   IFD,#000h

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail1
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   R6,IFD                           //Return Flash data
      MOV   IFMT,#000h                        
      ANL   ISPCR,#07Fh                      //IAP Function Disable
      MOV   R7,ISPCR
      POP   ACC
      RET

Trigger1_Fail1:
      JMP   Trigger1_Fail
///////////////////////////////////////////////////
//
//	   Function:Write_IAPLB()
//    Write to IAP address one byte
//    Write IAPLB R7  
//    Return ISPCR to R7 for Check CFAIL bit
//
///////////////////////////////////////////////////
Write_IAPLB:
      PUSH  ACC

      ANL   CKCON2,#0C0h
      ORL   CKCON2,#((Xtal_Freq-1)AND 0C0h)
      MOV   ISPCR,#080h
      MOV   IFMT,#004h                       //IAP Flash Mode Table (Write Mode)
      MOV   IFADRH,#High(IAP_End_Addr)       //IAP Flash Address High Byte
      MOV   IFADRL,#Low(IAP_End_Addr)        //IAP Flash Address Low Byte
      MOV   IFD,R7                           //Flash data buffer

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   IFMT,#000h
      ANL   ISPCR,#07Fh

      POP   ACC
      RET

///////////////////////////////////////////////////
//
//    Function:Erase_IAP()
//    Erase One page (512 bytes)
//    IAP Address High Byte R6
//    IAP Address Low Byte  R7
//    Return ISPCR to R7 for Check CFAIL bit
//
///////////////////////////////////////////////////
IAP_Page_Erase:
      PUSH  ACC

      ANL   CKCON2,#0C0h
      ORL   CKCON2,#((Xtal_Freq-1)AND 0C0h)
      MOV   ISPCR,#080h
      MOV   IFMT,#003h                       //IAP Flash Mode Table (Erase Mode)
      MOV   IFADRH,R6                        //IAP Flash Address High Byte
      MOV   IFADRL,R7                        //IAP Flash Address Low Byte
      MOV   IFD,#000h

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   IFMT,#000h
      ANL   ISPCR,#07Fh
      MOV   R7,ISPCR

      POP   ACC
      RET

Trigger2_Fail:
      MOV   SCMD,#000h  
Trigger1_Fail:
      CLR   P1.2
      SETB  P1.3
      JMP   $

///////////////////////////////////////////////////
//
//    Function:Read_IAP()
//    Read one byte from IAP address
//    IAP Address High Byte R6
//    IAP Address Low Byte  R7
//    Return DATA to R6
//    Return ISPCR to R7 for Check CFAIL bit
//  
///////////////////////////////////////////////////
IAP_Read_Byte:
      PUSH  ACC

      ANL   CKCON2,#0C0h
      ORL   CKCON2,#((Xtal_Freq-1)AND 0C0h)
      MOV   ISPCR,#080h                      //IAP Function Enable
      MOV   IFADRH,R6                        //IAP Flash Address High Byte
      MOV   IFADRL,R7                        //IAP Flash Address Low Byte
      MOV   IFMT,#001h                       //IAP Flash Mode Table (Read Mode)
      MOV   IFD,#000h

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   R6,IFD                           //Return Flash data
      MOV   IFMT,#000h                        
      ANL   ISPCR,#07Fh                      //IAP Function Disable
      MOV   R7,ISPCR

      POP   ACC
      RET

///////////////////////////////////////////////////
//
//	   Function:Write_IAP()
//    Write to IAP address one byte
//    Write data R5  
//    IAP Address High Byte R6
//    IAP Address Low Byte  R7
//    Return ISPCR to R7 for Check CFAIL bit
//
///////////////////////////////////////////////////
IAP_Write_Byte:
      PUSH  ACC

      ANL   CKCON2,#0C0h
      ORL   CKCON2,#((Xtal_Freq-1)AND 0C0h)
      MOV   ISPCR,#080h
      MOV   IFMT,#002h                       //IAP Flash Mode Table (Write Mode)
      MOV   IFADRH,R6                        //IAP Flash Address High Byte
      MOV   IFADRL,R7                        //IAP Flash Address Low Byte
      MOV   IFD,R5                           //Flash data buffer

      MOV   A,Trigger_Check1
      CJNE  A,#055h,Trigger1_Fail
      MOV   SCMD,#046h

      MOV   A,Trigger_Check2
      CJNE  A,#0AAh,Trigger2_Fail
      MOV   SCMD,#0B9h
      MOV   Trigger_Check2,#000h

      MOV   IFMT,#000h
      ANL   ISPCR,#07Fh
      MOV   R7,ISPCR

      POP   ACC
      RET

///////////////////////////////////////////////////
//
//    Display_PASS
//
///////////////////////////////////////////////////
Display_PASS:
      CLR   P1.3
      SETB  P1.2
      RET
      
CSEG  AT    01800h
      DB    055h,0AAh,0BBh,0CCh,0DDh,0FFh  
      END
