///////////////////////////////////////////////////
//
//	FILE:		MPC82x54_SPI_Master.A51
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2007.10.04
//	PURPOSE:	Demo SPI Function
//
///////////////////////////////////////////////////
//#define DEBUG
#ifdef DEBUG
#include "debug.inc"
#endif
#define MEGAWINIC	MPC82G516
#define MPC82x54	1
#define MPC82G516	2
#if (MEGAWINIC==MPC82G516)
#include "REG_MPC82G516.INC"
#else
#include "REG_MPC82L54.INC"
#endif
	ORG		0000H	
	JMP		START
///////////////////////////////////////////////////
//
//	Function:SPI_Interrupt()
//	82G516 SPI interrupt table is 43H
//	82x54 SPI interrupt table is 2BH
//
///////////////////////////////////////////////////
#if (MEGAWINIC==MPC82G516)
	ORG		0043H
#else
	ORG		002BH
#endif
	JMP		SPI_INT
	ORG		0050H
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
START:
///////////////////////////////////////////////////
//
//	Function:SPI_Init()
//	Enable SPEN(Enable SPI) & MSTR(Set to Master Mode)
//
///////////////////////////////////////////////////
#ifdef DEBUG
	MOV		SP,#02FH
	Debug_clear_LCD
#endif
	MOV		SPCTL,#0D0H
	MOV		R1,#00H						//set R0 is data point
	MOV		R2,#00H
FOR_LOOP:
	CLR		P1.4
	MOV		SPDAT,R2
WAIT_TRANSMIT:
	MOV		A,SPSTAT
	CJNE	A,#080H,WAIT_TRANSMIT
	MOV		SPSTAT,#080H
	SETB	P1.4
	MOV		R5,#01AH
DELAY:
	NOP
	DJNZ	R5,DELAY
	INC		R2
	CJNE	R2,#010H,FOR_LOOP
//  enable Interrupt
#if (MEGAWINIC==MPC82G516)
    MOV     IE,#080H
	MOV		AUXIE,#01H
#else
	MOV		IE,#0C0H 
#endif
	MOV		SPCTL,#040H					//Set to Slave mode
MAIN_LOOP:
	CJNE	R1,#0FH,MAIN_LOOP
	MOV		R1,#00H
#ifdef DEBUG
SHOW_LOOP:
	MOVX	A,@R1
;	MOV		A,@R1
	Debug_show_msg_to_LCD ACC
	INC		R1
	CJNE	R1,#010H,SHOW_LOOP
	MOV		R1,#00H
#endif
    SJMP    MAIN_LOOP
SPI_INT:
	MOV		SPSTAT,#080H
	MOV		A,SPDAT
	MOVX	@R1,A
;	MOV		@R1,SPDAT
	INC		R1
	RETI
	END

