///////////////////////////////////////////////////
//
//	FILE:		MPC82G516_2UART_Demo.A51
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2007.5.7
//	PURPOSE:	Demo 2 UART Function
//
///////////////////////////////////////////////////
#include "REG_MPC82G516.INC"

	    ORG		0000H	
	    JMP		START
        ORG		10H
START:
        LCALL   Init_Uart
        LCALL   Init_Uart2
        MOV     DPTR,#0000H
        MOV     R2,#0FFH
FOR_LOOP1:
        MOV     R6,S2CON
        MOV     A,R2
        CPL     A
        MOV     S2BUF,A
WAIT_S2TI:
        MOV     A,S2CON
        XRL     A,R6
        JZ      WAIT_S2TI
        MOV     S2CON,R6
RECEIVER_HEX:
        JNB     RI,RECEIVER_HEX
        CLR     RI
        MOV     A,SBUF
        MOVX    @DPTR,A
        INC     DPTR
        DJNZ    R2,FOR_LOOP1
        MOV     DPTR,#0000H
        MOV     R2,#0FFH
FOR_LOOP2:
        MOV     A,R2
        CPL     A
        ORL     A,#0F0H
        XRL     A,#0F0H
        JNZ     OUTPUT_DATA
        MOV     R7,#0AAH
        LCALL   OUTPUT
        MOV     R7,#0DDH
        LCALL   OUTPUT
OUTPUT_DATA:
        MOVX    A,@DPTR
        MOV     R1,A
        LCALL   OUTPUT_HEX
        INC     DPTR
        DJNZ    R2,FOR_LOOP2
WHILE_LOOP:
        SJMP    WHILE_LOOP
Init_Uart:
        MOV     TMOD,#020H
        MOV     SCON,#050H
        MOV     PCON,#080H
        MOV     TH1,#0F4H
        MOV     TL1,#0F4H
        SETB    TR1
        RET     
Init_Uart2:
        MOV     S2CON,#050H
        MOV     S2BRT,#0F4H
        MOV     AUXR2,#08H
        ORL     AUXR2,#010H
        RET     
///////////////////////////////////////////////////
//
//	Function:OutputHex()
//  Output HEX to Char and a space
//  Data input from R1
//
///////////////////////////////////////////////////
OUTPUT_HEX:
        MOV     A,R1
        SWAP    A
        ANL     A,#0FH
        MOV     R7,A
        LCALL   OUTPUT
        MOV     A,R1
        ANL     A,#0FH
        MOV     R7,A
        LCALL   OUTPUT
        MOV     R7,#020H
        LCALL   OUTPUT
        RET
///////////////////////////////////////////////////
//
//	Function:Output()
//  Output to RS232
//  Data input from R7
//
///////////////////////////////////////////////////
OUTPUT:
        MOV     A,R7
        SETB    C
        SUBB    A,#09H
        JC      IF_1           //IF < 9 JMP 1
        MOV     A,R7
        CLR     C
        SUBB    A,#010H
        JNC     IF_1           //IF > 16 JMP 1
        MOV     A,R7
        ADD     A,#037H
        MOV     SBUF,A
        SJMP    TI_LOOP
IF_1:
        MOV     A,R7
        CLR     C
        SUBB    A,#0AH
        JNC     IF_2
        MOV     A,R7
        ADD     A,#030H
        MOV     SBUF,A
        SJMP    TI_LOOP
IF_2:
        CJNE    R7,#0AAH,IF_3
        MOV     SBUF,#0AH
        SJMP    TI_LOOP
IF_3:
        CJNE    R7,#0DDH,IF_4
        MOV     SBUF,#0DH
        SJMP    TI_LOOP
IF_4:
        MOV     SBUF,R7
TI_LOOP:
        JNB     TI,TI_LOOP
        CLR     TI
        RET
        END
