


$include (REG_MG84FG516.INC)
$include (Delay.inc)

PageP_SFR_Write		EQU	04h
PageP_SFR_Read		EQU	05h

CKCON2			EQU	40h
CKCON3			EQU	41h
PCON2			EQU	44h
PCON3			EQU	45h


;Ctrl_MCU

data_ISP_CTRL SEGMENT DATA
         RSEG   data_ISP_CTRL
var:		DS	1




	CSEG	AT	0000h
	JMP	Start
	


code_main	SEGMENT CODE
	RSEG	code_main
	USING	0

Start:


	ORL	ISPCR, #80h
	MOV	IFMT, #PageP_SFR_Read
	MOV	IFADRH, #00h
	MOV	IFADRL, #CKCON2
	MOV	SCMD, #046h
	MOV	SCMD, #0B9h
	MOV	A, IFD
	
	SETB	ACC.5					;enable XTALE
	
	MOV	IFMT, #PageP_SFR_Write
	MOV	IFADRH, #00h
	MOV	IFADRL, #CKCON2
	MOV	IFD, A
	MOV	SCMD, #046h
	MOV	SCMD, #0B9h
	ANL	ISPCR, #0FEh

	delay_ms	5				;wait circuit stable

	ORL	ISPCR, #80h
	MOV	IFMT, #PageP_SFR_Read
	MOV	IFADRH, #00h
	MOV	IFADRL, #CKCON2
	MOV	SCMD, #046h
	MOV	SCMD, #0B9h
	MOV	A, IFD
	
	SETB	ACC.0					;select MCU clock source
	
	MOV	IFMT, #PageP_SFR_Write
	MOV	IFADRH, #00h
	MOV	IFADRL, #CKCON2
	MOV	IFD, A
	MOV	SCMD, #046h
	MOV	SCMD, #0B9h
	ANL	ISPCR, #0FEh

	MOV	SCON, #0D0h
	MOV	TMOD, #20h
	MOV	TH1, #184d
	MOV	TL1, #184d
	ORL	PCON0, #80h
	ORL	AUXR2, #08h
	SETB	TR1
	
	MOV	S0BUF, #55h
	JNB	TI0, $
	CLR	TI0
	CLR	RI0
Main:
	JNB	RI0, $
	CLR	RI0
	MOV	A, S0BUF
	MOV	S0BUF, A
	JNB	TI0, $
	CLR	TI0

	JMP	Main



	END
