
#define    BYTE        unsigned char

#include "REG_MG84FG516.H"

//----- SPCTL -----//
#define	SSIG				   0x80
#define	SPEN				   0x40
#define	DORD				   0x20
#define	MSTR				   0x10
#define	CPOL				   0x08
#define	CPHA				   0x04
#define	SPR1				   0x02
#define	SPR0				   0x01

//----- SPSTAT -----//
#define	SPIF				   0x80
#define	THRF				   0x20
#define	SPIBSY				   0x10

#define	nCS						P14


void Initial_SPI(void)
{
	SPCON = ( SPEN | SSIG | MSTR);						//enable SPI and set sampling data at rising edge, SPICLK is sysclk / 4.
	P1M0 = 0xB0;										//set P14 to push-pull
}

void SPI_Wr(BYTE Addr, BYTE Dta)
{
	nCS = 0;
	SPDAT = Addr;
	while(SPSTAT & THRF);
	SPDAT = Dta;
	while(SPSTAT & SPIBSY);
	nCS = 1;
	
}

BYTE SPI_Rd(BYTE Addr)
{
	BYTE Dta;

	nCS = 0;
	SPDAT = Addr;
	while(SPSTAT & THRF);
	SPDAT = 0xFF;
	while(SPSTAT & SPIBSY);
	nCS = 1;
	
	Dta = SPDAT;
	return Dta;
}

void main()
{
	Initial_SPI();
	SPI_Wr(0x55, 0xAA);
	P0 = SPI_Rd(0x55);

	while(1);
}
