//swqܼƪAW
typedef unsigned char   uint8;  // LŸ8-bitܼ       
typedef signed   char  	int8;   // Ÿ8-bitܼ       
typedef unsigned int 	uint16; // LŸ16-bitܼ      
typedef signed   int 	int16;  // Ÿ16-bitܼ      
typedef unsigned long  	uint32; // LŸ32-bitܼ      
typedef signed   long  	int32;  // Ÿ32-bitܼ      
typedef float          	fp32;   // ׯBI(32bit)

// MG84FL516

// (System)
sfr ACC       = 0xE0;
sfr B         = 0xF0;
sfr SP        = 0x81;
sfr DPL       = 0x82;
sfr DPH       = 0x83;
sfr PSW       = 0xD0;

// (Interrupt)
sfr IE        = 0xA8;
sfr XICON     = 0xC0;
sfr IP        = 0xB8;
sfr IP0L      = 0xB8;
sfr EIE2      = 0xA5;
sfr EIP2L		  = 0xA6;
sfr EIP2H		  = 0xA7;
sfr EIE1		  = 0xAD;
sfr EIP1L		  = 0xAE;
sfr EIP1H		  = 0xAF;
sfr IP0H		  = 0xB7;

// (I/O Port)
sfr P0        = 0x80;
sfr P1        = 0x90;
sfr P2        = 0xA0;
sfr P3        = 0xB0;
sfr P4        = 0xE8;
sfr P5				= 0xF8;
sfr P6				= 0xF8;
sfr P0M0      = 0x93;
sfr P1M0      = 0x91;
sfr P1AIO     = 0x92;
sfr P2M0      = 0x95;
//sfr P2M1      = 0x96;
sfr P3M0      = 0xB1;
sfr P3M1      = 0xB2;
sfr P4M0      = 0xB3;
sfr P5M0			= 0xB5;
sfr P6M0			= 0xB5;
sfr PUCON0    		= 0xB4;
sfr PUCON1			= 0xB4;

// (Timer)
sfr TCON      = 0x88;
sfr TMOD      = 0x89;
sfr T2CON     		= 0xC8;
sfr T3CON     		= 0xC8;
sfr T2MOD     		= 0xC9;
sfr T3MOD     		= 0xC9;
sfr RCAP2L			= 0xCA;
sfr RCAP2H    		= 0xCB;
sfr RCAP3L    		= 0xCA;
sfr RCAP3H    		= 0xCB;
sfr TL0       = 0x8A;
sfr TH0       = 0x8C;
sfr TL1       = 0x8B;
sfr TH1       = 0x8D;
sfr TL2       		= 0xCC;
sfr TH2       		= 0xCD;
sfr TL3       		= 0xCC;
sfr TH3       		= 0xCD;

// (Serial Port)
sfr SCON0     		= 0x98;
sfr SCON1			= 0x98;
sfr SBUF0    	 	= 0x99;
sfr SBUF1     		= 0x99;
sfr SCFG0     		= 0x9A;
sfr S1BRT 			= 0x9A;
sfr SCFG1     		= 0x9B;
sfr S1BRC 			= 0x9B;
sfr SADDR     = 0xA9;
sfr SADEN     = 0xB9;

// (Keypad Interrupt)
sfr KBCON     = 0xD6;
sfr KBPATN    = 0xD5;
sfr KBMASK    = 0xD7;

// (SPI)
sfr SPSTAT    = 0x84;
sfr SPCON     = 0x85;
sfr SPDAT     = 0x86;

// (TWSI)
sfr SICON     = 0xD4;
sfr SIADR     = 0xD1;
sfr SIDAT     = 0xD2;
sfr SISTA     = 0xD3;

// (PCA)
sfr CCON			= 0xD8;
sfr CMOD			= 0xD9;
sfr CCAPM0		= 0xDA;
sfr CCAPM1		= 0xDB;
sfr CCAPM2		= 0xDC;
sfr CCAPM3		= 0xDD;
sfr CCAPM4		= 0xDE;
sfr CCAPM5		= 0xDF;
sfr CL 			 	= 0xE9;
sfr CCAP0L		= 0xEA;
sfr CCAP1L		= 0xEB;
sfr CCAP2L		= 0xEC;
sfr CCAP3L		= 0xED;
sfr CCAP4L		= 0xEE;
sfr CCAP5L		= 0xEF;
sfr PCAPWM0		= 0xF2;
sfr PCAPWM1		= 0xF3;
sfr PCAPWM2		= 0xF4;
sfr PCAPWM3		= 0xF5;
sfr PCAPWM4		= 0xF6;
sfr PCAPWM5		= 0xF7;
sfr CH 			 	= 0xF9;
sfr CCAP0H		= 0xFA;
sfr CCAP1H		= 0xFB;
sfr CCAP2H		= 0xFC;
sfr CCAP3H		= 0xFD;
sfr CCAP4H		= 0xFE;
sfr CCAP5H		= 0xFF;

// (ADC)
sfr ADCFG0		= 0xC3;
sfr ADCON0		= 0xC4;
sfr ADCDL 		= 0xC5;
sfr ADCDH  		= 0xC6;

// (Others)
sfr PCON0     = 0x87;
sfr PCON1		  = 0x97;
sfr AUXR0     = 0xA1;
sfr AUXR1     = 0xA2;
sfr AUXR2     = 0xA3;
sfr SFRPI 	  = 0xAC;

sfr CKCON    = 0xC7;
sfr CKCON0    = 0xC7;
sfr CKCON1    = 0xBF;
sfr SFIE      = 0x8E;
sfr STRETCH	  = 0x8F;
sfr WDTCR     = 0xE1;

// (ISP)
sfr ISPCR     = 0xE7;
sfr IFMT      = 0xE5;
sfr IFD       = 0xE2;
sfr IFADRH    = 0xE3;
sfr IFADRL    = 0xE4;
sfr SCMD      = 0xE6;

// (USB)
sfr USBDAT	  = 0xAA;
sfr USBADR	  = 0xAB;




// (bits in PSW)
sbit CY       = PSW^7;
sbit AC       = PSW^6;
sbit F0       = PSW^5;
sbit RS1      = PSW^4;
sbit RS0      = PSW^3;
sbit OV       = PSW^2;
sbit P        = PSW^0;

// (bits in IE)
sbit EA       = IE^7;
sbit ET2      = IE^5;
sbit ES0      = IE^4;
sbit ET1      = IE^3;
sbit EX1      = IE^2;
sbit ET0      = IE^1;
sbit EX0      = IE^0;

// (bits in IP0L)
sbit PX3L     = IP0L^7;
sbit PX2L     = IP0L^6;
sbit PT2L     = IP0L^5;
sbit PSL      = IP0L^4;
sbit PT1L     = IP0L^3;
sbit PX1L     = IP0L^2;
sbit PT0L     = IP0L^1;
sbit PX0L     = IP0L^0;

// (bits in SCON)
sbit SM0      = SCON0^7;
sbit SM1      = SCON0^6;
sbit SM2      = SCON0^5;
sbit REN      = SCON0^4;
sbit TB8      = SCON0^3;
sbit RB8      = SCON0^2;
sbit TI       = SCON0^1;
sbit RI       = SCON0^0;
sbit FE       = SCON0^7;

// (bits in SCON1)
sbit SM01     = SCON1^7;
sbit SM11     = SCON1^6;
sbit SM21     = SCON1^5;
sbit REN1     = SCON1^4;
sbit TB81     = SCON1^3;
sbit RB81     = SCON1^2;
sbit TI1      = SCON1^1;
sbit RI1      = SCON1^0;

// (bits in TCON)
sbit TF1      = TCON^7;
sbit TR1      = TCON^6;
sbit TF0      = TCON^5;
sbit TR0      = TCON^4;
sbit IE1      = TCON^3;
sbit IT1      = TCON^2;
sbit IE0      = TCON^1;
sbit IT0      = TCON^0;

// (bits in T2CON)
sbit TF2      = T2CON^7;
sbit EXF2     = T2CON^6;
sbit RCLK     = T2CON^5;
sbit TCLK     = T2CON^4;
sbit EXEN2    = T2CON^3;
sbit TR2      = T2CON^2;
sbit C_T2     = T2CON^1;
sbit CP_RL2   = T2CON^0;

// (bits in T3CON)
sbit TF3      = T3CON^7;
sbit EXF3     = T3CON^6;
sbit EXEN3    = T3CON^3;
sbit TR3      = T3CON^2;
sbit CT3      = T3CON^1;


// (bits in XICON)
sbit IT3H     = XICON^7;
sbit EX3      = XICON^6;
sbit IE3      = XICON^5;
sbit IT3      = XICON^4;
sbit IT2H     = XICON^3;
sbit EX2      = XICON^2;
sbit IE2      = XICON^1;
sbit IT2      = XICON^0;


// (bits in P0)
sbit P07      = P0^7;
sbit P06      = P0^6;
sbit P05      = P0^5;
sbit P04      = P0^4;
sbit P03      = P0^3;
sbit P02      = P0^2;
sbit P01      = P0^1;
sbit P00      = P0^0;

// (bits in P1)
sbit P17      = P1^7;
sbit P16      = P1^6;
sbit P15      = P1^5;
sbit P14      = P1^4;
sbit P13      = P1^3;
sbit P12      = P1^2;
sbit P11      = P1^1;
sbit P10      = P1^0;

// (bits in P2)
sbit P27      = P2^7;
sbit P26      = P2^6;
sbit P25      = P2^5;
sbit P24      = P2^4;
sbit P23      = P2^3;
sbit P22      = P2^2;
sbit P21      = P2^1;
sbit P20      = P2^0;

// (bits in P3)
sbit P37      = P3^7;
sbit P36      = P3^6;
sbit P35      = P3^5;
sbit P34      = P3^4;
sbit P33      = P3^3;
sbit P32      = P3^2;
sbit P31      = P3^1;
sbit P30      = P3^0;

// (bits in CCON)
sbit CF   	  = CCON^7;
sbit CR 	    = CCON^6;
sbit CCF5     = CCON^5;
sbit CCF4     = CCON^4;
sbit CCF3     = CCON^3;
sbit CCF2     = CCON^2;
sbit CCF1     = CCON^1;
sbit CCF0     = CCON^0;

// (bits in P4)
sbit P46      = P4^6;
sbit P45      = P4^5;
sbit P44      = P4^4;
sbit P43      = P4^3;
sbit P42      = P4^2;
sbit P41      = P4^1;
sbit P40      = P4^0;

// (bits in P5)
sbit P57      = P5^7;
sbit P56      = P5^6;
sbit P55      = P5^5;
sbit P54      = P5^4;
sbit P53      = P5^3;
sbit P52      = P5^2;
sbit P51      = P5^1;
sbit P50      = P5^0;

// (bits in P6)
sbit P67      = P6^7;
sbit P66      = P6^6;
sbit P65      = P6^5;
sbit P64      = P6^4;
sbit P63      = P6^3;
sbit P62      = P6^2;
sbit P61      = P6^1;
sbit P60      = P6^0;

// (bits in P1, alternate)
sbit T2EX     = P1^1;
sbit T2       = P1^0;

// (bits in P2, alternate)
sbit SPI_CLK  = P2^7;
sbit SPI_MISO = P2^6;
sbit SPI_MOSI = P2^5;
sbit SPI_SS   = P2^4;
sbit I2C_SDA  = P2^1;
sbit I2C_SCL  = P2^0;

// (bits in P3, alternate)
sbit RD       = P3^7;
sbit WR       = P3^6;
sbit T1       = P3^5;
sbit T0       = P3^4;
sbit INT1     = P3^3;
sbit INT0     = P3^2;
sbit TXD      = P3^1;
sbit RXD      = P3^0;
sbit INT3     = P3^7;
sbit INT2     = P3^6;


//#define XBYTE   uCHAR volatile xdata 

#define    USB         ((XBYTE *)0xFF00)
	#define    DCON0       	0xC0	
	#define    DCON1       	0xC1              
	#define    UADDR       	0xD8              
	#define    UPCON       	0xC9
	#define    IEN       	0xD9
	#define    UIE       	0xDA
	#define    UIFLG       	0xDB
	#define    UIE1       	0xDC
	#define    UIFLG1      	0xDD
	#define    EPINDEX     	0xF1
	#define    EPCON       	0xE1
	#define    RXSTAT      	0xE2
	#define    RXDAT      	0xE3
	#define    RXCON       	0xE4
	#define    RXCNT       	0xE6
	#define    TXSTAT      	0xF2
	#define    TXDAT      	0xF3
	#define    TXCON      	0xF4
	#define    TXCNT      	0xF6
	#define    ZROP      	0xCA
	#define    ZFOP      	0xCB
	#define    CDRSTS      	0xCD
	#define    PFTL      	0xCE
	#define    PFTH      	0xCF
	#define    SIOCTL      	0xC2
	
//Page P register
#define IAPLB 	0x03
#define OR09	0x09
#define OR0A	0x0A
#define OR0B	0x0B
#define OR0C	0x0C
#define OR0D	0x0D
#define TSTMD0	0x20
#define CKCON2	0x40
#define CKCON3  0x41
#define PCON2	0x44   
#define PCON3	0x45
#define SPCON0	0x48
#define TSTFLG0	0x4E
#define TSTWD	0x4F
#define	P_PCON0	0x87
#define	P_PCON1	0x97
#define P_CKCON0 	0xC7
#define P_CKCON1 	0xBF
#define P_WDTCR		0xE1
#define P_P4	0xE8
#define P_P6	0xF8

////PCON2
//#define HSE		0x80
//#define IAPO	0x40
//#define	BO1S1	0x20
//#define	BO1S0	0x10
//#define BO1RE	0x08
//#define EBOD1	0x04
//#define BO0RE	0x02
//#define EBOD0	0x01
//
////PCON3
//#define DISLVR	0x80
//#define BODLVW	0x40
//#define	IORCTL	0x20
//#define	URCTL	0x10
//#define AWBOD1	0x08
//#define AWBOD0	0x04
//#define AZCTL	0x02
//#define OCDE	0x01

////T3MOD
//#define T3SP	0x80
//#define TL3X12	0x40
//#define	T3EXH	0x20
//#define	T3X12	0x10
//#define T3OE	0x02
//


////
//#define 	0x80
//#define 	0x40
//#define		0x20
//#define		0x10
//#define 	0x08
//#define 	0x04
//#define 	0x02
//#define 	0x01

