
#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#include "REG_MG84FG516.H"


#define    ISP_ENABLE          0x80              // Set ISP Enable
#define    ISP_DISABLE         0x00              // Set ISP Disable

void IAP_Erase(uCHAR AddrH, uCHAR AddrL)
{
	ISPCR = ISP_ENABLE;
	IFADRH = AddrH;
	IFADRL = AddrL;
	IFMT = 0x03;								//erase
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
}

void IAP_Program(uCHAR AddrH, uCHAR AddrL, uCHAR Dta)
{
	ISPCR = ISP_ENABLE;
	IFADRH = AddrH;
	IFADRL = AddrL;
	IFD = Dta;
	IFMT = 0x02;								//program
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
}

uCHAR IAP_Read(uCHAR AddrH, uCHAR AddrL)
{
	uCHAR Dta;

	ISPCR = ISP_ENABLE;
	IFADRH = AddrH;
	IFADRL = AddrL;
	IFMT = 0x01;								//read
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;

	Dta = IFD;
	return Dta;
}

void main()
{

	IAP_Erase(0xF0, 0x00);
	IAP_Program(0xF0, 0x00, 0x55);
	IAP_Program(0xF0, 0x01, 0xAA);
	IAP_Program(0xF0, 0x02, 0x5A);
	IAP_Program(0xF0, 0x03, 0xA5);

	P0 = IAP_Read(0xF0, 0x00);
	P1 = IAP_Read(0xF0, 0x01);
	P2 = IAP_Read(0xF0, 0x02);
	P3 = IAP_Read(0xF0, 0x03);

	P57 = 0;
	while(1);
}
